/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.mobs.util;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.entity.ai.mobs.util.BarbarianEventUtils;
import com.minecolonies.coremod.entity.ai.mobs.util.PirateEventUtils;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class MobEventsUtils {
    private static final int SPAWN_MODIFIER = 3;

    private MobEventsUtils() {
    }

    public static void raiderEvent(World world, Colony colony) {
        if (world == null || !colony.isCanHaveBarbEvents()) {
            return;
        }
        Horde horde = MobEventsUtils.numberOfSpawns(colony);
        int hordeSize = horde.hordeSize;
        if (hordeSize == 0) {
            return;
        }
        BlockPos targetSpawnPoint = MobEventsUtils.calculateSpawnLocation(world, colony);
        Log.getLogger().info("[BarbarianEvent]: Spawning: " + targetSpawnPoint.func_177958_n() + " " + targetSpawnPoint.func_177952_p());
        if (targetSpawnPoint.equals((Object)colony.getCenter()) || targetSpawnPoint.func_177956_o() > Configurations.gameplay.maxYForBarbarians) {
            return;
        }
        if (Configurations.gameplay.enableInDevelopmentFeatures) {
            LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "Horde Spawn Point: " + targetSpawnPoint, new Object[0]);
        }
        colony.getRaiderManager().addRaiderSpawnPoint(targetSpawnPoint);
        colony.markDirty();
        int raidNumber = 4;
        String shipSize = "big_pirate_ship";
        if (hordeSize < 5) {
            raidNumber = 1;
            shipSize = "small_pirate_ship";
        } else if (hordeSize < 10) {
            raidNumber = 2;
            shipSize = "medium_pirate_ship";
        } else if (hordeSize < 20) {
            raidNumber = 3;
            shipSize = "medium_pirate_ship";
        }
        colony.setNightsSinceLastRaid(0);
        Structure structure = new Structure(world, "schematics/Ships/" + shipSize, new PlacementSettings());
        structure.rotate(BlockPosUtil.getRotationFromRotations(0), world, targetSpawnPoint, Mirror.NONE);
        if (world.func_180495_p(targetSpawnPoint).func_185904_a() == Material.field_151586_h && MobEventsUtils.isSurfaceAreaMostlyWater((IBlockAccess)world, targetSpawnPoint.func_177982_a(-structure.getOffset().func_177958_n(), 0, -structure.getOffset().func_177952_p()), targetSpawnPoint.func_177982_a(structure.getWidth() - 1, 0, structure.getLength() - 1).func_177973_b((Vec3i)structure.getOffset()), 0.8) || world.func_180495_p(targetSpawnPoint.func_177977_b()).func_185904_a() == Material.field_151586_h && MobEventsUtils.isSurfaceAreaMostlyWater((IBlockAccess)world, targetSpawnPoint.func_177982_a(-structure.getOffset().func_177958_n(), 0, -structure.getOffset().func_177952_p()).func_177977_b(), targetSpawnPoint.func_177982_a(structure.getWidth() - 1, structure.getHeight(), structure.getLength() - 1).func_177973_b((Vec3i)structure.getOffset()).func_177977_b(), 0.8)) {
            if (world.func_180495_p(targetSpawnPoint).func_185904_a() != Material.field_151586_h) {
                targetSpawnPoint = targetSpawnPoint.func_177977_b();
            }
            PirateEventUtils.pirateEvent(targetSpawnPoint, world, colony, shipSize, raidNumber);
            return;
        }
        BarbarianEventUtils.barbarianEvent(world, colony, targetSpawnPoint, raidNumber, horde);
    }

    public static boolean isSurfaceAreaMostlyWater(@NotNull IBlockAccess world, @NotNull BlockPos from, @NotNull BlockPos to, @NotNull double percentRequired) {
        int xDist = Math.abs(from.func_177958_n() - to.func_177958_n());
        int zDist = Math.abs(from.func_177952_p() - to.func_177952_p());
        int nonWaterBlocks = 0;
        int neededWaterBlocks = (int)(percentRequired * (double)(xDist * zDist));
        int nonWaterBlockThreshold = xDist * zDist - neededWaterBlocks;
        int xDir = 1;
        int zDir = 1;
        if (from.func_177958_n() > to.func_177958_n()) {
            xDir = -1;
        }
        if (from.func_177952_p() > to.func_177952_p()) {
            zDir = -1;
        }
        for (int x = 0; x < xDist; ++x) {
            for (int z = 0; z < zDist; ++z) {
                if (world.func_180495_p(from.func_177982_a(x * xDir, 0, z * zDir)).func_185904_a() == Material.field_151586_h && world.func_175623_d(from.func_177982_a(x * xDir, 1, z * zDir)) || ++nonWaterBlocks <= nonWaterBlockThreshold) continue;
                return false;
            }
        }
        return true;
    }

    private static Horde numberOfSpawns(Colony colony) {
        if (colony.getCitizenManager().getCitizens().size() < 5) {
            return new Horde(0, 0, 0, 0);
        }
        int raidLevel = Math.min(Configurations.gameplay.maxBarbarianSize, (int)((double)(MobEventsUtils.getColonyRaidLevel(colony) / 3) * ((double)Configurations.gameplay.spawnBarbarianSize * 0.1)));
        int numberOfChiefs = Math.max(1, (int)((double)raidLevel * 0.1));
        int numberOfArchers = Math.max(1, (int)((double)raidLevel * 0.3));
        int numberOfBarbarians = raidLevel - numberOfChiefs - numberOfArchers;
        return new Horde(raidLevel, numberOfBarbarians, numberOfArchers, numberOfChiefs);
    }

    private static BlockPos calculateSpawnLocation(World world, @NotNull Colony colony) {
        Random random = new Random();
        BlockPos pos = colony.getRaiderManager().getRandomOutsiderInDirection(random.nextInt(2) < 1 ? EnumFacing.EAST : EnumFacing.WEST, random.nextInt(2) < 1 ? EnumFacing.NORTH : EnumFacing.SOUTH);
        if (pos.equals((Object)colony.getCenter())) {
            Log.getLogger().info("Spawning at colony center: " + colony.getCenter().func_177958_n() + " " + colony.getCenter().func_177952_p());
            return colony.getCenter();
        }
        return BlockPosUtil.findLand(pos, world);
    }

    public static int getColonyRaidLevel(Colony colony) {
        int levels = 0;
        ArrayList<CitizenData> citizensList = new ArrayList<CitizenData>(colony.getCitizenManager().getCitizens());
        for (CitizenData citizen : citizensList) {
            levels += citizen.getLevel();
        }
        return levels;
    }

    public static boolean isItTimeToRaid(World world, Colony colony) {
        if (colony.getCitizenManager().getCitizens().size() < 5) {
            return false;
        }
        if (world.func_72935_r() && !colony.isHasRaidBeenCalculated()) {
            colony.getRaiderManager().setHasRaidBeenCalculated(true);
            if (!colony.hasWillRaidTonight()) {
                boolean raid = MobEventsUtils.raidThisNight(world, colony);
                if (Configurations.gameplay.enableInDevelopmentFeatures) {
                    LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "Will raid tonight: " + raid, new Object[0]);
                }
                colony.getRaiderManager().setWillRaidTonight(raid);
            }
            return false;
        }
        if (colony.hasWillRaidTonight() && !world.func_72935_r() && colony.isHasRaidBeenCalculated()) {
            colony.getRaiderManager().setHasRaidBeenCalculated(false);
            colony.getRaiderManager().setWillRaidTonight(false);
            if (Configurations.gameplay.enableInDevelopmentFeatures) {
                LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "Night reached: raiding", new Object[0]);
            }
            return true;
        }
        if (!world.func_72935_r() && colony.isHasRaidBeenCalculated()) {
            colony.getRaiderManager().setHasRaidBeenCalculated(false);
        }
        return false;
    }

    private static boolean raidThisNight(World world, Colony colony) {
        return colony.getNightsSinceLastRaid() > Configurations.gameplay.minimumNumberOfNightsBetweenRaids && world.field_73012_v.nextDouble() < 1.0 / (double)Configurations.gameplay.averageNumberOfNightsBetweenRaids;
    }

    protected static class Horde {
        protected final int numberOfRaiders;
        protected final int numberOfArchers;
        protected final int numberOfBosses;
        protected final int hordeSize;

        Horde(int hordeSize, int numberOfRaiders, int numberOfArchers, int numberOfBosses) {
            this.hordeSize = hordeSize;
            this.numberOfRaiders = numberOfRaiders;
            this.numberOfArchers = numberOfArchers;
            this.numberOfBosses = numberOfBosses;
        }
    }
}

