/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.mobs.aitasks;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.CompatibilityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;

public class EntityAIAttackArcher
extends EntityAIBase {
    private static final int MAX_ATTACK_DELAY = 80;
    private static final double PITCH_MULTIPLIER = 0.4;
    private static final double HALF_ROTATION = 180.0;
    private static final double ATTACK_SPEED = 1.3;
    private static final int MUTEX_BITS = 3;
    private static final double AIM_HEIGHT = 3.0;
    private static final double ARROW_SPEED = 1.6;
    private static final double HIT_CHANCE = 10.0;
    private static final double AIM_SLIGHTLY_HIGHER_MULTIPLIER = (double)0.2f;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_DIVIDER = 1.0;
    private static final double MAX_ATTACK_DISTANCE = 20.0;
    private final EntityCreature entity;
    private EntityLivingBase target;
    private int lastAttack = 0;
    private int tickTimer = 0;

    public EntityAIAttackArcher(EntityCreature creatureIn) {
        this.entity = creatureIn;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        this.target = this.entity.func_70638_az();
        return this.target != null;
    }

    public boolean func_75253_b() {
        this.target = this.entity.func_70638_az();
        if (this.target != null && this.target.func_70089_S() && this.entity.func_70089_S()) {
            this.attack(this.target);
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.attack(this.target);
    }

    private void attack(EntityLivingBase target) {
        if (this.tickTimer > 0) {
            --this.tickTimer;
            --this.lastAttack;
            return;
        }
        this.tickTimer = 10;
        if ((double)this.entity.func_70032_d((Entity)target) >= 20.0 || !this.entity.func_70685_l((Entity)target)) {
            this.entity.func_70661_as().func_75497_a((Entity)target, 1.3);
        } else {
            if ((double)this.entity.func_70032_d((Entity)target) < 20.0) {
                this.entity.func_70661_as().func_75499_g();
            }
            if (this.lastAttack <= 0 && this.entity.func_70685_l((Entity)target)) {
                EntityTippedArrow arrowEntity = new EntityTippedArrow(CompatibilityUtils.getWorld((Entity)this.entity), (EntityLivingBase)this.entity);
                double xVector = target.field_70165_t - this.entity.field_70165_t;
                double yVector = target.func_174813_aQ().field_72338_b + (double)target.field_70131_O / 3.0 - arrowEntity.field_70163_u;
                double zVector = target.field_70161_v - this.entity.field_70161_v;
                double distance = MathHelper.func_76133_a((double)(xVector * xVector + zVector * zVector));
                arrowEntity.func_70186_c(xVector, yVector + distance * (double)0.2f, zVector, 1.6f, 10.0f);
                this.entity.func_70625_a((Entity)target, 180.0f, 180.0f);
                this.entity.func_70671_ap().func_75651_a((Entity)target, 180.0f, 180.0f);
                CompatibilityUtils.spawnEntity(CompatibilityUtils.getWorld((Entity)this.entity), (Entity)arrowEntity);
                this.entity.func_184609_a(EnumHand.MAIN_HAND);
                this.entity.func_184185_a(SoundEvents.field_187866_fi, 1.0f, (float)this.getRandomPitch());
                this.lastAttack = this.getAttackDelay();
            }
        }
        if (this.lastAttack > 0) {
            --this.lastAttack;
        }
    }

    protected int getAttackDelay() {
        return 80 - Configurations.gameplay.barbarianHordeDifficulty * 4;
    }

    private double getRandomPitch() {
        return 1.0 / (this.entity.func_70681_au().nextDouble() * 0.4 + 0.8);
    }
}

