/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.Lists;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractCraftingProductionResolver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicWorkerCraftingProductionResolver
extends AbstractCraftingProductionResolver<PublicCrafting> {
    public PublicWorkerCraftingProductionResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token, PublicCrafting.class);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends PublicCrafting> completedRequest) {
        IColony colony = manager.getColony();
        if (colony instanceof Colony || !completedRequest.hasParent()) {
            IRequest<?> parentRequest = manager.getRequestForToken((IToken<?>)completedRequest.getParent());
            IRequester parentRequestRequester = parentRequest.getRequester();
            ArrayList deliveries = Lists.newArrayList();
            completedRequest.getDeliveries().forEach(parentRequest::addDelivery);
            completedRequest.getDeliveries().forEach(itemStack -> {
                Delivery delivery = new Delivery(this.getRequesterLocation(), parentRequestRequester.getDeliveryLocation(), (ItemStack)itemStack);
                IToken<?> requestToken = manager.createRequest(this, delivery);
                deliveries.add(manager.getRequestForToken(requestToken));
            });
            return deliveries;
        }
        return null;
    }

    @Override
    @Nullable
    public IRequest<?> onRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends PublicCrafting> request) {
        if (!manager.getColony().getWorld().field_72995_K) {
            Colony colony = (Colony)manager.getColony();
            CitizenData holdingCrafter = colony.getCitizenManager().getCitizens().stream().filter(c -> c.getJob() instanceof AbstractJobCrafter && (((AbstractJobCrafter)c.getJob()).getTaskQueue().contains(request.getToken()) || ((AbstractJobCrafter)c.getJob()).getAssignedTasks().contains(request.getToken()))).findFirst().orElse(null);
            if (holdingCrafter == null) {
                MineColonies.getLogger().error("Parent cancellation of crafting production failed! Unknown request: " + request.getToken());
            } else {
                AbstractJobCrafter job = (AbstractJobCrafter)holdingCrafter.getJob();
                job.onTaskDeletion((IToken<?>)request.getToken());
            }
        }
        return null;
    }

    @Override
    public void onRequestBeingOverruled(@NotNull IRequestManager manager, @NotNull IRequest<? extends PublicCrafting> request) {
        this.onRequestCancelled(manager, request);
    }

    @Override
    @NotNull
    public void onRequestComplete(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
    }

    @Override
    @NotNull
    public void onRequestCancelled(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        this.onRequestCancelled(manager, (IRequest<? extends PublicCrafting>)Objects.requireNonNull(manager.getRequestForToken(token)));
    }

    @Override
    protected boolean canBuildingCraftStack(@NotNull IRequestManager manager, @NotNull AbstractBuildingWorker building, @NotNull ItemStack stack) {
        if (manager.getColony().getWorld().field_72995_K) {
            return false;
        }
        return building.getAssignedCitizen().stream().anyMatch(c -> c.getJob() instanceof AbstractJobCrafter);
    }

    @Override
    protected void onAssignedToThisResolverForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends PublicCrafting> request, boolean simulation, @NotNull AbstractBuilding building) {
        if (manager.getColony().getWorld().field_72995_K) {
            return;
        }
        CitizenData freeCrafter = building.getAssignedCitizen().stream().filter(c -> c.getJob() instanceof AbstractJobCrafter).min(Comparator.comparing(c -> ((AbstractJobCrafter)c.getJob()).getTaskQueue().size() + ((AbstractJobCrafter)c.getJob()).getAssignedTasks().size())).orElse(null);
        if (freeCrafter == null) {
            this.onRequestCancelled(manager, request);
            return;
        }
        AbstractJobCrafter job = (AbstractJobCrafter)freeCrafter.getJob();
        job.onTaskBeingScheduled((IToken<?>)request.getToken());
    }

    @Override
    public void resolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends PublicCrafting> request, @NotNull AbstractBuilding building) {
        if (manager.getColony().getWorld().field_72995_K) {
            return;
        }
        CitizenData freeCrafter = building.getAssignedCitizen().stream().filter(c -> c.getJob() instanceof AbstractJobCrafter).filter(c -> ((AbstractJobCrafter)c.getJob()).getAssignedTasks().contains(request.getToken())).findFirst().orElse(null);
        if (freeCrafter == null) {
            this.onRequestCancelled(manager, request);
            return;
        }
        AbstractJobCrafter job = (AbstractJobCrafter)freeCrafter.getJob();
        job.onTaskBeingResolved((IToken<?>)request.getToken());
    }
}

