/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractBuildingDependentRequestResolver;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingRequestResolver
extends AbstractBuildingDependentRequestResolver<IDeliverable> {
    public BuildingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public TypeToken<? extends IDeliverable> getRequestType() {
        return TypeConstants.DELIVERABLE;
    }

    @Override
    public boolean canResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        ArrayList<TileEntityColonyBuilding> tileEntities = new ArrayList<TileEntityColonyBuilding>();
        tileEntities.add(building.getTileEntity());
        tileEntities.addAll(building.getAdditionalCountainers().stream().map(arg_0 -> ((World)manager.getColony().getWorld()).func_175625_s(arg_0)).collect(Collectors.toSet()));
        tileEntities.removeIf(Objects::isNull);
        if (building.getCitizenForRequest((IToken)request.getToken()).isPresent() && building.getCitizenForRequest((IToken)request.getToken()).get().isRequestAsync((IToken)request.getToken())) {
            return false;
        }
        return tileEntities.stream().map(tileEntity -> InventoryUtils.filterProvider((ICapabilityProvider)tileEntity, itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack))).anyMatch(itemStacks -> !itemStacks.isEmpty());
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        return Lists.newArrayList();
    }

    @Override
    public void resolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        ArrayList<TileEntityColonyBuilding> tileEntities = new ArrayList<TileEntityColonyBuilding>();
        tileEntities.add(building.getTileEntity());
        int total = request.getRequest().getCount();
        AtomicInteger current = new AtomicInteger(0);
        tileEntities.stream().map(tileEntity -> InventoryUtils.filterProvider((ICapabilityProvider)tileEntity, itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack))).filter(itemStacks -> !itemStacks.isEmpty()).flatMap(Collection::stream).forEach(stack -> {
            if (current.get() < total) {
                request.addDelivery((ItemStack)stack);
                current.getAndAdd(stack.func_190916_E());
            }
        });
        manager.updateRequestState((IToken<?>)request.getToken(), RequestState.COMPLETED);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        return null;
    }

    @Override
    @Nullable
    public IRequest<?> onRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        return null;
    }

    @Override
    @Nullable
    public void onRequestBeingOverruled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onRequestComplete(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
    }

    @Override
    public void onRequestCancelled(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
    }
}

