/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.locations;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.location.ILocationFactory;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityLocation
implements ILocation {
    @NotNull
    private final UUID uuid;
    @Nullable
    private WeakReference<Entity> entity;

    EntityLocation(@NotNull UUID uuid) {
        this.uuid = uuid;
        this.checkEntity();
    }

    private void checkEntity() {
        if (this.entity != null) {
            return;
        }
        this.entity = new WeakReference<Entity>(FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(this.uuid));
    }

    @Override
    @NotNull
    public BlockPos getInDimensionLocation() {
        this.checkEntity();
        if (this.entity == null || this.entity.get() == null) {
            return BlockPos.field_177992_a;
        }
        return ((Entity)this.entity.get()).func_180425_c();
    }

    @Override
    public int getDimension() {
        this.checkEntity();
        if (this.entity == null || this.entity.get() == null) {
            return 0;
        }
        return ((Entity)this.entity.get()).field_71093_bK;
    }

    @Override
    public boolean isReachableFromLocation(@NotNull ILocation location) {
        this.checkEntity();
        return this.entity != null && this.entity.get() != null && location.getDimension() == this.getDimension();
    }

    public static class Factory
    implements ILocationFactory<Entity, EntityLocation> {
        private static final String NBT_MSB = "Id_MSB";
        private static final String NBT_LSB = "Id_LSB";

        @Override
        @NotNull
        public TypeToken<EntityLocation> getFactoryOutputType() {
            return TypeToken.of(EntityLocation.class);
        }

        @Override
        @NotNull
        public TypeToken<Entity> getFactoryInputType() {
            return TypeToken.of(Entity.class);
        }

        @Override
        @NotNull
        public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull EntityLocation request) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74772_a(NBT_LSB, request.uuid.getLeastSignificantBits());
            compound.func_74772_a(NBT_MSB, request.uuid.getMostSignificantBits());
            return compound;
        }

        @Override
        @NotNull
        public EntityLocation deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
            UUID uuid = new UUID(nbt.func_74763_f(NBT_MSB), nbt.func_74763_f(NBT_LSB));
            return new EntityLocation(uuid);
        }

        @Override
        @NotNull
        public EntityLocation getNewInstance(@NotNull IFactoryController factoryController, @NotNull Entity input) {
            return new EntityLocation(input.getPersistentID());
        }
    }
}

