/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.pvp;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.mobs.util.MobEventsUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;

public class AttackingPlayer {
    private final EntityPlayer player;
    private final List<EntityCitizen> guards = new ArrayList<EntityCitizen>();

    public AttackingPlayer(EntityPlayer player) {
        this.player = player;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public List<EntityCitizen> getGuards() {
        return ImmutableList.copyOf(this.guards);
    }

    public boolean addGuard(EntityCitizen guard) {
        if (!this.guards.contains((Object)guard)) {
            this.guards.add(guard);
            return true;
        }
        return false;
    }

    public void removeGuard(EntityCitizen guard) {
        this.guards.add(guard);
    }

    public boolean isValidAttack(Colony colony) {
        if (this.guards.isEmpty()) {
            return false;
        }
        return AttackingPlayer.isValidAttack(this.guards.get(0), colony);
    }

    public static boolean isValidAttack(EntityCitizen citizen, Colony colony) {
        Colony guardColony = citizen.getCitizenColonyHandler().getColony();
        if (guardColony == null) {
            return false;
        }
        if (colony.getPermissions().getRank(guardColony.getPermissions().getOwner()) == Rank.HOSTILE) {
            return true;
        }
        return guardColony.getPermissions().getRank(colony.getPermissions().getOwner()) == Rank.HOSTILE && MobEventsUtils.getColonyRaidLevel(guardColony) <= MobEventsUtils.getColonyRaidLevel(colony) * 2;
    }

    public void refreshList(Colony colony) {
        for (EntityCitizen citizen : new ArrayList<EntityCitizen>(this.guards)) {
            if (!citizen.field_70128_L && colony.isCoordInColony(colony.getWorld(), citizen.func_180425_c())) continue;
            this.guards.remove((Object)citizen);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttackingPlayer that = (AttackingPlayer)o;
        return Objects.equals(this.player, that.player);
    }

    public int hashCode() {
        return Objects.hash(this.player);
    }
}

