/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.sounds.ArcherSounds;
import com.minecolonies.coremod.sounds.KnightSounds;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJobGuard
extends AbstractJob {
    public AbstractJobGuard(CitizenData entity) {
        super(entity);
    }

    protected abstract AbstractEntityAIGuard generateGuardAI();

    @Override
    public AbstractAISkeleton<? extends AbstractJob> generateAI() {
        return this.generateGuardAI();
    }

    @Override
    public void triggerDeathAchievement(DamageSource source, EntityCitizen citizen) {
        super.triggerDeathAchievement(source, citizen);
        if (source.func_76346_g() instanceof EntityEnderman && citizen.getCitizenColonyHandler().getColony() != null) {
            citizen.getCitizenColonyHandler().getColony().getStatsManager().triggerAchievement(ModAchievements.achievementGuardDeathEnderman);
        }
    }

    @Override
    public void onLevelUp(int newLevel) {
        if (this.getCitizen().getCitizenEntity().isPresent()) {
            this.getCitizen().getCitizenEntity().get().increaseHPForGuards();
        }
    }

    @Override
    @Nullable
    public SoundEvent getBadWeatherSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? ArcherSounds.Female.badWeather : KnightSounds.Male.badWeather;
        }
        return null;
    }

    @Override
    public SoundEvent getBedTimeSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? ArcherSounds.Female.offToBed : KnightSounds.Male.offToBed;
        }
        return null;
    }
}

