/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingContainer
extends AbstractCitizenAssignable
implements ICapabilityProvider {
    protected final List<BlockPos> containerList = new ArrayList<BlockPos>();
    protected final Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> keepX = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>();
    private TileEntityColonyBuilding tileEntity;
    private int pickUpPriority = 1;
    private boolean priorityStatic = false;

    public AbstractBuildingContainer(BlockPos pos, Colony colony) {
        super(pos, colony);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList containerTagList = compound.func_150295_c("Containers", 10);
        for (int i = 0; i < containerTagList.func_74745_c(); ++i) {
            NBTTagCompound containerCompound = containerTagList.func_150305_b(i);
            this.containerList.add(NBTUtil.func_186861_c((NBTTagCompound)containerCompound));
        }
        if (compound.func_74764_b("prio")) {
            this.pickUpPriority = compound.func_74762_e("prio");
        }
        if (compound.func_74764_b("prioMode")) {
            this.priorityStatic = compound.func_74767_n("prioMode");
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList containerTagList = new NBTTagList();
        for (BlockPos pos : this.containerList) {
            containerTagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        }
        compound.func_74782_a("Containers", (NBTBase)containerTagList);
        compound.func_74768_a("prio", this.pickUpPriority);
        compound.func_74757_a("prioMode", this.priorityStatic);
    }

    public int getPickUpPriority() {
        return this.pickUpPriority;
    }

    public void alterPickUpPriority(int value) {
        this.pickUpPriority = this.pickUpPriority + value < 1 ? 1 : (this.pickUpPriority + value > 10 ? 10 : (this.pickUpPriority += value));
    }

    public boolean isPriorityStatic() {
        return this.priorityStatic;
    }

    public void alterPriorityState() {
        this.priorityStatic = !this.priorityStatic;
    }

    public void addContainerPosition(@NotNull BlockPos pos) {
        if (!this.containerList.contains(pos)) {
            this.containerList.add(pos);
        }
    }

    public void removeContainerPosition(BlockPos pos) {
        this.containerList.remove(pos);
    }

    public List<BlockPos> getAdditionalCountainers() {
        return new ArrayList<BlockPos>(this.containerList);
    }

    public void registerBlockPosition(@NotNull IBlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        this.registerBlockPosition(blockState.func_177230_c(), pos, world);
    }

    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block instanceof BlockContainer || block instanceof BlockMinecoloniesRack) {
            this.addContainerPosition(pos);
        }
    }

    public ItemStack transferStack(@NotNull ItemStack stack, @NotNull World world) {
        if (this.tileEntity == null || InventoryUtils.isProviderFull((ICapabilityProvider)this.tileEntity)) {
            Iterator<BlockPos> posIterator = this.containerList.iterator();
            ItemStack resultStack = stack.func_77946_l();
            while (posIterator.hasNext() && !ItemStackUtils.isEmpty(resultStack).booleanValue()) {
                BlockPos pos = posIterator.next();
                TileEntity tempTileEntity = world.func_175625_s(pos);
                if (!(tempTileEntity instanceof TileEntityChest) || InventoryUtils.isProviderFull((ICapabilityProvider)tempTileEntity)) continue;
                resultStack = InventoryUtils.addItemStackToProviderWithResult((ICapabilityProvider)tempTileEntity, stack);
            }
            return resultStack;
        }
        return InventoryUtils.addItemStackToProviderWithResult((ICapabilityProvider)this.tileEntity, stack);
    }

    public void setTileEntity(TileEntityColonyBuilding te) {
        this.tileEntity = te;
    }

    public TileEntityColonyBuilding getTileEntity() {
        if ((this.tileEntity == null || this.tileEntity.func_145837_r()) && this.colony != null && this.colony.getWorld() != null && this.getLocation() != null && this.colony.getWorld().func_180495_p(this.getLocation()) != Blocks.field_150350_a && this.colony.getWorld().func_180495_p(this.getLocation()).func_177230_c() instanceof AbstractBlockHut) {
            TileEntity te = this.getColony().getWorld().func_175625_s(this.getLocation());
            if (te instanceof TileEntityColonyBuilding) {
                this.tileEntity = (TileEntityColonyBuilding)te;
                if (this.tileEntity.getBuilding() == null) {
                    this.tileEntity.setColony(this.colony);
                    this.tileEntity.setBuilding(this);
                }
            } else {
                Log.getLogger().error("Somehow the wrong TileEntity is at the location where the building should be!");
                Log.getLogger().error("Trying to restore order!");
                this.colony.getWorld().func_175690_a(this.getLocation(), (TileEntity)new TileEntityColonyBuilding());
            }
        }
        return this.tileEntity;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null && this.getTileEntity() != null) {
            return this.tileEntity.getCapability(capability, facing);
        }
        return null;
    }
}

