/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.configuration.NameConfiguration;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracksTower;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.registry.JobRegistry;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.citizenhandlers.CitizenHappinessHandler;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.util.TeleportHelper;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenData {
    public static final int MAX_SATURATION = 10;
    private static final float MAX_HEALTH = 20.0f;
    private static final int LETTERS_IN_THE_ALPHABET = 26;
    private static final int MIN_SATURATION = 0;
    private static final int CHANCE_TO_LEVEL = 50;
    private static final int AMOUNT_OF_SKILLS = 5;
    private final int id;
    private final Colony colony;
    private final InventoryCitizen inventory;
    private String name;
    private boolean female;
    private boolean isChild = false;
    private boolean paused;
    private boolean restartScheduled;
    private EntityPlayerMP originPlayerRestart;
    private int textureId;
    private boolean isAsleep;
    private BlockPos bedPos = BlockPos.field_177992_a;
    @Nullable
    private AbstractBuilding homeBuilding;
    @Nullable
    private AbstractBuildingWorker workBuilding;
    private AbstractJob job;
    private boolean dirty;
    private static final int MIN_STAT = 1;
    @NotNull
    private WeakReference<EntityCitizen> entity;
    private int strength;
    private int endurance;
    private int charisma;
    private int intelligence;
    private int dexterity;
    private double health;
    private double maxHealth;
    private double saturation;
    private boolean justAte;
    private Map<String, Tuple<Integer, Double>> levelExperienceMap = new HashMap<String, Tuple<Integer, Double>>();
    private BlockPos lastPosition = new BlockPos(0, 0, 0);
    private final CitizenHappinessHandler citizenHappinessHandler;

    public CitizenData(int id, Colony colony) {
        this.id = id;
        this.colony = colony;
        this.inventory = new InventoryCitizen("Minecolonies Inventory", true, this);
        this.citizenHappinessHandler = new CitizenHappinessHandler(this);
    }

    @NotNull
    public static CitizenData createFromNBT(@NotNull NBTTagCompound compound, Colony colony) {
        int id = compound.func_74762_e("id");
        CitizenData citizen = new CitizenData(id, colony);
        citizen.readFromNBT(compound);
        return citizen;
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.name = compound.func_74779_i("name");
        this.female = compound.func_74767_n("female");
        this.paused = compound.func_74767_n("paused");
        this.isChild = compound.func_74767_n("child");
        this.textureId = compound.func_74762_e("texture");
        this.health = compound.func_74760_g("health");
        this.maxHealth = compound.func_74760_g("maxHealth");
        NBTTagCompound nbtTagSkillsCompound = compound.func_74775_l("skills");
        this.strength = nbtTagSkillsCompound.func_74762_e("strength");
        this.endurance = nbtTagSkillsCompound.func_74762_e("endurance");
        this.charisma = nbtTagSkillsCompound.func_74762_e("charisma");
        this.intelligence = nbtTagSkillsCompound.func_74762_e("intelligence");
        this.dexterity = nbtTagSkillsCompound.func_74762_e("dexterity");
        this.saturation = compound.func_74769_h("saturation");
        if (compound.func_74764_b("job")) {
            this.setJob(JobRegistry.createFromNBT(this, compound.func_74775_l("job")));
        }
        if (compound.func_74764_b("levelMap")) {
            NBTTagList levelTagList = compound.func_150295_c("levelMap", 10);
            for (int i = 0; i < levelTagList.func_74745_c(); ++i) {
                NBTTagCompound levelExperienceAtJob = levelTagList.func_150305_b(i);
                this.levelExperienceMap.put(levelExperienceAtJob.func_74779_i("name"), (Tuple<Integer, Double>)new Tuple((Object)Math.min(levelExperienceAtJob.func_74762_e("level"), 99), (Object)levelExperienceAtJob.func_74769_h("experience")));
            }
        } else if (this.job != null) {
            this.levelExperienceMap.put(this.job.getExperienceTag(), (Tuple<Integer, Double>)new Tuple((Object)compound.func_74762_e("level"), (Object)compound.func_74769_h("experience")));
        }
        if (compound.func_74764_b("inventory")) {
            NBTTagList nbttaglist = compound.func_150295_c("inventory", 10);
            this.inventory.readFromNBT(nbttaglist);
            this.inventory.setHeldItem(EnumHand.MAIN_HAND, compound.func_74762_e("HeldItemSlot"));
            this.inventory.setHeldItem(EnumHand.OFF_HAND, compound.func_74762_e("OffhandHeldItemSlot"));
        }
        if (this.name.isEmpty()) {
            this.name = this.generateName(new Random());
        }
        if (compound.func_74764_b("asleep")) {
            this.bedPos = BlockPosUtil.readFromNBT(compound, "pos");
            this.isAsleep = compound.func_74767_n("asleep");
        }
        if (compound.func_74764_b("justAte")) {
            this.justAte = compound.func_74767_n("justAte");
        }
        this.citizenHappinessHandler.readFromNBT(compound);
    }

    @NotNull
    public Optional<EntityCitizen> getCitizenEntity() {
        if (this.entity == null) {
            return Optional.empty();
        }
        EntityCitizen citizen = (EntityCitizen)((Object)this.entity.get());
        return Optional.ofNullable(citizen);
    }

    public void setCitizenEntity(@Nullable EntityCitizen citizen) {
        if (this.entity != null) {
            this.entity.clear();
        }
        if (citizen != null) {
            this.entity = new WeakReference<EntityCitizen>(citizen);
        }
    }

    public void markDirty() {
        this.dirty = true;
        this.colony.getCitizenManager().markCitizensDirty();
    }

    @Nullable
    public static CitizenDataView createCitizenDataView(int id, ByteBuf buf) {
        CitizenDataView citizenDataView = new CitizenDataView(id);
        try {
            citizenDataView.deserialize(buf);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A CitizenData.View for #%d has thrown an exception during loading, its state cannot be restored. Report this to the mod author", citizenDataView.getId()), (Throwable)ex);
            citizenDataView = null;
        }
        return citizenDataView;
    }

    private static String getRandomElement(@NotNull Random rand, @NotNull String[] array) {
        return array[rand.nextInt(array.length)];
    }

    private static char getRandomLetter(@NotNull Random rand) {
        return (char)(rand.nextInt(26) + 65);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.female ? 1 : 0);
        result = 31 * result + (this.colony != null ? this.colony.hashCode() : 0);
        result = 31 * result + this.strength;
        result = 31 * result + this.endurance;
        result = 31 * result + this.charisma;
        result = 31 * result + this.intelligence;
        result = 31 * result + this.dexterity;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CitizenData data = (CitizenData)o;
        if (this.id != data.id) {
            return false;
        }
        if (this.female != data.female) {
            return false;
        }
        if (this.strength != data.strength) {
            return false;
        }
        if (this.endurance != data.endurance) {
            return false;
        }
        if (this.charisma != data.charisma) {
            return false;
        }
        if (this.intelligence != data.intelligence) {
            return false;
        }
        if (this.dexterity != data.dexterity) {
            return false;
        }
        if (this.name != null ? !this.name.equals(data.name) : data.name != null) {
            return false;
        }
        return this.colony != null ? data.colony != null && this.colony.getID() == data.colony.getID() : data.colony == null;
    }

    public Colony getColony() {
        return this.colony;
    }

    public int getId() {
        return this.id;
    }

    public void initForNewCitizen() {
        Random rand = new Random();
        this.female = rand.nextBoolean();
        this.paused = false;
        this.name = this.generateName(rand);
        this.health = 20.0;
        this.maxHealth = 20.0;
        this.saturation = 10.0;
        int levelCap = (int)this.colony.getOverallHappiness();
        if (levelCap <= 1) {
            this.intelligence = 1;
            this.charisma = 1;
            this.strength = 1;
            this.endurance = 1;
            this.dexterity = 1;
        } else {
            this.intelligence = rand.nextInt(levelCap - 1) + 1;
            this.charisma = rand.nextInt(levelCap - 1) + 1;
            this.strength = rand.nextInt(levelCap - 1) + 1;
            this.endurance = rand.nextInt(levelCap - 1) + 1;
            this.dexterity = rand.nextInt(levelCap - 1) + 1;
        }
        this.markDirty();
    }

    private String generateName(@NotNull Random rand) {
        String firstName = this.female ? CitizenData.getRandomElement(rand, NameConfiguration.names.femaleFirstNames) : CitizenData.getRandomElement(rand, NameConfiguration.names.maleFirstNames);
        String middleInitial = String.valueOf(CitizenData.getRandomLetter(rand));
        String lastName = CitizenData.getRandomElement(rand, NameConfiguration.names.lastNames);
        String citizenName = NameConfiguration.names.useMiddleInitial ? String.format("%s %s. %s", firstName, middleInitial, lastName) : String.format("%s %s", firstName, lastName);
        for (CitizenData citizen : this.getColony().getCitizenManager().getCitizens()) {
            if (citizen == null || !citizen.getName().equals(citizenName)) continue;
            citizenName = this.generateName(rand);
            break;
        }
        return citizenName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFemale() {
        return this.female;
    }

    public void setIsFemale(@NotNull boolean isFemale) {
        this.female = isFemale;
        this.name = this.generateName(new Random());
        this.markDirty();
    }

    public void setPaused(boolean p) {
        this.paused = p;
        this.markDirty();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public void onRemoveBuilding(AbstractBuilding building) {
        if (this.getHomeBuilding() == building) {
            this.setHomeBuilding(null);
        }
        if (this.getWorkBuilding() == building) {
            this.setWorkBuilding(null);
        }
    }

    @Nullable
    public AbstractBuilding getHomeBuilding() {
        return this.homeBuilding;
    }

    public void setHomeBuilding(@Nullable AbstractBuilding building) {
        if (this.homeBuilding != null && building != null && !this.homeBuilding.equals(building)) {
            this.homeBuilding.removeCitizen(this);
            this.markDirty();
        }
        if (building == null || building instanceof BuildingHome || building instanceof BuildingBarracksTower) {
            this.homeBuilding = building;
            this.markDirty();
        }
        if (this.getCitizenEntity().isPresent() && this.getCitizenEntity().get().getCitizenJobHandler().getColonyJob() == null) {
            this.getCitizenEntity().get().getCitizenJobHandler().setModelDependingOnJob(null);
        }
    }

    @Nullable
    public AbstractBuildingWorker getWorkBuilding() {
        return this.workBuilding;
    }

    public void setWorkBuilding(@Nullable AbstractBuildingWorker building) {
        if (this.workBuilding != null && building != null && this.workBuilding != building) {
            Log.getLogger().warn("CitizenData.setWorkBuilding() - already assigned a work building when setting a new work building");
        } else if (this.workBuilding != building) {
            this.workBuilding = building;
            if (this.workBuilding != null) {
                if (this.job == null) {
                    this.setJob(this.workBuilding.createJob(this));
                    this.colony.getWorkManager().clearWorkForCitizen(this);
                }
            } else if (this.job != null) {
                this.getCitizenEntity().ifPresent(entityCitizen -> entityCitizen.field_70714_bg.func_85156_a(((EntityAITasks.EntityAITaskEntry)entityCitizen.field_70714_bg.field_75782_a.stream().filter((Predicate<EntityAITasks.EntityAITaskEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$null$0(net.minecraft.entity.ai.EntityAITasks$EntityAITaskEntry ), (Lnet/minecraft/entity/ai/EntityAITasks$EntityAITaskEntry;)Z)()).findFirst().orElse(null)).field_75733_a));
                this.setJob(null);
                this.colony.getWorkManager().clearWorkForCitizen(this);
            }
            this.markDirty();
        }
    }

    public void updateCitizenEntityIfNecessary() {
        List list = this.colony.getWorld().func_175644_a(EntityCitizen.class, entityCitizen -> entityCitizen.getCitizenColonyHandler().getColonyId() == this.colony.getID() && entityCitizen.getCitizenData().getId() == this.getId());
        if (!list.isEmpty()) {
            this.setCitizenEntity((EntityCitizen)((Object)list.get(0)));
            for (int i = 1; i < list.size(); ++i) {
                Log.getLogger().warn("Removing duplicate entity:" + ((EntityCitizen)((Object)list.get(i))).func_70005_c_());
                this.colony.getWorld().func_72900_e((Entity)list.get(i));
            }
            return;
        }
        this.colony.getCitizenManager().spawnOrCreateCitizen(this, this.colony.getWorld(), null, true);
        this.getCitizenEntity().ifPresent(entityCitizen -> {
            BlockPos location = null;
            if (this.getWorkBuilding() == null) {
                if (this.colony.hasTownHall()) {
                    location = this.colony.getBuildingManager().getTownHall().getLocation();
                }
            } else {
                location = this.getWorkBuilding().getLocation();
            }
            if (location != null) {
                TeleportHelper.teleportCitizen(entityCitizen, this.colony.getWorld(), location);
            }
        });
    }

    public AbstractJob getJob() {
        return this.job;
    }

    public void setJob(AbstractJob job) {
        this.job = job;
        this.getCitizenEntity().ifPresent(entityCitizen -> entityCitizen.getCitizenJobHandler().onJobChanged(job));
        this.markDirty();
    }

    @Nullable
    public <J extends AbstractJob> J getJob(@NotNull Class<J> type) {
        if (type.isInstance(this.job)) {
            return (J)((AbstractJob)type.cast(this.job));
        }
        return null;
    }

    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound compound) {
        compound.func_74768_a("id", this.id);
        compound.func_74778_a("name", this.name);
        compound.func_74757_a("female", this.female);
        compound.func_74757_a("paused", this.paused);
        compound.func_74757_a("child", this.isChild);
        compound.func_74768_a("texture", this.textureId);
        NBTTagList levelTagList = new NBTTagList();
        for (Map.Entry<String, Tuple<Integer, Double>> entry : this.levelExperienceMap.entrySet()) {
            NBTTagCompound levelCompound = new NBTTagCompound();
            levelCompound.func_74778_a("name", entry.getKey());
            levelCompound.func_74768_a("level", ((Integer)entry.getValue().func_76341_a()).intValue());
            levelCompound.func_74780_a("experience", ((Double)entry.getValue().func_76340_b()).doubleValue());
            levelTagList.func_74742_a((NBTBase)levelCompound);
        }
        compound.func_74782_a("levelMap", (NBTBase)levelTagList);
        compound.func_74780_a("health", this.health);
        compound.func_74780_a("maxHealth", this.maxHealth);
        NBTTagCompound nbtTagSkillsCompound = new NBTTagCompound();
        nbtTagSkillsCompound.func_74768_a("strength", this.strength);
        nbtTagSkillsCompound.func_74768_a("endurance", this.endurance);
        nbtTagSkillsCompound.func_74768_a("charisma", this.charisma);
        nbtTagSkillsCompound.func_74768_a("intelligence", this.intelligence);
        nbtTagSkillsCompound.func_74768_a("dexterity", this.dexterity);
        compound.func_74782_a("skills", (NBTBase)nbtTagSkillsCompound);
        compound.func_74780_a("saturation", this.saturation);
        if (this.job != null) {
            NBTTagCompound jobCompound = new NBTTagCompound();
            this.job.writeToNBT(jobCompound);
            compound.func_74782_a("job", (NBTBase)jobCompound);
        }
        compound.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagList()));
        compound.func_74768_a("HeldItemSlot", this.inventory.getHeldItemSlot(EnumHand.MAIN_HAND));
        compound.func_74768_a("OffhandHeldItemSlot", this.inventory.getHeldItemSlot(EnumHand.OFF_HAND));
        BlockPosUtil.writeToNBT(compound, "pos", this.bedPos);
        compound.func_74757_a("asleep", this.isAsleep);
        compound.func_74757_a("justAte", this.justAte);
        this.citizenHappinessHandler.writeToNBT(compound);
        return compound;
    }

    public void serializeViewNetworkData(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        buf.writeBoolean(this.female);
        buf.writeInt(this.getCitizenEntity().map(Entity::func_145782_y).orElse(-1).intValue());
        buf.writeBoolean(this.paused);
        buf.writeBoolean(this.isChild);
        buf.writeBoolean(this.homeBuilding != null);
        if (this.homeBuilding != null) {
            BlockPosUtil.writeToByteBuf(buf, this.homeBuilding.getID());
        }
        buf.writeBoolean(this.workBuilding != null);
        if (this.workBuilding != null) {
            BlockPosUtil.writeToByteBuf(buf, this.workBuilding.getID());
        }
        buf.writeInt(this.getLevel());
        buf.writeDouble(this.getExperience());
        buf.writeFloat(this.getCitizenEntity().map(EntityLivingBase::func_110143_aJ).orElse(Float.valueOf(20.0f)).floatValue());
        buf.writeFloat(this.getCitizenEntity().map(EntityLivingBase::func_110138_aP).orElse(Float.valueOf(20.0f)).floatValue());
        buf.writeInt(this.getStrength());
        buf.writeInt(this.getEndurance());
        buf.writeInt(this.getCharisma());
        buf.writeInt(this.getIntelligence());
        buf.writeInt(this.getDexterity());
        buf.writeDouble(this.getSaturation());
        buf.writeDouble(this.citizenHappinessHandler.getHappiness());
        this.citizenHappinessHandler.serializeViewNetworkData(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.job != null ? this.job.getName() : ""));
        this.writeStatusToBuffer(buf);
        buf.writeInt(this.colony.getID());
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagList()));
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound);
        BlockPosUtil.writeToByteBuf(buf, this.lastPosition);
    }

    private void writeStatusToBuffer(@NotNull ByteBuf buf) {
        Optional<EntityCitizen> optionalEntityCitizen = this.getCitizenEntity();
        buf.writeInt(optionalEntityCitizen.map(entityCitizen -> entityCitizen.getCitizenStatusHandler().getLatestStatus().length).orElse(0).intValue());
        optionalEntityCitizen.ifPresent(entityCitizen -> {
            ITextComponent[] latestStatusArray;
            for (ITextComponent latestStatus : latestStatusArray = entityCitizen.getCitizenStatusHandler().getLatestStatus()) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(latestStatus == null ? "" : latestStatus.func_150260_c()));
            }
        });
    }

    public int getLevel() {
        if (this.job == null) {
            return 0;
        }
        return (Integer)this.queryLevelExperienceMap().func_76341_a();
    }

    public void setLevel(int lvl) {
        if (this.job == null) {
            return;
        }
        Tuple<Integer, Double> entry = this.queryLevelExperienceMap();
        this.levelExperienceMap.put(this.job.getExperienceTag(), (Tuple<Integer, Double>)new Tuple((Object)lvl, entry.func_76340_b()));
    }

    public void addExperience(double xp) {
        if (this.job != null) {
            Tuple<Integer, Double> entry = this.queryLevelExperienceMap();
            this.levelExperienceMap.put(this.job.getExperienceTag(), (Tuple<Integer, Double>)new Tuple(entry.func_76341_a(), (Object)((Double)entry.func_76340_b() + xp)));
        }
    }

    public void levelUp() {
        this.increaseLevel();
        if (this.job != null) {
            Tuple<Integer, Double> entry = this.queryLevelExperienceMap();
            this.job.onLevelUp((Integer)entry.func_76341_a());
        }
    }

    private void increaseLevel() {
        Tuple<Integer, Double> entry;
        if (this.job != null && (Integer)(entry = this.queryLevelExperienceMap()).func_76341_a() < 99) {
            this.levelExperienceMap.put(this.job.getExperienceTag(), (Tuple<Integer, Double>)new Tuple((Object)((Integer)entry.func_76341_a() + 1), entry.func_76340_b()));
        }
    }

    public int getChanceToLevel() {
        return 50;
    }

    public void increaseSaturation(double extraSaturation) {
        this.saturation = Math.min(10.0, this.saturation + Math.abs(extraSaturation));
    }

    public void decreaseSaturation(double extraSaturation) {
        this.saturation = Math.max(0.0, this.saturation - Math.abs(extraSaturation * Configurations.gameplay.foodModifier));
        this.justAte = false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getExperience() {
        if (this.job == null) {
            return 0.0;
        }
        return (Double)this.queryLevelExperienceMap().func_76340_b();
    }

    private Tuple<Integer, Double> queryLevelExperienceMap() {
        return this.levelExperienceMap.computeIfAbsent(this.job.getExperienceTag(), jobKey -> new Tuple((Object)0, (Object)0.0));
    }

    public int getStrength() {
        return this.strength;
    }

    public int getEndurance() {
        return this.endurance;
    }

    public int getCharisma() {
        return this.charisma;
    }

    public int getIntelligence() {
        return this.intelligence;
    }

    public int getDexterity() {
        return this.dexterity;
    }

    public void setLastPosition(BlockPos lastPosition) {
        this.lastPosition = lastPosition;
    }

    public BlockPos getLastPosition() {
        return this.lastPosition;
    }

    public double getSaturation() {
        return this.saturation;
    }

    public InventoryCitizen getInventory() {
        return this.inventory;
    }

    public boolean isAsleep() {
        return this.isAsleep;
    }

    public BlockPos getBedPos() {
        return this.bedPos;
    }

    public void setAsleep(boolean asleep) {
        this.isAsleep = asleep;
    }

    public void setBedPos(BlockPos bedPos) {
        this.bedPos = bedPos;
    }

    public <R extends IRequestable> IToken createRequest(@NotNull R requested) {
        return this.getWorkBuilding().createRequest(this, requested, false);
    }

    public <R extends IRequestable> IToken createRequestAsync(@NotNull R requested) {
        return this.getWorkBuilding().createRequest(this, requested, true);
    }

    public void onRequestCancelled(@NotNull IToken token) {
        if (this.isRequestAsync(token)) {
            this.job.getAsyncRequests().remove(token);
        }
    }

    public boolean isRequestAsync(@NotNull IToken token) {
        if (this.job != null) {
            return this.job.getAsyncRequests().contains(token);
        }
        return false;
    }

    public CitizenHappinessHandler getCitizenHappinessHandler() {
        return this.citizenHappinessHandler;
    }

    public void tryRandomLevelUp(Random random) {
        this.tryRandomLevelUp(random, 0);
    }

    public void tryRandomLevelUp(Random random, int customChance) {
        if (customChance > 0 && random.nextInt(customChance) > 0 || customChance < 1 && random.nextInt(50) > 0) {
            return;
        }
        int levelCap = (int)this.getCitizenHappinessHandler().getHappiness();
        switch (random.nextInt(5)) {
            case 0: {
                this.intelligence = Math.min(this.intelligence + 1, levelCap);
                break;
            }
            case 1: {
                this.charisma = Math.min(this.charisma + 1, levelCap);
                break;
            }
            case 2: {
                this.strength = Math.min(this.strength + 1, levelCap);
                break;
            }
            case 3: {
                this.endurance = Math.min(this.endurance + 1, levelCap);
                break;
            }
            default: {
                this.dexterity = Math.min(this.dexterity + 1, levelCap);
            }
        }
        this.markDirty();
    }

    public void scheduleRestart(EntityPlayerMP player) {
        this.originPlayerRestart = player;
        this.restartScheduled = true;
    }

    public boolean shouldRestart() {
        return this.restartScheduled;
    }

    public void restartDone() {
        this.restartScheduled = false;
        LanguageHandler.sendPlayerMessage((EntityPlayer)this.originPlayerRestart, "com.minecolonies.coremod.gui.hiring.restartMessageDone", this.getName());
    }

    public void setIsChild(boolean isChild) {
        this.isChild = isChild;
        this.markDirty();
    }

    public boolean isChild() {
        return this.isChild;
    }

    public void setStrength(@NotNull int strength) {
        this.strength = strength < 1 ? 1 : ((double)strength > this.colony.getOverallHappiness() ? (int)this.colony.getOverallHappiness() : strength);
        this.markDirty();
    }

    public void setEndurance(@NotNull int endurance) {
        this.endurance = endurance < 1 ? 1 : ((double)endurance > this.colony.getOverallHappiness() ? (int)this.colony.getOverallHappiness() : endurance);
        this.markDirty();
    }

    public void setCharisma(@NotNull int charisma) {
        this.charisma = charisma < 1 ? 1 : ((double)charisma > this.colony.getOverallHappiness() ? (int)this.colony.getOverallHappiness() : charisma);
        this.markDirty();
    }

    public void setIntelligence(@NotNull int intelligence) {
        this.intelligence = intelligence < 1 ? 1 : ((double)intelligence > this.colony.getOverallHappiness() ? (int)this.colony.getOverallHappiness() : intelligence);
        this.markDirty();
    }

    public void setDexterity(@NotNull int dexterity) {
        this.dexterity = dexterity < 1 ? 1 : ((double)dexterity > this.colony.getOverallHappiness() ? (int)this.colony.getOverallHappiness() : dexterity);
        this.markDirty();
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public double getHealth() {
        return this.health;
    }

    public boolean justAte() {
        return this.justAte;
    }

    public void setJustAte(boolean justAte) {
        this.justAte = justAte;
    }

    private static /* synthetic */ boolean lambda$null$0(EntityAITasks.EntityAITaskEntry task) {
        return task.field_75733_a instanceof AbstractAISkeleton;
    }
}

