/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility.candb;

import com.minecolonies.api.compatibility.candb.AbstractChiselAndBitsProxy;
import com.minecolonies.api.compatibility.candb.ChiselsAndBitsAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IChiseledBlockTileEntity;
import mod.chiselsandbits.api.IMultiStateBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;

public final class ChiselAndBitsCheck
extends AbstractChiselAndBitsProxy {
    private static final String CANDB = "chiselsandbits";

    public static boolean isChiselAndBitsTileEntity(@NotNull TileEntity tileEntity) {
        return new ChiselAndBitsCheck().checkForChiselAndBitsTileEntity(tileEntity);
    }

    public static boolean isChiselAndBitsBlock(@NotNull IBlockState blockState) {
        return new ChiselAndBitsCheck().checkForChiselAndBitsBlock(blockState);
    }

    public static List<ItemStack> getBitStacks(TileEntity tileEntity) {
        return new ChiselAndBitsCheck().getChiseledStacks(tileEntity);
    }

    @Override
    @Optional.Method(modid="chiselsandbits")
    public boolean checkForChiselAndBitsBlock(@NotNull IBlockState blockState) {
        return blockState.func_177230_c() instanceof IMultiStateBlock;
    }

    @Override
    @Optional.Method(modid="chiselsandbits")
    public boolean checkForChiselAndBitsTileEntity(@NotNull TileEntity tileEntity) {
        return tileEntity instanceof IChiseledBlockTileEntity;
    }

    @Override
    @Optional.Method(modid="chiselsandbits")
    public List<ItemStack> getChiseledStacks(@NotNull TileEntity tileEntity) {
        if (tileEntity instanceof IChiseledBlockTileEntity) {
            IBitAccess access = ((IChiseledBlockTileEntity)tileEntity).getBitAccess();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            access.getStateCounts().forEach(stateCount -> {
                int count;
                if (stateCount.stateId == 0) {
                    return;
                }
                ItemStack bitStack = ChiselsAndBitsAPI.getBitStack(stateCount.stateId);
                if (bitStack.func_190926_b()) {
                    return;
                }
                int max = bitStack.func_77976_d();
                for (count = stateCount.quantity; count > max; count -= max) {
                    ItemStack copy = bitStack.func_77946_l();
                    copy.func_190920_e(max);
                    stacks.add(copy);
                }
                if (count > 0) {
                    bitStack.func_190920_e(count);
                    stacks.add(bitStack);
                }
            });
            return stacks;
        }
        return Collections.emptyList();
    }
}

