/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.world;

import epicsquid.mysticallib.util.Util;
import epicsquid.roots.entity.grove.EntityNaturalGrove;
import java.util.Random;
import javax.vecmath.Vector2d;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenNaturalGrove
implements IWorldGenerator {
    private Vector2d lastChunkGenerated = new Vector2d(0.0, 0.0);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (random.nextInt(70) != 0) {
            return;
        }
        if (!this.isNumberAwayOf(5, chunkX, (int)this.lastChunkGenerated.x) || !this.isNumberAwayOf(5, chunkZ, (int)this.lastChunkGenerated.y)) {
            return;
        }
        if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a() && !world.field_72995_K) {
            int xx = chunkX * 16 + 13 + Util.rand.nextInt(6);
            int zz = chunkZ * 16 + 13 + Util.rand.nextInt(6);
            BlockPos blockpos = new BlockPos(xx, 100, zz);
            Biome biome = world.getBiomeForCoordsBody(blockpos);
            blockpos = world.func_175672_r(blockpos);
            BlockPos checkForGroundPos = blockpos.func_177982_a(0, -1, 0);
            int airBlocks = 0;
            for (int x = -2; x < 3; ++x) {
                for (int z = -2; z < 3; ++z) {
                    Block checkBlock = world.func_180495_p(checkForGroundPos.func_177982_a(x, 0, z)).func_177230_c();
                    if (checkBlock != Blocks.field_150346_d && checkBlock != Blocks.field_150349_c && checkBlock != Blocks.field_150329_H && checkBlock != Blocks.field_150348_b && checkBlock != Blocks.field_150354_m) {
                        ++airBlocks;
                    }
                    if (airBlocks <= 3) continue;
                    return;
                }
            }
            if (biome == Biomes.field_76767_f || biome == Biomes.field_150583_P || biome == Biomes.field_76772_c) {
                this.lastChunkGenerated = new Vector2d((double)chunkX, (double)chunkZ);
                WorldServer worldserver = (WorldServer)world;
                MinecraftServer minecraftserver = world.func_73046_m();
                TemplateManager templatemanager = worldserver.func_184163_y();
                ResourceLocation loc = new ResourceLocation("roots", "natural_grove");
                Template template = templatemanager.func_186237_a(minecraftserver, loc);
                PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(null).func_186225_a(null).func_186226_b(false);
                template.func_186253_b(world, blockpos.func_177963_a(-8.0, -1.0, -9.0), placementsettings);
                IBlockState iblockstate = world.func_180495_p(blockpos);
                world.func_184138_a(blockpos, iblockstate, iblockstate, 3);
                EntityNaturalGrove naturalGrove = new EntityNaturalGrove(world);
                naturalGrove.func_70107_b((float)blockpos.func_177958_n() + 0.5f, blockpos.func_177956_o() + 2, (float)blockpos.func_177952_p() + 0.5f);
                world.func_72838_d((Entity)naturalGrove);
            }
        }
    }

    private boolean isNumberAwayOf(int difference, int number1, int number2) {
        if (number1 > number2) {
            return number1 - number2 > difference;
        }
        return number2 - number1 > 5;
    }
}

