/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.util;

import epicsquid.roots.api.Herb;
import epicsquid.roots.integration.baubles.pouch.BaublePowderInventoryUtil;
import epicsquid.roots.item.ItemPouch;
import epicsquid.roots.item.ItemSylvanArmor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="roots")
public class PowderInventoryUtil {
    private static Map<Herb, HerbAlert> alerts = new HashMap<Herb, HerbAlert>();
    private static HerbAlert slot1 = null;
    private static HerbAlert slot2 = null;

    public static ItemStack getPouch(EntityPlayer player) {
        ItemStack stack;
        if (Loader.isModLoaded((String)"baubles") && !(stack = BaublePowderInventoryUtil.getPouch(player)).func_190926_b()) {
            return stack;
        }
        for (int i = 0; i < 36; ++i) {
            if (!(player.field_71071_by.func_70301_a(i).func_77973_b() instanceof ItemPouch)) continue;
            return player.field_71071_by.func_70301_a(i);
        }
        return ItemStack.field_190927_a;
    }

    public static double getPowderTotal(EntityPlayer player, Herb herb) {
        ItemStack pouch = PowderInventoryUtil.getPouch(player);
        if (pouch.func_190926_b()) {
            return 0.0;
        }
        return ItemPouch.getHerbQuantity(pouch, herb);
    }

    public static void removePowder(EntityPlayer player, Herb herb, double amount) {
        ItemStack pouch = PowderInventoryUtil.getPouch(player);
        if (pouch.func_190926_b()) {
            return;
        }
        amount -= amount * ItemSylvanArmor.sylvanBonus(player);
        ItemPouch.useQuantity(pouch, herb, amount);
        PowderInventoryUtil.resolveSlots(herb);
    }

    public static void resolveSlots(Herb herb) {
        if (slot1 != null && !slot1.active()) {
            slot1.setSlot(-1);
            slot1 = null;
        }
        if (slot2 != null && !slot2.active()) {
            slot2.setSlot(-1);
            slot2 = null;
        }
        if (slot1 == null && slot2 != null) {
            slot1 = slot2;
            slot2 = null;
            slot1.setSlot(1);
        }
        if (slot1 == PowderInventoryUtil.getAlert(herb)) {
            slot1.refresh();
        } else if (slot2 == PowderInventoryUtil.getAlert(herb)) {
            slot2.refresh();
        } else if (slot1 == null) {
            slot1 = PowderInventoryUtil.getAlert(herb);
            slot1.setSlot(1);
            slot1.enable();
        } else if (slot2 == null) {
            slot2 = PowderInventoryUtil.getAlert(herb);
            slot2.setSlot(2);
            slot2.enable();
        }
    }

    public static HerbAlert getAlert(Herb herb) {
        if (!alerts.containsKey((Object)herb)) {
            HerbAlert alert = new HerbAlert(herb);
            alerts.put(herb, alert);
        }
        return alerts.get((Object)herb);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void renderHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            ScaledResolution res = event.getResolution();
            float partial = event.getPartialTicks();
            if (slot1 != null) {
                if (slot1.active()) {
                    slot1.render(res, partial);
                } else {
                    slot1.setSlot(-1);
                    slot1 = null;
                }
            }
            if (slot2 != null) {
                if (slot2.active()) {
                    slot2.render(res, partial);
                } else {
                    slot2.setSlot(-1);
                    slot2 = null;
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (slot1 != null) {
            slot1.tick(event);
        }
        if (slot2 != null) {
            slot2.tick(event);
        }
    }

    public static class HerbAlert {
        private static final int TIME_VISIBLE = 160;
        private static final int MAX_TIME = 160;
        private static final int ANIM_TIME = 5;
        private int ticks = 0;
        private int slot = 0;
        private Herb herb;
        private ItemStack stack = null;

        public HerbAlert(Herb herb) {
            this.herb = herb;
        }

        public void refresh() {
            this.ticks = 155;
        }

        public void setSlot(int slot) {
            this.slot = slot;
        }

        public void enable() {
            this.ticks = 160;
        }

        public ItemStack getStack() {
            if (this.stack == null) {
                this.stack = new ItemStack(this.herb.getItem());
            }
            return this.stack;
        }

        public boolean active() {
            return this.slot != -1 && this.ticks > 0;
        }

        @SideOnly(value=Side.CLIENT)
        public void tick(TickEvent.ClientTickEvent event) {
            if (this.ticks == -1) {
                return;
            }
            --this.ticks;
        }

        @SideOnly(value=Side.CLIENT)
        public void render(ScaledResolution res, float partialTicks) {
            if (this.ticks == 0) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            float progress = this.ticks < 5 ? Math.max(0.0f, (float)this.ticks - partialTicks) / 5.0f : Math.min(5.0f, (float)(160 - this.ticks) + partialTicks) / 5.0f;
            float anim = -progress * (progress - 2.0f) * 20.0f;
            float x = (float)res.func_78326_a() / 2.0f;
            float y = (float)res.func_78328_b() - anim;
            int barWidth = 248;
            if (!mc.field_71439_g.func_184592_cb().func_190926_b()) {
                barWidth += 58;
            }
            x = (float)((double)x + ((double)barWidth / 2.0 * -1.0 + (double)(this.slot * 40) - 95.0));
            ItemStack stack = this.getStack();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            RenderHelper.func_74520_c();
            mc.func_175599_af().func_180450_b(stack, 0, 0);
            String s = String.format("%.1f", PowderInventoryUtil.getPowderTotal((EntityPlayer)mc.field_71439_g, this.herb));
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            mc.field_71466_p.func_175063_a(s, 18.0f, 3.5f, 0xFFFFFF);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
    }
}

