/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.tileentity;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.tile.TileBase;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.block.BlockGroveStone;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.network.fx.MessageGrowthCrafterVisualFX;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.recipe.FeyCraftingRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityFeyCrafter
extends TileBase {
    public static int GROVE_STONE_RADIUS = 10;
    private Random random = new Random();
    public ItemStackHandler inventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            TileEntityFeyCrafter.this.func_70296_d();
            if (!((TileEntityFeyCrafter)TileEntityFeyCrafter.this).field_145850_b.field_72995_K) {
                TileEntityFeyCrafter.this.updatePacketViaState();
            }
        }
    };
    private BlockPos groveStone = null;

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("handler", (NBTBase)this.inventory.serializeNBT());
        tag.func_74772_a("groveStone", this.groveStone == null ? -1L : this.groveStone.func_177986_g());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("handler"));
        long gpos = tag.func_74763_f("groveStone");
        this.groveStone = gpos == -1L ? null : BlockPos.func_177969_a((long)gpos);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(@Nonnull NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void breakBlock(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            Util.spawnInventoryInWorld((World)world, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5), (IItemHandler)this.inventory);
        }
    }

    public boolean hasValidGroveStone() {
        List potentials;
        if (this.groveStone != null) {
            IBlockState grove = this.field_145850_b.func_180495_p(this.groveStone);
            if (grove.func_177230_c() == ModBlocks.grove_stone && ((Boolean)grove.func_177229_b((IProperty)BlockGroveStone.VALID)).booleanValue()) {
                return true;
            }
            this.groveStone = null;
        }
        if ((potentials = Util.getBlocksWithinRadius((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)GROVE_STONE_RADIUS, (float)GROVE_STONE_RADIUS, (float)GROVE_STONE_RADIUS, (Block)ModBlocks.grove_stone)).isEmpty()) {
            return false;
        }
        for (BlockPos pos : potentials) {
            IBlockState grove = this.field_145850_b.func_180495_p(pos);
            if (!((Boolean)grove.func_177229_b((IProperty)BlockGroveStone.VALID)).booleanValue()) continue;
            this.groveStone = pos;
            return true;
        }
        return false;
    }

    public List<ItemStack> craft() {
        FeyCraftingRecipe recipe = this.getRecipe();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ItemStack current = ItemStack.field_190927_a;
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        while (recipe != null) {
            inputItems.clear();
            boolean singleStack = false;
            for (int i = 0; i < 5; ++i) {
                inputItems.add(this.inventory.extractItem(i, 1, false));
            }
            if (current.func_190926_b()) {
                current = recipe.getResult().func_77946_l();
                if (current.func_77976_d() == 1) {
                    singleStack = true;
                }
                recipe.postCraft(current, inputItems);
            } else if (current.func_190916_E() + recipe.getResult().func_190916_E() < current.func_77976_d()) {
                current.func_190917_f(recipe.getResult().func_190916_E());
            } else {
                result.add(current);
                current = recipe.getResult().func_77946_l();
            }
            recipe = this.getRecipe();
            if (!singleStack) continue;
            break;
        }
        if (!current.func_190926_b()) {
            result.add(current);
        }
        return result;
    }

    public FeyCraftingRecipe getRecipe() {
        return ModRecipes.getFeyCraftingRecipe(this.getContents());
    }

    public List<ItemStack> getContents() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            result.add(this.inventory.getStackInSlot(i));
        }
        return result;
    }

    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.hasValidGroveStone()) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        List<ItemStack> items = this.craft();
        if (items.isEmpty()) {
            return true;
        }
        for (EnumFacing facing : EnumFacing.values()) {
            IItemHandler cap;
            TileEntity te = world.func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (te == null || (cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) == null) continue;
            ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
            for (ItemStack toPut : items) {
                ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)cap, (ItemStack)toPut, (boolean)false);
                if (result.func_190926_b()) continue;
                newItems.add(result);
            }
            items = newItems;
        }
        for (ItemStack stack : items) {
            EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5, stack);
            world.func_72838_d((Entity)item);
        }
        MessageGrowthCrafterVisualFX packet = new MessageGrowthCrafterVisualFX(this.func_174877_v(), world.field_73011_w.getDimension());
        PacketHandler.sendToAllTracking((IMessage)packet, (TileEntity)this);
        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ModSounds.CHIMES, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        return true;
    }

    public void doVisual() {
        if (this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 40; ++i) {
                ParticleUtil.spawnParticleFiery(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.125f + 0.75f * this.random.nextFloat(), (float)this.func_174877_v().func_177956_o() + 1.25f + 0.5f * this.random.nextFloat(), (float)this.func_174877_v().func_177952_p() + 0.125f + 0.75f * this.random.nextFloat(), 0.03125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.03125f * (this.random.nextFloat() - 0.5f), 255.0f, 224.0f, 32.0f, 0.75f, 9.0f + 9.0f * this.random.nextFloat(), 40);
            }
        }
    }
}

