/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker;

import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.Bark")
@ZenDocAppend(value={"docs/include/bark.example.md"})
@ZenRegister
@ZenClass(value="mods.roots.Bark")
public class BarkTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="the name of the recipe"), @ZenDocArg(arg="woodLog", info="the itemstack equivalent of the wood log being broken"), @ZenDocArg(arg="bark", info="the itemstack of the type of bark this log produces")})
    @ZenMethod
    public static void addRecipe(String name, IItemStack woodLog, IItemStack bark) {
        ItemStack log = CraftTweakerMC.getItemStack((IItemStack)woodLog);
        if (!(log.func_77973_b() instanceof ItemBlock)) {
            CraftTweakerAPI.logError((String)("Provided log " + woodLog + " is not an item block!"));
            return;
        }
        CraftTweaker.LATE_ACTIONS.add(new Add(name, ((ItemBlock)log.func_77973_b()).func_179223_d(), CraftTweakerMC.getItemStack((IItemStack)bark)));
    }

    private static class Add
    extends BaseAction {
        private final Block woodLog;
        private final ItemStack bark;
        private final String name;

        public Add(String name, Block woodLog, ItemStack bark) {
            super("add_bark_recipe");
            this.woodLog = woodLog;
            this.bark = bark;
            this.name = name;
        }

        public void apply() {
            ModRecipes.addModdedBarkRecipe(this.name, this.woodLog, this.bark.func_77973_b());
        }

        protected String getRecipeInfo() {
            return String.format("Recipe to add %s->%s to Bark Recipes", this.woodLog, this.bark);
        }
    }
}

