/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.effect;

import epicsquid.roots.capability.playerdata.PlayerDataCapability;
import epicsquid.roots.capability.playerdata.PlayerDataCapabilityProvider;
import epicsquid.roots.effect.Effect;
import epicsquid.roots.effect.EffectInvulnerability;
import epicsquid.roots.effect.EffectTimeStop;
import epicsquid.roots.util.Constants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class EffectManager {
    private static Map<String, Effect> effects = new HashMap<String, Effect>();
    public static Effect effect_time_stop;
    public static Effect effect_invulnerability;
    public static Effect effect_freeze;
    public static Effect effect_fireresist;
    public static Effect effect_arcanism;
    public static Effect effect_naturescure;
    public static Effect effect_regen;

    public static void init() {
        effect_invulnerability = new EffectInvulnerability("effect_invulnerability", false);
        effects.put("effect_invulnerability", effect_invulnerability);
        effect_time_stop = new EffectTimeStop("effect_time_stop", false);
        effects.put("effect_time_stop", effect_time_stop);
    }

    public static void assignEffect(EntityLivingBase entity, String effect, int duration, NBTTagCompound data) {
        if (!(entity instanceof EntityPlayer)) {
            if (!entity.getEntityData().func_74764_b(Constants.EFFECT_TAG)) {
                entity.getEntityData().func_74782_a(Constants.EFFECT_TAG, (NBTBase)new NBTTagCompound());
            }
        } else if (entity.hasCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null) && !((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74764_b(Constants.EFFECT_TAG)) {
            ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74782_a(Constants.EFFECT_TAG, (NBTBase)new NBTTagCompound());
            ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).markDirty();
        }
        NBTTagCompound tag = null;
        if (!(entity instanceof EntityPlayer)) {
            tag = entity.getEntityData().func_74775_l(Constants.EFFECT_TAG);
        } else if (entity.hasCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)) {
            tag = ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74775_l(Constants.EFFECT_TAG);
        }
        if (tag != null) {
            if (!tag.func_74764_b(effect)) {
                effects.get(effect).onApplied(entity, data);
            }
            tag.func_74768_a(effect, duration);
            tag.func_74782_a(effect + "_data", (NBTBase)data);
            if (entity.hasCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)) {
                ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).markDirty();
            }
        }
    }

    public static boolean hasEffect(EntityLivingBase entity, String effect) {
        if (entity != null) {
            if (!(entity instanceof EntityPlayer)) {
                if (entity.getEntityData().func_74764_b(Constants.EFFECT_TAG)) {
                    return entity.getEntityData().func_74775_l(Constants.EFFECT_TAG).func_74764_b(effect);
                }
            } else if (entity.hasCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null) && ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74764_b(Constants.EFFECT_TAG)) {
                return ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74775_l(Constants.EFFECT_TAG).func_74764_b(effect);
            }
        }
        return false;
    }

    public static void setEffectData(EntityLivingBase entity, String effect, NBTTagCompound data) {
        if (entity != null) {
            if (!(entity instanceof EntityPlayer)) {
                if (entity.getEntityData().func_74764_b(Constants.EFFECT_TAG)) {
                    entity.getEntityData().func_74775_l(Constants.EFFECT_TAG).func_74782_a(effect + "_data", (NBTBase)data);
                }
            } else if (entity.hasCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null) && ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74764_b(Constants.EFFECT_TAG)) {
                ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74775_l(Constants.EFFECT_TAG).func_74782_a(effect + "_data", (NBTBase)data);
                ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).markDirty();
            }
        }
    }

    public static NBTTagCompound getEffectData(EntityLivingBase entity, String effect) {
        if (entity != null) {
            if (!(entity instanceof EntityPlayer)) {
                if (entity.getEntityData().func_74764_b(Constants.EFFECT_TAG) && entity.getEntityData().func_74775_l(Constants.EFFECT_TAG).func_74764_b(effect + "_data")) {
                    return entity.getEntityData().func_74775_l(Constants.EFFECT_TAG).func_74775_l(effect + "_data");
                }
            } else if (entity.hasCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null) && ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74764_b(Constants.EFFECT_TAG) && ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74775_l(Constants.EFFECT_TAG).func_74764_b(effect + "_data")) {
                return ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74775_l(Constants.EFFECT_TAG).func_74775_l(effect + "_data");
            }
        }
        return null;
    }

    public static int getDuration(EntityLivingBase entity, String effect) {
        if (entity != null) {
            if (!(entity instanceof EntityPlayer)) {
                if (entity.getEntityData().func_74764_b(Constants.EFFECT_TAG) && entity.getEntityData().func_74775_l(Constants.EFFECT_TAG).func_74764_b(effect)) {
                    return entity.getEntityData().func_74775_l(Constants.EFFECT_TAG).func_74762_e(effect);
                }
            } else if (entity.hasCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null) && ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74764_b(Constants.EFFECT_TAG) && ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74775_l(Constants.EFFECT_TAG).func_74764_b(effect)) {
                return ((PlayerDataCapability)entity.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74775_l(Constants.EFFECT_TAG).func_74762_e(effect);
            }
        }
        return 0;
    }

    public static void tickEffects(EntityLivingBase entity) {
        if (entity != null) {
            if (!(entity instanceof EntityPlayer)) {
                if (entity.getEntityData().func_74764_b(Constants.EFFECT_TAG)) {
                    NBTTagCompound data_tag;
                    NBTTagCompound tag = entity.getEntityData().func_74775_l(Constants.EFFECT_TAG);
                    ArrayList<String> keys = new ArrayList<String>();
                    for (String s : tag.func_150296_c()) {
                        if (s.endsWith("_data")) continue;
                        data_tag = tag.func_74775_l(s + "_data");
                        effects.get(s).onTick(entity, tag.func_74762_e(s) - 1, data_tag);
                        tag.func_74768_a(s, tag.func_74762_e(s) - 1);
                        if (tag.func_74762_e(s) > 0) continue;
                        keys.add(s);
                    }
                    for (String s : keys) {
                        data_tag = tag.func_74775_l(s + "_data");
                        effects.get(s).onEnd(entity, data_tag);
                        tag.func_82580_o(s);
                        tag.func_82580_o(s + "_data");
                        if (tag.func_150296_c().size() != 0) continue;
                        entity.getEntityData().func_82580_o(Constants.EFFECT_TAG);
                    }
                }
            } else {
                EntityPlayer player = (EntityPlayer)entity;
                if (player.hasCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)) {
                    NBTTagCompound data_tag;
                    NBTTagCompound tag = ((PlayerDataCapability)player.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_74775_l(Constants.EFFECT_TAG);
                    boolean ticked = false;
                    ArrayList<String> keys = new ArrayList<String>();
                    for (String s : tag.func_150296_c()) {
                        if (s.endsWith("_data")) continue;
                        data_tag = tag.func_74775_l(s + "_data");
                        effects.get(s).onTick(entity, tag.func_74762_e(s) - 1, data_tag);
                        ticked = true;
                        tag.func_74768_a(s, tag.func_74762_e(s) - 1);
                        if (tag.func_74762_e(s) > 0) continue;
                        keys.add(s);
                    }
                    for (String s : keys) {
                        data_tag = tag.func_74775_l(s + "_data");
                        effects.get(s).onEnd(entity, data_tag);
                        ticked = true;
                        tag.func_82580_o(s);
                        tag.func_82580_o(s + "_data");
                        if (tag.func_150296_c().size() != 0) continue;
                        ((PlayerDataCapability)player.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).getData().func_82580_o(Constants.EFFECT_TAG);
                    }
                    if (ticked) {
                        ((PlayerDataCapability)player.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).markDirty();
                    }
                }
            }
        }
    }
}

