/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.capability.grove;

import epicsquid.roots.capability.grove.IPlayerGroveCapability;
import epicsquid.roots.grove.GroveType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PlayerGroveCapability
implements IPlayerGroveCapability {
    private Map<GroveType, Float> groveTrust = new HashMap<GroveType, Float>();
    private boolean dirty = true;

    @Override
    public void addTrust(GroveType type, float amount) {
        if (this.groveTrust.get((Object)type) == null || this.groveTrust.get((Object)type).floatValue() == 0.0f) {
            this.groveTrust.put(type, Float.valueOf(amount));
        } else {
            this.groveTrust.put(type, Float.valueOf(this.groveTrust.get((Object)type).floatValue() + amount));
        }
        this.markDirty();
    }

    @Override
    public float getTrust(GroveType type) {
        return this.groveTrust.getOrDefault((Object)type, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public NBTTagCompound getData() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        NBTTagList groveTagList = new NBTTagList();
        int count = 0;
        for (Map.Entry<GroveType, Float> entry : this.groveTrust.entrySet()) {
            NBTTagCompound groveVariable = new NBTTagCompound();
            groveVariable.func_74778_a("fey" + count, entry.getKey().toString());
            groveVariable.func_74776_a("trust" + count, entry.getValue().floatValue());
            groveTagList.func_74742_a((NBTBase)groveVariable);
            ++count;
        }
        nbtTagCompound.func_74782_a("groveList", (NBTBase)groveTagList);
        return nbtTagCompound;
    }

    @Override
    public void setData(NBTTagCompound tag) {
        NBTTagList groveTagList = (NBTTagList)tag.func_74781_a("groveList");
        for (int i = 0; i < groveTagList.func_74745_c(); ++i) {
            NBTTagCompound groveTag = groveTagList.func_150305_b(i);
            String groveName = groveTag.func_74779_i("fey" + i);
            float trust = groveTag.func_74760_g("trust" + i);
            this.groveTrust.put(GroveType.valueOf(groveName.toUpperCase()), Float.valueOf(trust));
        }
        this.dirty = true;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void clean() {
        this.dirty = false;
    }
}

