/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.block;

import epicsquid.mysticallib.block.BlockTEBase;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.recipe.PyreCraftingRecipe;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.tileentity.TileEntityBonfire;
import epicsquid.roots.util.types.BlockPosDimension;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBonfire
extends BlockTEBase {
    public static PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");
    public static Map<BlockPosDimension, RitualBase> ritualCache = new HashMap<BlockPosDimension, RitualBase>();
    public static Map<BlockPosDimension, PyreCraftingRecipe> recipeCache = new HashMap<BlockPosDimension, PyreCraftingRecipe>();

    public BlockBonfire(@Nonnull Material mat, @Nonnull SoundType type, float hardness, @Nonnull String name, @Nonnull Class<? extends TileEntity> teClass) {
        super(mat, type, hardness, name, teClass);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.BOWL;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return new AxisAlignedBB(-0.125, 0.0, -0.125, 1.125, 0.25, 1.125);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BURNING});
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false));
    }

    public static void setState(boolean burning, World world, BlockPos pos) {
        if (burning) {
            world.func_180501_a(pos, ModBlocks.bonfire.func_176223_P().func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            world.func_180501_a(pos, ModBlocks.bonfire.func_176223_P().func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BURNING) != false ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)BURNING)).booleanValue()) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityBonfire) {
            TileEntityBonfire bon = (TileEntityBonfire)te;
            boolean lit = bon.getBurnTime() != 0;
            BlockPosDimension pdos = new BlockPosDimension(pos, worldIn.field_73011_w.getDimension());
            RitualBase ritual = ritualCache.get(pdos);
            if (!(ritual != null && ritual.isRitualRecipe(bon, null) || (ritual = RitualRegistry.getRitual(bon, null)) == null)) {
                ritualCache.put(pdos, ritual);
            }
            if (ritual != null) {
                if (bon.getLastRitualUsed().equals(ritual) && lit) {
                    return 5;
                }
                return lit ? 4 : 1;
            }
            PyreCraftingRecipe recipe = recipeCache.get(pdos);
            if (recipe == null && (recipe = bon.getCurrentRecipe()) != null) {
                recipeCache.put(pdos, recipe);
            }
            if (recipe != null) {
                if (bon.getLastRecipeUsed().equals(recipe) && lit) {
                    return 5;
                }
                return lit ? 4 : 1;
            }
            return lit ? 3 : 0;
        }
        return 0;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
    }
}

