/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.crafting.craftingplaterecipes;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.block.ICraftingPlateRecipe;
import com.teamwizardry.wizardry.api.capability.player.mana.IManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaManager;
import com.teamwizardry.wizardry.api.spell.SpellBuilder;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.common.network.PacketExplode;
import com.teamwizardry.wizardry.common.tile.TileJar;
import com.teamwizardry.wizardry.init.ModSounds;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class FairyJarRecipe
implements ICraftingPlateRecipe {
    @Override
    public boolean doesRecipeExistForItem(ItemStack stack) {
        return false;
    }

    @Override
    public boolean doesRecipeExistInWorld(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(EnumFacing.UP));
        if (!(tileEntity instanceof TileJar)) {
            return false;
        }
        TileJar jar = (TileJar)tileEntity;
        return jar.fairy != null && jar.fairy.infusedSpell == null && !jar.fairy.isDepressed;
    }

    @Override
    public void tick(World world, BlockPos pos, ItemStack input, ItemStackHandler inventoryHandler, Function<IManaCapability, Double> consumeMana) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(EnumFacing.UP));
        if (!(tileEntity instanceof TileJar)) {
            return;
        }
        TileJar jar = (TileJar)tileEntity;
        if (jar.fairy != null && jar.fairy.infusedSpell == null && !jar.fairy.isDepressed && !ManaManager.isManaFull(jar.fairy.handler)) {
            ManaManager.forObject(jar.fairy.handler).addMana(consumeMana.apply(jar.fairy.handler)).close();
            jar.func_70296_d();
        }
    }

    @Override
    public void complete(World world, BlockPos pos, ItemStack input, ItemStackHandler inventoryHandler) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(EnumFacing.UP));
        if (!(tileEntity instanceof TileJar)) {
            return;
        }
        TileJar jar = (TileJar)tileEntity;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inventoryHandler.getSlots(); ++i) {
            if (inventoryHandler.getStackInSlot(i).func_190926_b()) continue;
            stacks.add(inventoryHandler.getStackInSlot(i));
            inventoryHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        SpellBuilder builder = new SpellBuilder(stacks);
        List<SpellRing> spell = builder.getSpell();
        if (spell.isEmpty()) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (SpellRing spellRing : builder.getSpell()) {
            list.func_74742_a((NBTBase)spellRing.serializeNBT());
        }
        jar.fairy.infusedSpell = builder.getSpell().get(0);
        PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketExplode(new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), Color.CYAN, Color.BLUE, 2.0, 2.0, 500, 300, 20, true), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 256.0));
        world.func_184133_a(null, pos, (SoundEvent)ModSounds.BASS_BOOM, SoundCategory.BLOCKS, 1.0f, (float)RandUtil.nextDouble(1.0, 1.5));
        List entityList = world.func_72839_b(null, new AxisAlignedBB(pos).func_72314_b(32.0, 32.0, 32.0));
        for (Entity entity1 : entityList) {
            double dist = entity1.func_70011_f((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            double upperMag = 3.0;
            double scale = 0.8;
            double mag = 3.0 * (0.8 * dist / (-0.8 * dist - 1.0) + 1.0);
            Vec3d dir = entity1.func_174791_d().func_178788_d(new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5)).func_72432_b().func_186678_a(mag);
            entity1.field_70159_w = dir.field_72450_a;
            entity1.field_70181_x = dir.field_72448_b;
            entity1.field_70179_y = dir.field_72449_c;
            entity1.field_70143_R = 0.0f;
            entity1.field_70133_I = true;
            if (!(entity1 instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)entity1).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity1));
        }
    }

    @Override
    public boolean isDone(World world, BlockPos pos, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(EnumFacing.UP));
        if (!(tileEntity instanceof TileJar)) {
            return false;
        }
        TileJar jar = (TileJar)tileEntity;
        return ManaManager.isManaFull(jar.fairy.handler);
    }

    @Override
    public void canceled(World world, BlockPos pos, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(EnumFacing.UP));
        if (!(tileEntity instanceof TileJar)) {
            return;
        }
        TileJar jar = (TileJar)tileEntity;
        if (!ManaManager.isManaFull(jar.fairy.handler)) {
            ManaManager.forObject(jar.fairy.handler).setMana(0.0).close();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInput(World world, BlockPos pos, ItemStack input, float partialTicks) {
    }
}

