/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.network;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.network.PacketBase;
import com.teamwizardry.librarianlib.features.saving.SaveMethodGetter;
import com.teamwizardry.librarianlib.features.saving.SaveMethodSetter;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRenderSpell
extends PacketBase {
    public NBTTagCompound spellData;
    public SpellRing spellRing;

    public PacketRenderSpell() {
    }

    public PacketRenderSpell(SpellData spellData, SpellRing spellRing) {
        this.spellData = spellData.serializeNBT();
        this.spellRing = spellRing;
    }

    @SaveMethodGetter(saveName="module_saver")
    public NBTTagCompound getter() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.spellData == null || this.spellRing == null) {
            return compound;
        }
        compound.func_74782_a("spell_data", (NBTBase)this.spellData);
        compound.func_74782_a("spell_ring", (NBTBase)this.spellRing.serializeNBT());
        return compound;
    }

    @SaveMethodSetter(saveName="module_saver")
    public void setter(NBTTagCompound compound) {
        if (compound.func_74764_b("spell_data")) {
            this.spellData = compound.func_74775_l("spell_data");
        }
        if (compound.func_74764_b("spell_ring")) {
            this.spellRing = SpellRing.deserializeRing(compound.func_74775_l("spell_ring"));
        }
    }

    public void handle(@Nonnull MessageContext messageContext) {
        if (messageContext.side.isServer()) {
            return;
        }
        World world = LibrarianLib.PROXY.getClientPlayer().field_70170_p;
        if (world == null || this.spellRing == null || this.spellData == null) {
            return;
        }
        SpellData data = new SpellData();
        data.deserializeNBT(this.spellData);
        if (this.spellRing.getModule() != null) {
            this.spellRing.getModule().renderSpell(world, data, this.spellRing);
        }
    }
}

