/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.entity.projectile;

import com.google.common.base.Predicate;
import com.teamwizardry.librarianlib.features.base.entity.EntityMod;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RayTrace;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.common.module.shapes.IShapeOverrides;
import com.teamwizardry.wizardry.common.network.PacketExplode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpellProjectile
extends EntityMod {
    public static final DataParameter<NBTTagCompound> SPELL_DATA = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_192734_n);
    public static final DataParameter<NBTTagCompound> SPELL_RING = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_192734_n);
    public static final DataParameter<Float> SPEED = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> GRAVITY = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> DIST = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> RENDER = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntitySpellProjectile(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70178_ae = true;
        if (world.field_72995_K) {
            EntitySpellProjectile.func_184227_b((double)30.0);
        }
    }

    public EntitySpellProjectile(World world, SpellRing spellRing, SpellData spellData, float dist, float speed, float gravity, boolean render) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70178_ae = true;
        this.setSpellData(spellData);
        this.setSpellRing(spellRing);
        this.setSpeed(speed);
        this.setDistance(dist);
        this.setGravity(gravity);
        this.setRender(render);
        if (world.field_72995_K) {
            EntitySpellProjectile.func_184227_b((double)30.0);
        }
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.func_174813_aQ();
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(SPELL_DATA, (Object)new NBTTagCompound());
        this.func_184212_Q().func_187214_a(SPELL_RING, (Object)new NBTTagCompound());
        this.func_184212_Q().func_187214_a(SPEED, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(DIST, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(GRAVITY, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(RENDER, (Object)true);
    }

    protected SpellData getSpellData() {
        NBTTagCompound compound = (NBTTagCompound)this.func_184212_Q().func_187225_a(SPELL_DATA);
        return SpellData.deserializeData(compound);
    }

    protected void setSpellData(SpellData data) {
        this.func_184212_Q().func_187227_b(SPELL_DATA, (Object)data.serializeNBT());
        this.func_184212_Q().func_187217_b(SPELL_DATA);
    }

    protected SpellRing getSpellRing() {
        NBTTagCompound compound = (NBTTagCompound)this.func_184212_Q().func_187225_a(SPELL_RING);
        return SpellRing.deserializeRing(compound);
    }

    protected void setSpellRing(SpellRing ring) {
        this.func_184212_Q().func_187227_b(SPELL_RING, (Object)ring.serializeNBT());
        this.func_184212_Q().func_187217_b(SPELL_RING);
    }

    protected float getSpeed() {
        return ((Float)this.func_184212_Q().func_187225_a(SPEED)).floatValue();
    }

    protected void setSpeed(float speed) {
        this.func_184212_Q().func_187227_b(SPEED, (Object)Float.valueOf(speed));
        this.func_184212_Q().func_187217_b(SPEED);
    }

    protected float getGravity() {
        return ((Float)this.func_184212_Q().func_187225_a(GRAVITY)).floatValue();
    }

    protected void setGravity(float gravity) {
        this.func_184212_Q().func_187227_b(GRAVITY, (Object)Float.valueOf(gravity));
        this.func_184212_Q().func_187217_b(GRAVITY);
    }

    protected float getDistance() {
        return ((Float)this.func_184212_Q().func_187225_a(DIST)).floatValue();
    }

    protected void setDistance(float dist) {
        this.func_184212_Q().func_187227_b(DIST, (Object)Float.valueOf(dist));
        this.func_184212_Q().func_187217_b(DIST);
    }

    protected boolean doesRender() {
        return (Boolean)this.func_184212_Q().func_187225_a(RENDER);
    }

    protected void setRender(boolean render) {
        this.func_184212_Q().func_187227_b(RENDER, (Object)render);
        this.func_184212_Q().func_187217_b(RENDER);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70128_L) {
            return;
        }
        final SpellRing spellRing = this.getSpellRing();
        final SpellData spellData = this.getSpellData();
        if (spellRing == null || spellData == null) {
            this.func_70106_y();
            this.field_70170_p.func_72900_e((Entity)this);
            return;
        }
        if (this.field_70170_p.field_72995_K && this.doesRender()) {
            ClientRunnable.run((ClientRunnable)new ClientRunnable(){

                @SideOnly(value=Side.CLIENT)
                public void runIfClient() {
                    IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
                    if (overrides.onRenderProjectile(EntitySpellProjectile.this.field_70170_p, spellData, spellRing)) {
                        return;
                    }
                    ParticleBuilder glitter = new ParticleBuilder(10);
                    glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
                    glitter.enableMotionCalculation();
                    glitter.setCollision(true);
                    glitter.setCanBounce(true);
                    glitter.setColorFunction((InterpFunction)new InterpColorHSV(spellRing.getPrimaryColor(), spellRing.getSecondaryColor()));
                    glitter.setAcceleration(new Vec3d(0.0, -0.015, 0.0));
                    ParticleSpawner.spawn((ParticleBuilder)glitter, (World)EntitySpellProjectile.this.field_70170_p, (InterpFunction)new StaticInterp((Object)EntitySpellProjectile.this.func_174791_d().func_178787_e(new Vec3d(EntitySpellProjectile.this.field_70159_w, EntitySpellProjectile.this.field_70181_x, EntitySpellProjectile.this.field_70179_y))), (int)5, (int)0, (aFloat, particleBuilder) -> {
                        particleBuilder.setScaleFunction((InterpFunction)new InterpScale((float)RandUtil.nextDouble(0.3, 0.8), 0.0f));
                        particleBuilder.setLifetime(RandUtil.nextInt(40, 60));
                        particleBuilder.addMotion(new Vec3d(RandUtil.nextDouble(-0.03, 0.03), RandUtil.nextDouble(-0.01, 0.05), RandUtil.nextDouble(-0.03, 0.03)));
                    });
                    glitter.disableMotionCalculation();
                    glitter.setMotion(Vec3d.field_186680_a);
                    ParticleSpawner.spawn((ParticleBuilder)glitter, (World)EntitySpellProjectile.this.field_70170_p, (InterpFunction)new StaticInterp((Object)EntitySpellProjectile.this.func_174791_d()), (int)5, (int)0, (aFloat, particleBuilder) -> {
                        particleBuilder.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(1.0f, 2.0f), 0.0f));
                        particleBuilder.setLifetime(RandUtil.nextInt(5, 10));
                    });
                }
            });
            return;
        }
        Vec3d origin = spellData.getOrigin(this.field_70170_p);
        this.field_70125_A = spellData.getPitch();
        this.field_70177_z = spellData.getYaw();
        Vec3d look = spellData.getData(SpellData.DefaultKeys.LOOK);
        if (look == null) {
            this.func_70106_y();
            this.field_70170_p.func_72900_e((Entity)this);
            return;
        }
        if (origin == null || (double)this.getDistance() < this.func_70011_f(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c)) {
            spellData.processBlock(this.func_180425_c(), EnumFacing.func_176737_a((float)((float)look.field_72450_a), (float)((float)look.field_72448_b), (float)((float)look.field_72449_c)), this.func_174791_d());
            this.goBoom(spellRing, spellData);
            return;
        }
        if (!this.field_70132_H) {
            float speed = this.getSpeed();
            this.field_70159_w += look.field_72450_a * (double)speed - this.field_70159_w;
            this.field_70181_x += look.field_72448_b * (double)speed - this.field_70181_x;
            this.field_70179_y += look.field_72449_c * (double)speed - this.field_70179_y;
        } else {
            RayTraceResult result = new RayTrace(this.field_70170_p, look, this.func_174791_d(), 5.0).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != this)).trace();
            spellData.processTrace(result, this.func_174791_d());
            this.goBoom(spellRing, spellData);
            return;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
        if (!entities.isEmpty()) {
            Entity caster = spellData.getCaster(this.field_70170_p);
            for (Entity entity : entities) {
                if (entity == caster) {
                    return;
                }
                if (entity instanceof EntitySpellProjectile) {
                    return;
                }
                spellData.processEntity(entity, false);
            }
            RayTraceResult result = new RayTrace(this.field_70170_p, look, this.func_174791_d(), 1.0).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != this)).trace();
            spellData.processTrace(result, this.func_174791_d());
            this.goBoom(spellRing, spellData);
        }
    }

    protected void goBoom(SpellRing spellRing, SpellData data) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        if (spellRing.getChildRing() != null) {
            spellRing.getChildRing().runSpellRing(this.field_70170_p, data, true);
        }
        if (this.doesRender()) {
            PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketExplode(this.func_174791_d(), spellRing.getPrimaryColor(), spellRing.getSecondaryColor(), 0.3, 0.3, RandUtil.nextInt(30, 50), 10, 25, true), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 512.0));
        }
        this.func_70106_y();
        this.field_70170_p.func_72900_e((Entity)this);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 4096.0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return super.func_145770_h(x, y, z);
    }

    public boolean func_70067_L() {
        return true;
    }

    public void readCustomNBT(@Nonnull NBTTagCompound compound) {
        if (compound.func_74764_b("spell_ring")) {
            this.setSpellRing(SpellRing.deserializeRing(compound.func_74775_l("spell_ring")));
        }
        if (this.field_70170_p != null && compound.func_74764_b("spell_data")) {
            this.setSpellData(SpellData.deserializeData(compound.func_74775_l("spell_data")));
        }
        if (compound.func_74764_b("gravity")) {
            this.setGravity(compound.func_74760_g("gravity"));
        }
        if (compound.func_74764_b("speed")) {
            this.setSpeed(compound.func_74760_g("speed"));
        }
        if (compound.func_74764_b("distance")) {
            this.setDistance(compound.func_74760_g("distance"));
        }
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound compound) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        compound.func_74782_a("spell_ring", (NBTBase)this.getSpellRing().serializeNBT());
        compound.func_74782_a("spell_data", (NBTBase)this.getSpellData().serializeNBT());
        compound.func_74780_a("distance", (double)this.getDistance());
        compound.func_74780_a("speed", (double)this.getSpeed());
        compound.func_74780_a("gravity", (double)this.getGravity());
    }
}

