/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.core.version.manifest;

import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.common.core.version.manifest.ManifestUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class ManifestUpgrader {
    private final File directory;
    private HashMap<String, HashMap<String, String>> manifestMap;
    private boolean hasManifestChanged = false;
    private boolean hasFolderChanged = false;
    private boolean isFinalized = false;
    private boolean hasErrors = false;

    ManifestUpgrader(File directory) {
        this.directory = directory;
    }

    void startUpgradeManifest() {
        if (this.isFinalized) {
            throw new IllegalStateException("Upgrade is already finalized");
        }
        Wizardry.LOGGER.info("    > Starting to upgrade manifest ...");
        try {
            File externalManifest = new File(this.directory, "wizManifest.json");
            if (externalManifest.exists()) {
                if (!externalManifest.canRead()) {
                    Wizardry.LOGGER.error("    > SOMETHING WENT WRONG! Can't access manifest file for reading! No upgrade possible.");
                    this.hasErrors = true;
                    return;
                }
                this.manifestMap = new HashMap();
                ManifestUtils.loadManifestFile(externalManifest, this.manifestMap, false);
            }
        }
        catch (IOException exc) {
            Wizardry.LOGGER.error("    > SOMETHING WENT WRONG! Can't read manifest file! No upgrade possible.");
            this.hasErrors = true;
        }
    }

    public void changeCategoryName(String oldName, String newName) {
        File folder;
        HashMap<String, String> entry;
        if (this.hasErrors) {
            return;
        }
        if (this.isFinalized) {
            throw new IllegalStateException("Upgrade is already finalized");
        }
        if (this.manifestMap != null && (entry = this.manifestMap.get(oldName)) != null) {
            this.manifestMap.remove(oldName);
            this.manifestMap.put(newName, entry);
            this.hasManifestChanged = true;
        }
        if ((folder = new File(this.directory + "/" + oldName + "/")).exists()) {
            folder.renameTo(new File(this.directory + "/" + newName + "/"));
            this.hasFolderChanged = true;
        }
    }

    public void finalizeUpgrade() {
        if (this.hasErrors) {
            return;
        }
        if (this.isFinalized) {
            throw new IllegalStateException("Upgrade is already finalized");
        }
        try {
            if (this.manifestMap != null && this.hasManifestChanged) {
                File externalManifest = new File(this.directory, "wizManifest.json");
                externalManifest.delete();
                externalManifest.createNewFile();
                ManifestUtils.writeJsonToFile(ManifestUtils.generateManifestJson(this.manifestMap), externalManifest);
                Wizardry.LOGGER.info("    > Successfully updated manifest file");
            }
            if (!this.hasFolderChanged && !this.hasManifestChanged) {
                Wizardry.LOGGER.info("    > Manifest is up-to-date. No changes were performed.");
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        this.isFinalized = true;
    }
}

