/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.gui.pearlswap;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.animations.BasicAnimation;
import com.teamwizardry.librarianlib.features.animator.animations.ScheduledEventAnimation;
import com.teamwizardry.librarianlib.features.gui.GuiBase;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.gui.components.ComponentVoid;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.librarianlib.features.sprite.Sprite;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.api.item.BaublesSupport;
import com.teamwizardry.wizardry.api.item.INacreProduct;
import com.teamwizardry.wizardry.api.item.pearlswapping.IPearlStorageHolder;
import com.teamwizardry.wizardry.api.item.pearlswapping.IPearlSwappable;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.SpellUtils;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RenderUtils;
import com.teamwizardry.wizardry.client.gui.worktable.TableModule;
import com.teamwizardry.wizardry.common.network.pearlswapping.PacketRemovePearlFromBelt;
import com.teamwizardry.wizardry.common.network.pearlswapping.PacketSuccPearlsToStorageHolder;
import com.teamwizardry.wizardry.common.network.pearlswapping.PacketSwapPearl;
import com.teamwizardry.wizardry.init.ModSounds;
import java.awt.Color;
import java.io.IOException;
import java.util.List;
import kotlin.jvm.functions.Function2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiPearlSwap
extends GuiBase {
    private static final Sprite spritePlate = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/plate.png"));
    public final float[] slotRadii = new float[ConfigValues.pearlBeltInvSize];
    public final float[] itemDilaters = new float[ConfigValues.pearlBeltInvSize];
    private final Animator ANIMATOR = new Animator();
    private final BasicAnimation[] slotRadiusAnimations = new BasicAnimation[ConfigValues.pearlBeltInvSize];
    private final BasicAnimation[] itemDilationAnimations = new BasicAnimation[ConfigValues.pearlBeltInvSize];
    public double heartBeatRadius = 0.0;
    public double parasolGradientRadius = 0.0;
    public float color = RandUtil.nextFloat();
    public ComponentVoid componentCentralCircle;
    public float lockTransition = 0.0f;
    private BasicAnimation<ComponentVoid> centerRadiusAnim;
    private BasicAnimation<GuiPearlSwap> heartBeatAnim = new BasicAnimation((Object)this, "heartBeatRadius");
    private BasicAnimation<GuiPearlSwap> colorAnim = new BasicAnimation((Object)this, "color");
    private String centerText;
    private boolean lock = false;

    public GuiPearlSwap() {
        super(100, 100);
        ItemStack pearlStorageStack = this.getStorageHolderStack();
        if (pearlStorageStack.func_190926_b()) {
            return;
        }
        IPearlStorageHolder pearlStorage = (IPearlStorageHolder)pearlStorageStack.func_77973_b();
        this.componentCentralCircle = new ComponentVoid(0, 0, 0, 0);
        this.getMainComponents().add(new GuiComponent[]{this.componentCentralCircle});
        double centerRad = pearlStorage.getPearlCount(pearlStorageStack) == 0 ? (double)this.getGuiHeight() : (double)this.getGuiHeight() * 0.75;
        this.centerRadiusAnim = (BasicAnimation)new BasicAnimation((Object)this.componentCentralCircle, "size.x").from((Object)0).to((Object)centerRad).ease((Easing)Easing.easeOutQuint).duration(20.0f).addTo(this.ANIMATOR);
        int count = pearlStorage.getPearlCount(pearlStorageStack);
        if (count > 0) {
            new BasicAnimation((Object)this, "parasolGradientRadius").to((Object)(centerRad * 1.5)).ease((Easing)Easing.easeOutQuart).duration(15.0f).addTo(this.ANIMATOR);
            this.dilateItems();
        }
        this.ANIMATOR.add(new Animation[]{this.colorAnim, this.heartBeatAnim});
        this.updateText(Minecraft.func_71410_x().field_71439_g.func_184614_ca(), pearlStorageStack, pearlStorage);
        this.componentCentralCircle.BUS.hook(GuiComponentEvents.ComponentTickEvent.class, event -> {
            if (this.lock) {
                return;
            }
            ItemStack stack = this.getStorageHolderStack();
            if (stack.func_190926_b()) {
                return;
            }
            IPearlStorageHolder holder = (IPearlStorageHolder)stack.func_77973_b();
            this.updateText(Minecraft.func_71410_x().field_71439_g.func_184614_ca(), stack, holder);
            this.runAnimations();
            double mouseX = (double)Mouse.getEventX() - (double)this.field_146297_k.field_71443_c / 2.0;
            double mouseY = ((double)Mouse.getEventY() - (double)this.field_146297_k.field_71440_d / 2.0) * -1.0;
            Vec2d vec = new Vec2d(mouseX, mouseY);
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            if (vec.length() <= this.componentCentralCircle.getSize().getX() * (double)scaledResolution.func_78325_e()) {
                this.unSelectAll();
                return;
            }
            double relativeMX = (double)Mouse.getEventX() / (double)this.field_146297_k.field_71443_c / 0.5 - 1.0;
            double relativeMY = ((double)Mouse.getEventY() / (double)this.field_146297_k.field_71440_d / 0.5 - 1.0) * -1.0;
            if (this.field_146297_k.field_71443_c > this.field_146297_k.field_71440_d) {
                relativeMY *= (double)this.field_146297_k.field_71440_d / (double)this.field_146297_k.field_71443_c;
            } else if (this.field_146297_k.field_71440_d > this.field_146297_k.field_71443_c) {
                relativeMX *= (double)this.field_146297_k.field_71443_c / (double)this.field_146297_k.field_71440_d;
            }
            double pointerAngle = (Math.atan2(relativeMY, relativeMX) + Math.PI * 2) % (Math.PI * 2);
            int pearlCount = Math.max(holder.getPearlCount(stack), 0);
            if (pearlCount != 0) {
                double anglePerColor = Math.PI * 2 / (double)pearlCount;
                int pointerIndex = (int)(pointerAngle / anglePerColor);
                this.select(pointerIndex);
            }
        });
        this.componentCentralCircle.BUS.hook(GuiComponentEvents.PreDrawEvent.class, event -> {
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder bb = tess.func_178180_c();
            ItemStack stack = this.getStorageHolderStack();
            if (stack.func_190926_b()) {
                return;
            }
            IPearlStorageHolder holder = (IPearlStorageHolder)stack.func_77973_b();
            this.renderCenteralCircle(tess, bb, event.component.getSize().getX());
            this.renderParasol(tess, bb, stack, holder, event.component.getSize().getX());
        });
    }

    protected void func_73864_a(int x, int y, int mouseButton) throws IOException {
        super.func_73864_a(x, y, mouseButton);
        if (mouseButton != 0 || this.lock) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack heldItem = player.func_184614_ca();
        ItemStack stack = this.getStorageHolderStack();
        if (stack.func_190926_b()) {
            return;
        }
        IPearlStorageHolder holder = (IPearlStorageHolder)stack.func_77973_b();
        IItemHandler handler = holder.getPearls(stack);
        if (handler == null) {
            return;
        }
        double mouseX = (double)Mouse.getEventX() - (double)this.field_146297_k.field_71443_c / 2.0;
        double mouseY = ((double)Mouse.getEventY() - (double)this.field_146297_k.field_71440_d / 2.0) * -1.0;
        Vec2d vec = new Vec2d(mouseX, mouseY);
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        if (vec.length() <= this.componentCentralCircle.getSize().getX() * (double)scaledResolution.func_78325_e()) {
            if (heldItem.func_77973_b() instanceof IPearlStorageHolder) {
                this.succPearlsToBelt();
            }
            return;
        }
        double relativeMX = (double)Mouse.getEventX() / (double)this.field_146297_k.field_71443_c / 0.5 - 1.0;
        double relativeMY = ((double)Mouse.getEventY() / (double)this.field_146297_k.field_71440_d / 0.5 - 1.0) * -1.0;
        if (this.field_146297_k.field_71443_c > this.field_146297_k.field_71440_d) {
            relativeMY *= (double)this.field_146297_k.field_71440_d / (double)this.field_146297_k.field_71443_c;
        } else if (this.field_146297_k.field_71440_d > this.field_146297_k.field_71443_c) {
            relativeMX *= (double)this.field_146297_k.field_71443_c / (double)this.field_146297_k.field_71440_d;
        }
        double pointerAngle = (Math.atan2(relativeMY, relativeMX) + Math.PI * 2) % (Math.PI * 2);
        int pearlCount = Math.max(holder.getPearlCount(stack), 0);
        if (pearlCount != 0) {
            double anglePerColor = Math.PI * 2 / (double)pearlCount;
            int pointerIndex = (int)(pointerAngle / anglePerColor);
            if (heldItem.func_77973_b() instanceof IPearlStorageHolder) {
                this.popPearlFromBelt(pointerIndex);
            } else if (heldItem.func_77973_b() instanceof IPearlSwappable) {
                this.swapPearl(pointerIndex);
            }
        }
    }

    private void updateText(ItemStack heldItem, ItemStack pearlStorageStack, IPearlStorageHolder pearlStorage) {
        int count = pearlStorage.getPearlCount(pearlStorageStack);
        if (count > 0) {
            IItemHandler itemHandler = pearlStorage.getPearls(pearlStorageStack);
            if (itemHandler != null) {
                if (heldItem.func_77973_b() instanceof IPearlStorageHolder) {
                    this.centerText = count >= itemHandler.getSlots() ? LibrarianLib.PROXY.translate("wizardry.pearlui.belt_full", new Object[0]) + "\n\n" + LibrarianLib.PROXY.translate("wizardry.pearlui.pop_pearls", new Object[0]) : LibrarianLib.PROXY.translate("wizardry.pearlui.pop_pearls", new Object[0]) + "\n\n" + LibrarianLib.PROXY.translate("wizardry.pearlui.attach_pearls", new Object[0]);
                } else if (heldItem.func_77973_b() instanceof IPearlSwappable) {
                    this.centerText = LibrarianLib.PROXY.translate("wizardry.pearlui.pop_pearls", new Object[0]);
                }
            }
        } else if (heldItem.func_77973_b() instanceof IPearlStorageHolder) {
            this.centerText = LibrarianLib.PROXY.translate("wizardry.pearlui.attach_pearls", new Object[0]);
        }
    }

    public void lock() {
        this.lock = true;
        this.unSelectAll();
        new BasicAnimation((Object)this, "lockTransition").to((Object)Float.valueOf(1.0f)).ease((Easing)Easing.easeOutQuint).duration(20.0f).addTo(this.ANIMATOR);
    }

    public void unlock() {
        this.lock = false;
        new BasicAnimation((Object)this, "lockTransition").to((Object)Float.valueOf(0.0f)).ease((Easing)Easing.easeOutQuint).duration(20.0f).addTo(this.ANIMATOR);
    }

    public void update(int originalPearlCount, int newPearlCount, int index) {
        this.unlock();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (originalPearlCount != newPearlCount) {
            if (originalPearlCount == 0) {
                this.dilateItems();
            } else {
                this.contractItems();
                if (newPearlCount != 0) {
                    this.ANIMATOR.add(new Animation[]{new ScheduledEventAnimation(10.0f, this::dilateItems)});
                }
            }
            player.func_184185_a((SoundEvent)ModSounds.POP, 1.0f, 1.0f);
        } else if (newPearlCount != 0 && index != -1) {
            this.contractItem(index);
            this.ANIMATOR.add(new Animation[]{new ScheduledEventAnimation(10.0f, () -> this.dilateItem(index))});
            player.func_184185_a((SoundEvent)ModSounds.POP, 1.0f, 1.0f);
        } else {
            player.func_184185_a((SoundEvent)ModSounds.SPELL_FAIL, 1.0f, 1.0f);
        }
        double centerRad = newPearlCount == 0 ? (double)this.getGuiHeight() : (double)this.getGuiHeight() * 0.75;
        new BasicAnimation((Object)this, "parasolGradientRadius").to((Object)(centerRad * 1.5)).ease((Easing)Easing.easeOutQuart).duration(15.0f).addTo(this.ANIMATOR);
        this.centerRadiusAnim = (BasicAnimation)new BasicAnimation((Object)this.componentCentralCircle, "size.x").to((Object)centerRad).ease((Easing)Easing.easeOutQuint).duration(20.0f).addTo(this.ANIMATOR);
    }

    private ItemStack getStorageHolderStack() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof IPearlStorageHolder) {
            return heldItem;
        }
        if (heldItem.func_77973_b() instanceof IPearlSwappable) {
            return BaublesSupport.getItem((EntityLivingBase)player, IPearlStorageHolder.class);
        }
        return ItemStack.field_190927_a;
    }

    private void popPearlFromBelt(int index) {
        PacketHandler.NETWORK.sendToServer((IMessage)new PacketRemovePearlFromBelt(index));
        this.lock();
    }

    private void swapPearl(int index) {
        PacketHandler.NETWORK.sendToServer((IMessage)new PacketSwapPearl(index));
        this.lock();
    }

    private void succPearlsToBelt() {
        PacketHandler.NETWORK.sendToServer((IMessage)new PacketSuccPearlsToStorageHolder());
        this.lock();
    }

    private void unSelectAll() {
        for (int i = 0; i < this.slotRadiusAnimations.length; ++i) {
            this.unSelect(i);
        }
    }

    private void unSelect(int i) {
        if (this.slotRadii[i] == 0.0f) {
            return;
        }
        if (this.slotRadiusAnimations[i] != null) {
            this.slotRadiusAnimations[i] = null;
        }
        this.slotRadiusAnimations[i] = (BasicAnimation)new BasicAnimation((Object)this, "slotRadii[" + i + "]").to((Object)Float.valueOf(0.0f)).ease((Easing)Easing.easeOutQuint).duration(10.0f).addTo(this.ANIMATOR);
    }

    private void select(int i) {
        for (int j = 0; j < this.slotRadiusAnimations.length; ++j) {
            if (i == j) continue;
            this.unSelect(j);
        }
        if (this.slotRadii[i] == 1.0f) {
            return;
        }
        if (this.slotRadiusAnimations[i] != null) {
            this.slotRadiusAnimations[i] = null;
        }
        this.slotRadiusAnimations[i] = (BasicAnimation)new BasicAnimation((Object)this, "slotRadii[" + i + "]").to((Object)Float.valueOf(1.0f)).ease((Easing)Easing.easeOutQuint).duration(10.0f).addTo(this.ANIMATOR);
    }

    private void dilateItem(int i) {
        if (this.itemDilationAnimations[i] != null) {
            this.itemDilationAnimations[i] = null;
        }
        this.itemDilationAnimations[i] = (BasicAnimation)new BasicAnimation((Object)this, "itemDilaters[" + i + "]").from((Object)Float.valueOf(0.0f)).to((Object)Float.valueOf(1.0f)).ease((Easing)Easing.easeOutQuint).duration(20.0f).addTo(this.ANIMATOR);
        this.unSelect(i);
    }

    private void dilateItems() {
        for (int i = 0; i < this.itemDilaters.length; ++i) {
            if (this.itemDilationAnimations[i] != null) {
                this.itemDilationAnimations[i] = null;
            }
            this.itemDilationAnimations[i] = (BasicAnimation)new BasicAnimation((Object)this, "itemDilaters[" + i + "]").to((Object)Float.valueOf(1.0f)).ease((Easing)Easing.easeOutQuint).start(1.5f * (float)(i + 1)).duration(20.0f).addTo(this.ANIMATOR);
            this.unSelect(i);
        }
    }

    private void contractItem(int i) {
        if (this.itemDilationAnimations[i] != null) {
            this.itemDilationAnimations[i] = null;
        }
        this.itemDilationAnimations[i] = (BasicAnimation)new BasicAnimation((Object)this, "itemDilaters[" + i + "]").from((Object)Float.valueOf(1.0f)).to((Object)Float.valueOf(0.0f)).ease((Easing)Easing.easeOutQuint).duration(20.0f).addTo(this.ANIMATOR);
        this.unSelect(i);
    }

    private void contractItems() {
        for (int i = 0; i < this.itemDilaters.length; ++i) {
            if (this.itemDilationAnimations[i] != null) {
                this.itemDilationAnimations[i] = null;
            }
            this.itemDilationAnimations[i] = (BasicAnimation)new BasicAnimation((Object)this, "itemDilaters[" + i + "]").to((Object)Float.valueOf(0.0f)).ease((Easing)Easing.easeOutQuint).duration(20.0f).addTo(this.ANIMATOR);
            this.unSelect(i);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void renderParasol(Tessellator tess, BufferBuilder bb, ItemStack holderStack, IPearlStorageHolder holder, double radius) {
        int pearlCount = holder.getPearlCount(holderStack);
        IItemHandler handler = holder.getPearls(holderStack);
        if (pearlCount != 0 && handler != null) {
            double innerRadius = radius + 0.5;
            int numSegmentsPerArc = (int)Math.ceil(360.0 / (double)pearlCount);
            float anglePerColor = (float)(Math.PI * 2 / (double)pearlCount);
            float anglePerSegment = anglePerColor / (float)numSegmentsPerArc;
            float angle = 0.0f;
            for (int j = 0; j < pearlCount; ++j) {
                INacreProduct product;
                Function2<ItemStack, Integer, Integer> function;
                ItemStack pearl = handler.getStackInSlot(j);
                if (!(pearl.func_77973_b() instanceof INacreProduct) || (function = (product = (INacreProduct)pearl.func_77973_b()).getItemColorFunction()) == null) continue;
                int colorInt = (Integer)function.invoke((Object)pearl, (Object)0);
                Color color = new Color(colorInt);
                double outerRadius = this.parasolGradientRadius + (double)this.slotRadii[j];
                GlStateManager.func_179094_E();
                int thing1 = GL11.glGetInteger((int)3009);
                float thing2 = GL11.glGetFloat((int)3010);
                GlStateManager.func_179103_j((int)7425);
                GlStateManager.func_179092_a((int)519, (float)1.0f);
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179090_x();
                GlStateManager.func_179137_b((double)((double)this.getGuiWidth() / 2.0), (double)((double)this.getGuiHeight() / 2.0), (double)0.0);
                bb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                for (int i = 0; i < numSegmentsPerArc; ++i) {
                    float currentAngle = (float)i * anglePerSegment + angle;
                    bb.func_181662_b(innerRadius * (double)MathHelper.func_76134_b((float)currentAngle), innerRadius * (double)MathHelper.func_76126_a((float)currentAngle), 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), (int)(this.itemDilaters[j] * 255.0f)).func_181675_d();
                    bb.func_181662_b(innerRadius * (double)MathHelper.func_76134_b((float)(currentAngle + anglePerSegment)), innerRadius * (double)MathHelper.func_76126_a((float)(currentAngle + anglePerSegment)), 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), (int)(this.itemDilaters[j] * 255.0f)).func_181675_d();
                    bb.func_181662_b(outerRadius * (double)MathHelper.func_76134_b((float)(currentAngle + anglePerSegment)), outerRadius * (double)MathHelper.func_76126_a((float)(currentAngle + anglePerSegment)), 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 0).func_181675_d();
                    bb.func_181662_b(outerRadius * (double)MathHelper.func_76134_b((float)currentAngle), outerRadius * (double)MathHelper.func_76126_a((float)currentAngle), 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 0).func_181675_d();
                }
                tess.func_78381_a();
                float centerAngle = angle + anglePerColor / 2.0f;
                Vec3d inner = new Vec3d(innerRadius * (double)MathHelper.func_76134_b((float)centerAngle), innerRadius * (double)MathHelper.func_76126_a((float)centerAngle), 0.0);
                Vec3d outer = new Vec3d(outerRadius * (double)MathHelper.func_76134_b((float)centerAngle), outerRadius * (double)MathHelper.func_76126_a((float)centerAngle), 0.0);
                Vec3d center = new Vec3d((inner.field_72450_a + outer.field_72450_a) / 2.0, (inner.field_72448_b + outer.field_72448_b) / 2.0, 0.0);
                Vec3d normal = center.func_72432_b();
                Vec3d pearlOffset = normal.func_186678_a(radius / 2.0).func_186678_a((double)this.itemDilaters[j]);
                RenderUtils.renderItemStackWithOpacity(pearl, this.itemDilaters[j], () -> GlStateManager.func_179137_b((double)(pearlOffset.field_72450_a - 8.0), (double)(pearlOffset.field_72448_b - 8.0), (double)0.0));
                GlStateManager.func_179137_b((double)(-pearlOffset.field_72450_a + 8.0), (double)(-pearlOffset.field_72448_b + 8.0), (double)0.0);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)20.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.itemDilaters[j]);
                GlStateManager.func_179098_w();
                List<SpellRing> rings = SpellUtils.getSpellChains(pearl);
                float startAngle = angle + 0.25f;
                float endAngle = angle + anglePerColor - 0.25f;
                float anglePerRing = (endAngle - startAngle) / (float)(rings.size() + 1);
                float size = 10.0f;
                for (int i = 0; i < rings.size(); ++i) {
                    float currentAngle = startAngle + (float)(i + 1) * anglePerRing;
                    double x = MathHelper.func_76134_b((float)currentAngle);
                    double y = MathHelper.func_76126_a((float)currentAngle);
                    Vec3d chainNormal = new Vec3d(x, y, 0.0).func_72432_b();
                    Vec3d chainOffset = chainNormal.func_186678_a(radius / 2.0 * (double)this.itemDilaters[j]).func_178787_e(chainNormal.func_186678_a((double)size).func_186678_a((double)this.itemDilaters[j]));
                    List<SpellRing> allSpellRings = SpellUtils.getAllSpellRings(rings.get(i));
                    for (int k = 0; k < allSpellRings.size(); ++k) {
                        SpellRing linksTo;
                        ModuleInstance linksToModule;
                        SpellRing ring = allSpellRings.get(k);
                        ModuleInstance module = ring.getModule();
                        if (module == null) continue;
                        Sprite moduleSprite = new Sprite(module.getIconLocation());
                        Vec3d moduleVec = chainOffset.func_178787_e(chainNormal.func_186678_a((double)size * 1.5).func_186678_a((double)k).func_186678_a((double)this.itemDilaters[j]));
                        spritePlate.bind();
                        spritePlate.draw(0, (float)moduleVec.field_72450_a - size / 2.0f, (float)moduleVec.field_72448_b - size / 2.0f, size, size);
                        moduleSprite.bind();
                        moduleSprite.draw(0, (float)moduleVec.field_72450_a - (size - 1.0f) / 2.0f, (float)moduleVec.field_72448_b - (size - 1.0f) / 2.0f, size - 1.0f, size - 1.0f);
                        if (k + 1 >= allSpellRings.size() || (linksToModule = (linksTo = allSpellRings.get(k + 1)).getModule()) == null) continue;
                        Vec3d linksToVec = chainOffset.func_178787_e(chainNormal.func_186678_a((double)size * 1.5).func_186678_a((double)(k + 1)).func_186678_a((double)this.itemDilaters[j]));
                        TableModule.drawWire(new Vec2d(moduleVec.field_72450_a, moduleVec.field_72448_b), new Vec2d(linksToVec.field_72450_a, linksToVec.field_72448_b), TableModule.getColorForModule(module.getModuleType()), TableModule.getColorForModule(linksToModule.getModuleType()));
                    }
                }
                GlStateManager.func_179092_a((int)thing1, (float)thing2);
                GlStateManager.func_179137_b((double)((double)(-this.getGuiWidth()) / 2.0), (double)((double)(-this.getGuiHeight()) / 2.0), (double)0.0);
                GlStateManager.func_179121_F();
                angle += anglePerColor;
            }
        }
    }

    private void runAnimations() {
        if (this.colorAnim.getFinished()) {
            this.colorAnim = new BasicAnimation((Object)this, "color");
            this.colorAnim.setTo((Object)Float.valueOf(this.color + 0.25f > 1.0f ? 0.25f : this.color + 0.25f));
            this.colorAnim.setEasing(Easing.linear);
            this.colorAnim.setDuration(100.0f);
            this.ANIMATOR.add(new Animation[]{this.colorAnim});
        }
        if (this.centerRadiusAnim.getFinished() && this.heartBeatAnim.getFinished()) {
            this.heartBeatAnim = new BasicAnimation((Object)this, "heartBeatRadius");
            this.heartBeatAnim.setTo((Object)this.componentCentralCircle.getSize().getX());
            this.heartBeatAnim.setFrom((Object)0.0);
            this.heartBeatAnim.setEasing((Easing)Easing.easeOutQuint);
            this.heartBeatAnim.setDuration(100.0f);
            this.ANIMATOR.add(new Animation[]{this.heartBeatAnim});
        }
    }

    private void renderCenteralCircle(Tessellator tess, BufferBuilder bb, double radius) {
        double angle;
        double y;
        double x;
        GlStateManager.func_179094_E();
        int thing1 = GL11.glGetInteger((int)3009);
        float thing2 = GL11.glGetFloat((int)3010);
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179129_p();
        GlStateManager.func_179092_a((int)519, (float)1.0f);
        GlStateManager.func_179137_b((double)((double)this.getGuiWidth() / 2.0), (double)((double)this.getGuiHeight() / 2.0), (double)0.0);
        GlStateManager.func_187441_d((float)2.0f);
        double vertexCount = 100.0;
        Color transitioningColor = new Color(Color.HSBtoRGB(this.color, 0.25f, 1.0f));
        Color color = new Color((float)transitioningColor.getRed() / 255.0f, (float)transitioningColor.getGreen() / 255.0f, (float)transitioningColor.getBlue() / 255.0f, MathHelper.func_76131_a((float)(1.0f - (float)(this.heartBeatRadius / radius)), (float)0.0f, (float)1.0f));
        bb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        bb.func_181662_b(0.0, 0.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 0).func_181675_d();
        int i = 0;
        while ((double)i < vertexCount) {
            double angle2 = (double)i * 2.0 * Math.PI / vertexCount;
            x = (double)MathHelper.func_76134_b((float)((float)angle2)) * this.heartBeatRadius;
            y = (double)MathHelper.func_76126_a((float)((float)angle2)) * this.heartBeatRadius;
            bb.func_181662_b(y, x, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            ++i;
        }
        x = (double)MathHelper.func_76134_b((float)((float)Math.PI * 2)) * this.heartBeatRadius;
        y = (double)MathHelper.func_76126_a((float)((float)Math.PI * 2)) * this.heartBeatRadius;
        bb.func_181662_b(y, x, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tess.func_78381_a();
        float[] hsv = new float[3];
        Color.RGBtoHSB(transitioningColor.getRed(), transitioningColor.getGreen(), transitioningColor.getBlue(), hsv);
        hsv[2] = hsv[2] * (1.0f - this.lockTransition);
        color = Color.getHSBColor(hsv[0], hsv[1], hsv[2]);
        color = new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.5f);
        bb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        bb.func_181662_b(0.0, 0.0, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        int i2 = 0;
        while ((double)i2 < vertexCount) {
            angle = (double)i2 * 2.0 * Math.PI / vertexCount;
            x = (double)MathHelper.func_76134_b((float)((float)angle)) * radius;
            y = (double)MathHelper.func_76126_a((float)((float)angle)) * radius;
            bb.func_181662_b(y, x, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            ++i2;
        }
        x = (double)MathHelper.func_76134_b((float)((float)Math.PI * 2)) * radius;
        y = (double)MathHelper.func_76126_a((float)((float)Math.PI * 2)) * radius;
        bb.func_181662_b(y, x, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tess.func_78381_a();
        color = Color.DARK_GRAY;
        bb.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        i2 = 0;
        while ((double)i2 < vertexCount) {
            angle = (double)i2 * 2.0 * Math.PI / vertexCount;
            x = (double)MathHelper.func_76134_b((float)((float)angle)) * radius;
            y = (double)MathHelper.func_76126_a((float)((float)angle)) * radius;
            bb.func_181662_b(y, x, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
            ++i2;
        }
        x = (double)MathHelper.func_76134_b((float)((float)Math.PI * 2)) * radius;
        y = (double)MathHelper.func_76126_a((float)((float)Math.PI * 2)) * radius;
        bb.func_181662_b(y, x, 0.0).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179092_a((int)thing1, (float)thing2);
        GlStateManager.func_179137_b((double)((double)(-this.getGuiWidth()) / 2.0), (double)((double)(-this.getGuiHeight()) / 2.0), (double)0.0);
        GlStateManager.func_179121_F();
        this.renderText(this.centerText);
    }

    private int getTextY(int lineCount, int lineIndex) {
        int fontH = Minecraft.func_71410_x().field_71466_p.field_78288_b;
        return (int)((double)(-fontH) * ((double)lineCount / 2.0) + (double)(lineIndex * fontH));
    }

    private void renderText(String string) {
        if (string == null) {
            return;
        }
        if (string.isEmpty()) {
            return;
        }
        List lines = this.field_146289_q.func_78271_c(string, 120);
        if (lines.isEmpty()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179098_w();
        GlStateManager.func_179137_b((double)((double)this.getGuiWidth() / 2.0), (double)((double)this.getGuiHeight() / 2.0), (double)0.0);
        for (int i = 0; i < lines.size(); ++i) {
            String text = (String)lines.get(i);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(text, (int)((double)(-Minecraft.func_71410_x().field_71466_p.func_78256_a(text)) / 2.0), this.getTextY(lines.size(), i), 0);
        }
        float rot1 = MathHelper.func_76126_a((float)((float)ClientTickHandler.getTicks() / 50.0f)) * 5.0f;
        GlStateManager.func_179114_b((float)rot1, (float)0.0f, (float)0.0f, (float)(1.0f * ClientTickHandler.getPartialTicks()));
        for (int i = 0; i < lines.size(); ++i) {
            String text = (String)lines.get(i);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(text, (int)((double)(-Minecraft.func_71410_x().field_71466_p.func_78256_a(text)) / 2.0), this.getTextY(lines.size(), i), 0x2B000000);
        }
        GlStateManager.func_179114_b((float)(-rot1), (float)0.0f, (float)0.0f, (float)(1.0f * ClientTickHandler.getPartialTicks()));
        float rot2 = MathHelper.func_76126_a((float)((float)ClientTickHandler.getTicks() / 20.0f)) * 6.0f;
        GlStateManager.func_179114_b((float)rot2, (float)0.0f, (float)0.0f, (float)(1.0f * ClientTickHandler.getPartialTicks()));
        for (int i = 0; i < lines.size(); ++i) {
            String text = (String)lines.get(i);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(text, (int)((double)(-Minecraft.func_71410_x().field_71466_p.func_78256_a(text)) / 2.0), this.getTextY(lines.size(), i), 0x21000000);
        }
        GlStateManager.func_179114_b((float)(-rot2), (float)0.0f, (float)0.0f, (float)(1.0f * ClientTickHandler.getPartialTicks()));
        GlStateManager.func_179137_b((double)((double)(-this.getGuiWidth()) / 2.0), (double)((double)(-this.getGuiHeight()) / 2.0), (double)0.0);
        GlStateManager.func_179121_F();
    }
}

