/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell.module;

import com.teamwizardry.wizardry.api.spell.annotation.ModuleParameter;
import com.teamwizardry.wizardry.api.spell.module.IModule;
import com.teamwizardry.wizardry.api.spell.module.ModuleInitException;
import com.teamwizardry.wizardry.api.spell.module.ModuleOverrideHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ModuleFactory {
    private final Class<? extends IModule> clazz;
    private final HashMap<Map<String, Object>, IModule> instances = new HashMap();
    private final HashMap<String, Field> configurableFields = new HashMap();
    private final HashMap<String, ModuleOverrideHandler.OverrideMethod> overridableMethods = new HashMap();
    private final String referenceModuleID;

    ModuleFactory(String referenceModuleID, Class<? extends IModule> clazz) throws ModuleInitException {
        this.clazz = clazz;
        this.referenceModuleID = referenceModuleID;
        for (Field field : clazz.getFields()) {
            ModuleParameter cfg = field.getDeclaredAnnotation(ModuleParameter.class);
            if (cfg == null) continue;
            try {
                field.setAccessible(true);
            }
            catch (SecurityException e) {
                throw new ModuleInitException("Failed to acquire reflection access to field '" + field.toString() + "', annotated by @ModuleParameter.", e);
            }
            this.configurableFields.put(cfg.value(), field);
        }
        this.overridableMethods.putAll(ModuleOverrideHandler.getOverrideMethodsFromClass(clazz, true));
    }

    public Class<? extends IModule> getModuleClass() {
        return this.clazz;
    }

    public String getReferenceModuleID() {
        return this.referenceModuleID;
    }

    public Map<String, ModuleOverrideHandler.OverrideMethod> getOverrides() {
        return Collections.unmodifiableMap(this.overridableMethods);
    }

    public boolean hasConfigField(String key) {
        return this.configurableFields.containsKey(key);
    }

    public boolean hasOverrides() {
        return !this.overridableMethods.isEmpty();
    }

    public IModule getInstance() throws ModuleInitException {
        return this.getInstance(new HashMap<String, Object>());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IModule getInstance(HashMap<String, Object> params) throws ModuleInitException {
        IModule module = this.instances.get(params);
        if (module != null) {
            return module;
        }
        try {
            Constructor<? extends IModule> ctor = this.clazz.getConstructor(new Class[0]);
            module = ctor.newInstance(new Object[0]);
            int countFields = 0;
            for (Map.Entry<String, Field> cfgField : this.configurableFields.entrySet()) {
                Object value = params.get(cfgField.getKey());
                if (value == null) {
                    throw new IllegalArgumentException("Field value for '" + cfgField.getKey() + "' is not mapped in configuration.");
                }
                Field field = cfgField.getValue();
                if (Enum.class.isAssignableFrom(field.getType())) {
                    Class<?> enumType = field.getType();
                    Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
                    boolean found = false;
                    String strValue = value.toString();
                    for (Enum cnst : enumConstants) {
                        if (!cnst.toString().equalsIgnoreCase(strValue)) continue;
                        field.set(module, cnst);
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new ModuleInitException("Unknown enumeration value '" + strValue + "' for field '" + cfgField.getKey() + "' in '" + this.referenceModuleID + "'.");
                    }
                } else if (value instanceof Number) {
                    Number number = (Number)value;
                    if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
                        field.set(module, number.intValue());
                    } else if (field.getType().equals(Long.TYPE) || field.getType().equals(Long.class)) {
                        field.set(module, number.longValue());
                    } else if (field.getType().equals(Float.TYPE) || field.getType().equals(Float.class)) {
                        field.set(module, Float.valueOf(number.floatValue()));
                    } else if (field.getType().equals(Double.TYPE) || field.getType().equals(Double.class)) {
                        field.set(module, number.doubleValue());
                    } else if (field.getType().equals(Byte.TYPE) || field.getType().equals(Byte.class)) {
                        field.set(module, number.byteValue());
                    } else {
                        if (!field.getType().equals(String.class)) throw new ModuleInitException("Incompatible datatype for field '" + cfgField.getKey() + "' in '" + this.referenceModuleID + "'. Configuration is a number.");
                        field.set(module, number.toString());
                    }
                } else if (value instanceof String) {
                    field.set(module, value);
                } else {
                    if (!(value instanceof Boolean)) throw new ModuleInitException("Incompatible datatype for field '" + cfgField.getKey() + "' in '" + this.referenceModuleID + "'. Configuration has an unknown value type.");
                    Boolean bval = (boolean)((Boolean)value);
                    if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                        field.set(module, bval);
                    } else {
                        if (!field.getType().equals(String.class)) throw new ModuleInitException("Incompatible datatype for field '" + cfgField.getKey() + "' in '" + this.referenceModuleID + "'. Configuration is a boolean.");
                        field.set(module, bval.toString());
                    }
                }
                ++countFields;
            }
            if (countFields != this.configurableFields.size()) {
                throw new ModuleInitException("Unknown field mappings exist for module '" + this.referenceModuleID + "'.");
            }
        }
        catch (Exception e) {
            throw new ModuleInitException("Couldn't initialize module '" + this.referenceModuleID + "'. See cause.", e);
        }
        this.instances.put(params, module);
        return module;
    }
}

