/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell.attribute;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class AttributeRegistry {
    public static final Attribute POTENCY = new Attribute("modifier_increase_strength", "potency", true);
    public static final Attribute DURATION = new Attribute("modifier_extend_time", "duration", true);
    public static final Attribute RANGE = new Attribute("modifier_extend_range", "range", true);
    public static final Attribute AREA = new Attribute("modifier_increase_aoe", "area", true);
    public static final Attribute SPEED = new Attribute("modifier_increase_speed", "speed", true);
    public static final Attribute MANA = new Attribute("modifier_mana_cost", "mana", false);
    public static final Attribute BURNOUT = new Attribute("modifier_burnout_value", "burnout", false);
    public static final Attribute COOLDOWN = new Attribute("modifier_cooldown_time", "cooldown", false);
    public static final Attribute CHARGEUP = new Attribute("modifier_chargeup_time", "chargeup", false);
    public static final Attribute POWER_MULTI = new Attribute("power_multiplier", false);
    public static final Attribute MANA_MULTI = new Attribute("mana_multiplier", false);
    public static final Attribute BURNOUT_MULTI = new Attribute("burnout_multiplier", false);
    private static final Set<Attribute> attributes = new HashSet<Attribute>();

    public static void addAttribute(Attribute attribute) {
        attributes.add(attribute);
    }

    @Nullable
    public static Attribute getAttributeFromName(String name) {
        for (Attribute attribute : attributes) {
            if (!attribute.getNbtName().equals(name) && !attribute.getShortName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    static {
        AttributeRegistry.addAttribute(POTENCY);
        AttributeRegistry.addAttribute(DURATION);
        AttributeRegistry.addAttribute(RANGE);
        AttributeRegistry.addAttribute(AREA);
        AttributeRegistry.addAttribute(SPEED);
        AttributeRegistry.addAttribute(MANA);
        AttributeRegistry.addAttribute(BURNOUT);
        AttributeRegistry.addAttribute(COOLDOWN);
        AttributeRegistry.addAttribute(CHARGEUP);
        AttributeRegistry.addAttribute(POWER_MULTI);
        AttributeRegistry.addAttribute(MANA_MULTI);
        AttributeRegistry.addAttribute(BURNOUT_MULTI);
    }

    public static class Attribute {
        private final String nbtName;
        private final String shortName;
        private final boolean hasDetailedText;

        public Attribute(String nbtName, String shortName, boolean hasDetailedText) {
            this.nbtName = nbtName;
            this.shortName = shortName;
            this.hasDetailedText = hasDetailedText;
        }

        public Attribute(String name, boolean hasDetailedText) {
            this(name, name, hasDetailedText);
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getNbtName() {
            return this.nbtName;
        }

        public boolean hasDetailedText() {
            return this.hasDetailedText;
        }

        public String toString() {
            return this.shortName;
        }
    }
}

