/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.effects;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.potion.PotionMod;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="quark")
public class PotionColorizer
extends PotionMod {
    public final int color;
    public final float r;
    public final float g;
    public final float b;

    public PotionColorizer(String name, int color, int iconIndex) {
        super(name, true, color, iconIndex);
        this.color = color;
        this.r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        this.g = (float)((color & 0xFF00) >> 8) / 255.0f;
        this.b = (float)(color & 0xFF) / 255.0f;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void colorize(RenderLivingEvent.Pre event) {
        PotionColorizer.colorEntity(event.getEntity());
    }

    public static void colorEntity(EntityLivingBase entity) {
        float rMix = 0.0f;
        float gMix = 0.0f;
        float bMix = 0.0f;
        int total = 0;
        for (PotionEffect effect : entity.func_70651_bq()) {
            if (!(effect.func_188419_a() instanceof PotionColorizer)) continue;
            rMix += ((PotionColorizer)effect.func_188419_a()).r;
            gMix += ((PotionColorizer)effect.func_188419_a()).g;
            bMix += ((PotionColorizer)effect.func_188419_a()).b;
            ++total;
        }
        if (total > 0) {
            GlStateManager.func_179124_c((float)(rMix /= (float)total), (float)(gMix /= (float)total), (float)(bMix /= (float)total));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void colorize(RenderLivingEvent.Post event) {
        for (PotionEffect effect : event.getEntity().func_70651_bq()) {
            if (!(effect.func_188419_a() instanceof PotionColorizer)) continue;
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            return;
        }
    }
}

