/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import romelo333.notenoughwands.ConfigSetup;
import romelo333.notenoughwands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class FreezingWand
extends GenericWand {
    private boolean allowPassive = true;
    private boolean allowHostile = true;
    private float difficultyMult = 0.0f;
    private float diffcultyAdd = 1.0f;

    public FreezingWand() {
        this.setup("freezing_wand").xpUsage(10).loot(0);
    }

    @Override
    public void initConfig(Configuration cfg) {
        super.initConfig(cfg, 200, 100000, 100, 200000, 50, 500000);
        this.allowPassive = cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_allowPassive", this.allowPassive, "Allow freeze passive mobs").getBoolean();
        this.allowHostile = cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_allowHostile", this.allowHostile, "Allow freeze hostile mobs").getBoolean();
        this.difficultyMult = (float)cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_difficultyMult", (double)this.difficultyMult, "Multiply the HP of a mob with this number to get the difficulty scale that affects XP/RF usage (a final result of 1.0 means that the default XP/RF is used)").getDouble();
        this.diffcultyAdd = (float)cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_diffcultyAdd", (double)this.diffcultyAdd, "Add this to the HP * difficultyMult to get the final difficulty scale that affects XP/RF usage (a final result of 1.0 means that the default XP/RF is used)").getDouble();
    }

    public void func_77624_a(ItemStack stack, World player, List list, ITooltipFlag b) {
        super.func_77624_a(stack, player, list, b);
        list.add("Right click on creature to freeze creature.");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            // empty if block
        }
        return EnumActionResult.FAIL;
    }

    private void freezeMob(EntityLivingBase mob) {
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.func_130014_f_().field_72995_K) {
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                if (entityLivingBase instanceof EntityPlayer) {
                    Tools.error(player, "You cannot use this on players!");
                    return true;
                }
                if (!this.allowHostile && entityLivingBase instanceof IMob) {
                    Tools.error(player, "It is not possible to freeze hostile mobs with this wand!");
                    return true;
                }
                if (!this.allowPassive && !(entityLivingBase instanceof IMob)) {
                    Tools.error(player, "It is not possible to freeze passive mobs with this wand!");
                    return true;
                }
                float difficultyScale = entityLivingBase.func_110138_aP() * this.difficultyMult + this.diffcultyAdd;
                if (!this.checkUsage(stack, player, difficultyScale)) {
                    return true;
                }
                this.freezeMob(entityLivingBase);
                this.registerUsage(stack, player, difficultyScale);
            } else {
                Tools.error(player, "Please select a living entity!");
            }
        }
        return true;
    }
}

