/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.resources.SimpleResource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ScreenshotEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ScreenShotHelper {
    private static final Logger field_148261_a = LogManager.getLogger();
    private static final DateFormat field_74295_a = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    public static void func_148260_a(File gameDirectory, int width, int height, Framebuffer buffer, Consumer<ITextComponent> p_148260_4_) {
        ScreenShotHelper.func_148259_a(gameDirectory, null, width, height, buffer, p_148260_4_);
    }

    public static void func_148259_a(File gameDirectory, @Nullable String screenshotName, int width, int height, Framebuffer buffer, Consumer<ITextComponent> p_148259_5_) {
        NativeImage nativeimage = ScreenShotHelper.func_198052_a(width, height, buffer);
        File file1 = new File(gameDirectory, "screenshots");
        file1.mkdir();
        File target = screenshotName == null ? ScreenShotHelper.func_74290_a(file1) : new File(file1, screenshotName);
        try {
            target = target.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ScreenshotEvent event = ForgeHooksClient.onScreenshot((NativeImage)nativeimage, (File)target);
        if (event.isCanceled()) {
            p_148259_5_.accept(event.getCancelMessage());
            return;
        }
        File file2 = target = event.getScreenshotFile();
        SimpleResource.field_199031_a.execute(() -> {
            try {
                nativeimage.func_209271_a(file2);
                ITextComponent itextcomponent = new StringTextComponent(file2.getName()).func_211708_a(TextFormatting.UNDERLINE).func_211710_a(p_212451_1_ -> p_212451_1_.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, file2.getAbsolutePath())));
                if (event.getResultMessage() != null) {
                    p_148259_5_.accept(event.getResultMessage());
                } else {
                    p_148259_5_.accept((ITextComponent)new TranslationTextComponent("screenshot.success", itextcomponent));
                }
            }
            catch (Exception exception) {
                field_148261_a.warn("Couldn't save screenshot", (Throwable)exception);
                p_148259_5_.accept((ITextComponent)new TranslationTextComponent("screenshot.failure", exception.getMessage()));
            }
            finally {
                nativeimage.close();
            }
        });
    }

    public static NativeImage func_198052_a(int width, int height, Framebuffer framebufferIn) {
        if (GLX.isUsingFBOs()) {
            width = framebufferIn.field_147622_a;
            height = framebufferIn.field_147620_b;
        }
        NativeImage nativeimage = new NativeImage(width, height, false);
        if (GLX.isUsingFBOs()) {
            GlStateManager.bindTexture((int)framebufferIn.field_147617_g);
            nativeimage.func_195717_a(0, true);
        } else {
            nativeimage.func_195701_a(true);
        }
        nativeimage.func_195710_e();
        return nativeimage;
    }

    private static File func_74290_a(File gameDirectory) {
        String s = field_74295_a.format(new Date());
        int i = 1;
        File file1;
        while ((file1 = new File(gameDirectory, s + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }
}

