/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive.horse;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class AbstractHorseEntity
extends AnimalEntity
implements IInventoryChangedListener,
IJumpingMount {
    private static final Predicate<LivingEntity> field_110276_bu = p_213617_0_ -> p_213617_0_ instanceof AbstractHorseEntity && ((AbstractHorseEntity)((Object)((Object)p_213617_0_))).func_110205_ce();
    private static final EntityPredicate field_213618_bK = new EntityPredicate().func_221013_a(16.0).func_221008_a().func_221011_b().func_221014_c().func_221012_a(field_110276_bu);
    protected static final IAttribute field_110271_bv = new RangedAttribute((IAttribute)null, "horse.jumpStrength", 0.7, 0.0, 2.0).func_111117_a("Jump Strength").func_111112_a(true);
    private static final DataParameter<Byte> field_184787_bE = EntityDataManager.func_187226_a(AbstractHorseEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Optional<UUID>> field_184790_bH = EntityDataManager.func_187226_a(AbstractHorseEntity.class, DataSerializers.field_187203_m);
    private int field_190689_bJ;
    private int field_110290_bE;
    private int field_110295_bF;
    public int field_110278_bp;
    public int field_110279_bq;
    protected boolean field_110275_br;
    protected Inventory field_110296_bG;
    protected int field_110274_bs;
    protected float field_110277_bt;
    private boolean field_110294_bI;
    private float field_110283_bJ;
    private float field_110284_bK;
    private float field_110281_bL;
    private float field_110282_bM;
    private float field_110287_bN;
    private float field_110288_bO;
    protected boolean field_190688_bE = true;
    protected int field_110285_bP;
    private LazyOptional<?> itemHandler = null;

    protected AbstractHorseEntity(EntityType<? extends AbstractHorseEntity> type, World p_i48563_2_) {
        super(type, p_i48563_2_);
        this.field_70138_W = 1.0f;
        this.func_110226_cD();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new RunAroundLikeCrazyGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal(this, 1.0, AbstractHorseEntity.class));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
        this.func_205714_dM();
    }

    protected void func_205714_dM() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)((Object)this)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184787_bE, (byte)0);
        this.field_70180_af.func_187214_a(field_184790_bH, Optional.empty());
    }

    protected boolean func_110233_w(int p_110233_1_) {
        return (this.field_70180_af.func_187225_a(field_184787_bE) & p_110233_1_) != 0;
    }

    protected void func_110208_b(int p_110208_1_, boolean p_110208_2_) {
        byte b0 = this.field_70180_af.func_187225_a(field_184787_bE);
        if (p_110208_2_) {
            this.field_70180_af.func_187227_b(field_184787_bE, (byte)(b0 | p_110208_1_));
        } else {
            this.field_70180_af.func_187227_b(field_184787_bE, (byte)(b0 & ~p_110208_1_));
        }
    }

    public boolean func_110248_bS() {
        return this.func_110233_w(2);
    }

    @Nullable
    public UUID func_184780_dh() {
        return this.field_70180_af.func_187225_a(field_184790_bH).orElse(null);
    }

    public void func_184779_b(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(field_184790_bH, Optional.ofNullable(uniqueId));
    }

    public boolean func_110246_bZ() {
        return this.field_110275_br;
    }

    public void func_110234_j(boolean tamed) {
        this.func_110208_b(2, tamed);
    }

    public void func_110255_k(boolean jumping) {
        this.field_110275_br = jumping;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return super.func_184652_a(player) && this.func_70668_bt() != CreatureAttribute.field_223223_b_;
    }

    protected void func_142017_o(float p_142017_1_) {
        if (p_142017_1_ > 6.0f && this.func_110204_cc()) {
            this.func_110227_p(false);
        }
    }

    public boolean func_110204_cc() {
        return this.func_110233_w(16);
    }

    public boolean func_110209_cd() {
        return this.func_110233_w(32);
    }

    public boolean func_110205_ce() {
        return this.func_110233_w(8);
    }

    public void func_110242_l(boolean breeding) {
        this.func_110208_b(8, breeding);
    }

    public void func_110251_o(boolean saddled) {
        this.func_110208_b(4, saddled);
    }

    public int func_110252_cg() {
        return this.field_110274_bs;
    }

    public void func_110238_s(int temperIn) {
        this.field_110274_bs = temperIn;
    }

    public int func_110198_t(int p_110198_1_) {
        int i = MathHelper.func_76125_a((int)(this.func_110252_cg() + p_110198_1_), (int)0, (int)this.func_190676_dC());
        this.func_110238_s(i);
        return i;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        return this.func_184207_aI() && entity != null && this.func_184215_y(entity) ? false : super.func_70097_a(source, amount);
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    private void func_110266_cB() {
        this.func_110249_cI();
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187711_cp, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int i;
        if (distance > 1.0f) {
            this.func_184185_a(SoundEvents.field_187723_ct, 0.4f, 1.0f);
        }
        if ((i = MathHelper.func_76123_f((float)((distance * 0.5f - 3.0f) * damageMultiplier))) > 0) {
            BlockPos pos;
            BlockState blockstate;
            this.func_70097_a(DamageSource.field_76379_h, i);
            if (this.func_184207_aI()) {
                for (Entity entity : this.func_184182_bu()) {
                    entity.func_70097_a(DamageSource.field_76379_h, i);
                }
            }
            if (!(blockstate = this.field_70170_p.func_180495_p(pos = new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v))).func_196958_f() && !this.func_174814_R()) {
                SoundType soundtype = blockstate.getSoundType(this.field_70170_p, pos, (Entity)((Object)this));
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundtype.func_185844_d(), this.func_184176_by(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    protected int func_190686_di() {
        return 2;
    }

    protected void func_110226_cD() {
        Inventory inventory = this.field_110296_bG;
        this.field_110296_bG = new Inventory(this.func_190686_di());
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inventory.func_70302_i_(), this.field_110296_bG.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.field_110296_bG.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.field_110296_bG.func_110134_a((IInventoryChangedListener)this);
        this.func_110232_cE();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.field_110296_bG));
    }

    protected void func_110232_cE() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110251_o(!this.field_110296_bG.func_70301_a(0).func_190926_b() && this.func_190685_dA());
        }
    }

    public void func_76316_a(IInventory invBasic) {
        boolean flag = this.func_110257_ck();
        this.func_110232_cE();
        if (this.field_70173_aa > 20 && !flag && this.func_110257_ck()) {
            this.func_184185_a(SoundEvents.field_187726_cu, 0.5f, 1.0f);
        }
    }

    public double func_110215_cj() {
        return this.func_110148_a(field_110271_bv).func_111126_e();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.func_110220_cK();
        }
        return null;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(10) == 0 && !this.func_70610_aX()) {
            this.func_110220_cK();
        }
        return null;
    }

    public boolean func_190685_dA() {
        return true;
    }

    public boolean func_110257_ck() {
        return this.func_110233_w(4);
    }

    @Nullable
    protected SoundEvent func_184785_dv() {
        this.func_110220_cK();
        return null;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        if (!blockIn.func_185904_a().func_76224_d()) {
            BlockState blockstate = this.field_70170_p.func_180495_p(pos.func_177984_a());
            SoundType soundtype = blockIn.getSoundType(this.field_70170_p, pos, (Entity)((Object)this));
            if (blockstate.func_177230_c() == Blocks.field_150433_aE) {
                soundtype = blockstate.getSoundType(this.field_70170_p, pos, (Entity)((Object)this));
            }
            if (this.func_184207_aI() && this.field_190688_bE) {
                ++this.field_110285_bP;
                if (this.field_110285_bP > 5 && this.field_110285_bP % 3 == 0) {
                    this.func_190680_a(soundtype);
                } else if (this.field_110285_bP <= 5) {
                    this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
                }
            } else if (soundtype == SoundType.field_185848_a) {
                this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            } else {
                this.func_184185_a(SoundEvents.field_187729_cv, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            }
        }
    }

    protected void func_190680_a(SoundType p_190680_1_) {
        this.func_184185_a(SoundEvents.field_187714_cq, p_190680_1_.func_185843_a() * 0.15f, p_190680_1_.func_185847_b());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(field_110271_bv);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(53.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.225f);
    }

    public int func_70641_bl() {
        return 6;
    }

    public int func_190676_dC() {
        return 100;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public int func_70627_aG() {
        return 400;
    }

    public void func_110199_f(PlayerEntity playerEntity) {
        if (!this.field_70170_p.field_72995_K && (!this.func_184207_aI() || this.func_184196_w(playerEntity)) && this.func_110248_bS()) {
            playerEntity.func_184826_a(this, (IInventory)this.field_110296_bG);
        }
    }

    protected boolean func_190678_b(PlayerEntity player, ItemStack stack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        int j = 0;
        Item item = stack.func_77973_b();
        if (item == Items.field_151015_O) {
            f = 2.0f;
            i = 20;
            j = 3;
        } else if (item == Items.field_151102_aT) {
            f = 1.0f;
            i = 30;
            j = 3;
        } else if (item == Blocks.field_150407_cf.func_199767_j()) {
            f = 20.0f;
            i = 180;
        } else if (item == Items.field_151034_e) {
            f = 3.0f;
            i = 60;
            j = 3;
        } else if (item == Items.field_151150_bK) {
            f = 4.0f;
            i = 60;
            j = 5;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        } else if (item == Items.field_151153_ao || item == Items.field_196100_at) {
            f = 10.0f;
            i = 240;
            j = 10;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
            this.func_70691_i(f);
            flag = true;
        }
        if (this.func_70631_g_() && i > 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(i);
            }
            flag = true;
        }
        if (j > 0 && (flag || !this.func_110248_bS()) && this.func_110252_cg() < this.func_190676_dC()) {
            flag = true;
            if (!this.field_70170_p.field_72995_K) {
                this.func_110198_t(j);
            }
        }
        if (flag) {
            this.func_110266_cB();
        }
        return flag;
    }

    protected void func_110237_h(PlayerEntity player) {
        this.func_110227_p(false);
        this.func_110219_q(false);
        if (!this.field_70170_p.field_72995_K) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            player.func_184220_m((Entity)((Object)this));
        }
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() && this.func_110257_ck() || this.func_110204_cc() || this.func_110209_cd();
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    private void func_110210_cH() {
        this.field_110278_bp = 1;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.field_110296_bG != null) {
            for (int i = 0; i < this.field_110296_bG.func_70302_i_(); ++i) {
                ItemStack itemstack = this.field_110296_bG.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_199701_a_(itemstack);
            }
        }
    }

    public void func_70636_d() {
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.func_110210_cH();
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
            if (this.func_190684_dE()) {
                if (!this.func_110204_cc() && !this.func_184207_aI() && this.field_70146_Z.nextInt(300) == 0 && this.field_70170_p.func_180495_p(new BlockPos((Entity)((Object)this)).func_177977_b()).func_177230_c() == Blocks.field_196658_i) {
                    this.func_110227_p(true);
                }
                if (this.func_110204_cc() && ++this.field_190689_bJ > 50) {
                    this.field_190689_bJ = 0;
                    this.func_110227_p(false);
                }
            }
            this.func_190679_dD();
        }
    }

    protected void func_190679_dD() {
        LivingEntity livingentity;
        if (this.func_110205_ce() && this.func_70631_g_() && !this.func_110204_cc() && (livingentity = this.field_70170_p.func_217360_a(AbstractHorseEntity.class, field_213618_bK, (LivingEntity)((Object)this), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_174813_aQ().func_186662_g(16.0))) != null && this.func_70068_e(livingentity) > 4.0) {
            this.field_70699_by.func_75494_a(livingentity, 0);
        }
    }

    public boolean func_190684_dE() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_110290_bE > 0 && ++this.field_110290_bE > 30) {
            this.field_110290_bE = 0;
            this.func_110208_b(64, false);
        }
        if ((this.func_184186_bw() || this.func_70613_aW()) && this.field_110295_bF > 0 && ++this.field_110295_bF > 20) {
            this.field_110295_bF = 0;
            this.func_110219_q(false);
        }
        if (this.field_110278_bp > 0 && ++this.field_110278_bp > 8) {
            this.field_110278_bp = 0;
        }
        if (this.field_110279_bq > 0) {
            ++this.field_110279_bq;
            if (this.field_110279_bq > 300) {
                this.field_110279_bq = 0;
            }
        }
        this.field_110284_bK = this.field_110283_bJ;
        if (this.func_110204_cc()) {
            this.field_110283_bJ += (1.0f - this.field_110283_bJ) * 0.4f + 0.05f;
            if (this.field_110283_bJ > 1.0f) {
                this.field_110283_bJ = 1.0f;
            }
        } else {
            this.field_110283_bJ += (0.0f - this.field_110283_bJ) * 0.4f - 0.05f;
            if (this.field_110283_bJ < 0.0f) {
                this.field_110283_bJ = 0.0f;
            }
        }
        this.field_110282_bM = this.field_110281_bL;
        if (this.func_110209_cd()) {
            this.field_110284_bK = this.field_110283_bJ = 0.0f;
            this.field_110281_bL += (1.0f - this.field_110281_bL) * 0.4f + 0.05f;
            if (this.field_110281_bL > 1.0f) {
                this.field_110281_bL = 1.0f;
            }
        } else {
            this.field_110294_bI = false;
            this.field_110281_bL += (0.8f * this.field_110281_bL * this.field_110281_bL * this.field_110281_bL - this.field_110281_bL) * 0.6f - 0.05f;
            if (this.field_110281_bL < 0.0f) {
                this.field_110281_bL = 0.0f;
            }
        }
        this.field_110288_bO = this.field_110287_bN;
        if (this.func_110233_w(64)) {
            this.field_110287_bN += (1.0f - this.field_110287_bN) * 0.7f + 0.05f;
            if (this.field_110287_bN > 1.0f) {
                this.field_110287_bN = 1.0f;
            }
        } else {
            this.field_110287_bN += (0.0f - this.field_110287_bN) * 0.7f - 0.05f;
            if (this.field_110287_bN < 0.0f) {
                this.field_110287_bN = 0.0f;
            }
        }
    }

    private void func_110249_cI() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_110290_bE = 1;
            this.func_110208_b(64, true);
        }
    }

    public void func_110227_p(boolean p_110227_1_) {
        this.func_110208_b(16, p_110227_1_);
    }

    public void func_110219_q(boolean rearing) {
        if (rearing) {
            this.func_110227_p(false);
        }
        this.func_110208_b(32, rearing);
    }

    private void func_110220_cK() {
        if (this.func_184186_bw() || this.func_70613_aW()) {
            this.field_110295_bF = 1;
            this.func_110219_q(true);
        }
    }

    public void func_190687_dF() {
        this.func_110220_cK();
        SoundEvent soundevent = this.func_184785_dv();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public boolean func_110263_g(PlayerEntity player) {
        this.func_184779_b(player.func_110124_au());
        this.func_110234_j(true);
        if (player instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193136_w.func_193178_a((ServerPlayerEntity)player, (AnimalEntity)this);
        }
        this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)7);
        return true;
    }

    public void func_213352_e(Vec3d p_213352_1_) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.func_110257_ck()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                    this.field_110285_bP = 0;
                }
                if (this.field_70122_E && this.field_110277_bt == 0.0f && this.func_110209_cd() && !this.field_110294_bI) {
                    f = 0.0f;
                    f1 = 0.0f;
                }
                if (this.field_110277_bt > 0.0f && !this.func_110246_bZ() && this.field_70122_E) {
                    double d0 = this.func_110215_cj() * (double)this.field_110277_bt;
                    double d1 = this.func_70644_a(Effects.field_76430_j) ? d0 + (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f) : d0;
                    Vec3d vec3d = this.func_213322_ci();
                    this.func_213293_j(vec3d.field_72450_a, d1, vec3d.field_72449_c);
                    this.func_110255_k(true);
                    this.field_70160_al = true;
                    if (f1 > 0.0f) {
                        float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        this.func_213317_d(this.func_213322_ci().func_72441_c(-0.4f * f2 * this.field_110277_bt, 0.0, 0.4f * f3 * this.field_110277_bt));
                        this.func_205715_ee();
                    }
                    this.field_110277_bt = 0.0f;
                }
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    super.func_213352_e(new Vec3d(f, p_213352_1_.field_72448_b, f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vec3d.field_186680_a);
                }
                if (this.field_70122_E) {
                    this.field_110277_bt = 0.0f;
                    this.func_110255_k(false);
                }
                this.field_184618_aE = this.field_70721_aZ;
                double d2 = this.field_70165_t - this.field_70169_q;
                double d3 = this.field_70161_v - this.field_70166_s;
                float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d3 * d3)) * 4.0f;
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70747_aH = 0.02f;
                super.func_213352_e(p_213352_1_);
            }
        }
    }

    protected void func_205715_ee() {
        this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("EatingHaystack", this.func_110204_cc());
        compound.func_74757_a("Bred", this.func_110205_ce());
        compound.func_74768_a("Temper", this.func_110252_cg());
        compound.func_74757_a("Tame", this.func_110248_bS());
        if (this.func_184780_dh() != null) {
            compound.func_74778_a("OwnerUUID", this.func_184780_dh().toString());
        }
        if (!this.field_110296_bG.func_70301_a(0).func_190926_b()) {
            compound.func_218657_a("SaddleItem", this.field_110296_bG.func_70301_a(0).func_77955_b(new CompoundNBT()));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        ItemStack itemstack;
        IAttributeInstance iattributeinstance;
        String s;
        super.func_70037_a(compound);
        this.func_110227_p(compound.func_74767_n("EatingHaystack"));
        this.func_110242_l(compound.func_74767_n("Bred"));
        this.func_110238_s(compound.func_74762_e("Temper"));
        this.func_110234_j(compound.func_74767_n("Tame"));
        if (compound.func_150297_b("OwnerUUID", 8)) {
            s = compound.func_74779_i("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            this.func_184779_b(UUID.fromString(s));
        }
        if ((iattributeinstance = this.func_110140_aT().func_111152_a("Speed")) != null) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(iattributeinstance.func_111125_b() * 0.25);
        }
        if (compound.func_150297_b("SaddleItem", 10) && (itemstack = ItemStack.func_199557_a(compound.func_74775_l("SaddleItem"))).func_77973_b() == Items.field_151141_av) {
            this.field_110296_bG.func_70299_a(0, itemstack);
        }
        this.func_110232_cE();
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return false;
    }

    protected boolean func_110200_cJ() {
        return !this.func_184207_aI() && !this.func_184218_aH() && this.func_110248_bS() && !this.func_70631_g_() && this.func_110143_aJ() >= this.func_110138_aP() && this.func_70880_s();
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    protected void func_190681_a(AgeableEntity p_190681_1_, AbstractHorseEntity p_190681_2_) {
        double d0 = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + p_190681_1_.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + (double)this.func_110267_cL();
        p_190681_2_.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(d0 / 3.0);
        double d1 = this.func_110148_a(field_110271_bv).func_111125_b() + p_190681_1_.func_110148_a(field_110271_bv).func_111125_b() + this.func_110245_cM();
        p_190681_2_.func_110148_a(field_110271_bv).func_111128_a(d1 / 3.0);
        double d2 = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + p_190681_1_.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.func_110203_cN();
        p_190681_2_.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(d2 / 3.0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_110258_o(float p_110258_1_) {
        return MathHelper.func_219799_g((float)p_110258_1_, (float)this.field_110284_bK, (float)this.field_110283_bJ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_110223_p(float p_110223_1_) {
        return MathHelper.func_219799_g((float)p_110223_1_, (float)this.field_110282_bM, (float)this.field_110281_bL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_110201_q(float p_110201_1_) {
        return MathHelper.func_219799_g((float)p_110201_1_, (float)this.field_110288_bO, (float)this.field_110287_bN);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_110206_u(int jumpPowerIn) {
        if (this.func_110257_ck()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            } else {
                this.field_110294_bI = true;
                this.func_110220_cK();
            }
            this.field_110277_bt = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return this.func_110257_ck();
    }

    public void func_184775_b(int p_184775_1_) {
        this.field_110294_bI = true;
        this.func_110220_cK();
    }

    public void func_184777_r_() {
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void func_110216_r(boolean p_110216_1_) {
        BasicParticleType iparticledata = p_110216_1_ ? ParticleTypes.field_197633_z : ParticleTypes.field_197601_L;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)iparticledata, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 7) {
            this.func_110216_r(true);
        } else if (id == 6) {
            this.func_110216_r(false);
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof MobEntity) {
            MobEntity mobentity = (MobEntity)passenger;
            this.field_70761_aq = mobentity.field_70761_aq;
        }
        if (this.field_110282_bM > 0.0f) {
            float f3 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f1 = 0.7f * this.field_110282_bM;
            float f2 = 0.15f * this.field_110282_bM;
            passenger.func_70107_b(this.field_70165_t + (double)(f1 * f3), this.field_70163_u + this.func_70042_X() + passenger.func_70033_W() + (double)f2, this.field_70161_v - (double)(f1 * f));
            if (passenger instanceof LivingEntity) {
                ((LivingEntity)passenger).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    protected float func_110267_cL() {
        return 15.0f + (float)this.field_70146_Z.nextInt(8) + (float)this.field_70146_Z.nextInt(9);
    }

    protected double func_110245_cM() {
        return (double)0.4f + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2;
    }

    protected double func_110203_cN() {
        return ((double)0.45f + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3) * 0.25;
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.95f;
    }

    public boolean func_190677_dK() {
        return false;
    }

    public boolean func_190682_f(ItemStack stack) {
        return false;
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        int i = inventorySlot - 400;
        if (i >= 0 && i < 2 && i < this.field_110296_bG.func_70302_i_()) {
            if (i == 0 && itemStackIn.func_77973_b() != Items.field_151141_av) {
                return false;
            }
            if (i != 1 || this.func_190677_dK() && this.func_190682_f(itemStackIn)) {
                this.field_110296_bG.func_70299_a(i, itemStackIn);
                this.func_110232_cE();
                return true;
            }
            return false;
        }
        int j = inventorySlot - 500 + 2;
        if (j >= 2 && j < this.field_110296_bG.func_70302_i_()) {
            this.field_110296_bG.func_70299_a(j, itemStackIn);
            return true;
        }
        return false;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)((Object)this.func_184188_bt().get(0));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70873_a(-24000);
        }
        return spawnDataIn;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!keepData && this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }
}

