/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.StitcherException;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.client.ClientHooks;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class AtlasTexture
extends Texture
implements ITickableTextureObject {
    private static final Logger field_147635_d = LogManager.getLogger();
    public static final ResourceLocation field_110575_b = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation field_215262_g = new ResourceLocation("textures/atlas/particles.png");
    public static final ResourceLocation field_215263_h = new ResourceLocation("textures/atlas/paintings.png");
    public static final ResourceLocation field_215264_i = new ResourceLocation("textures/atlas/mob_effects.png");
    private final List<TextureAtlasSprite> field_94258_i = Lists.newArrayList();
    private final Set<ResourceLocation> field_195427_i = Sets.newHashSet();
    private final Map<ResourceLocation, TextureAtlasSprite> field_94252_e = Maps.newHashMap();
    private final String field_94254_c;
    private final int field_215265_o;
    private int field_147636_j;
    private final TextureAtlasSprite field_94249_f = MissingTextureSprite.func_217790_a();
    private final Deque<ResourceLocation> loadingSprites = new ArrayDeque<ResourceLocation>();
    private final Set<ResourceLocation> loadedSprites = new HashSet<ResourceLocation>();

    public AtlasTexture(String basePathIn) {
        this.field_94254_c = basePathIn;
        this.field_215265_o = Minecraft.func_71369_N();
    }

    public void func_195413_a(IResourceManager manager) throws IOException {
    }

    public void func_215260_a(SheetData p_215260_1_) {
        this.field_195427_i.clear();
        this.field_195427_i.addAll(p_215260_1_.field_217805_a);
        field_147635_d.info("Created: {}x{} {}-atlas", (Object)p_215260_1_.field_217806_b, (Object)p_215260_1_.field_217807_c, (Object)this.field_94254_c);
        TextureUtil.prepareImage((int)this.func_110552_b(), (int)this.field_147636_j, (int)p_215260_1_.field_217806_b, (int)p_215260_1_.field_217807_c);
        this.func_195419_g();
        for (TextureAtlasSprite textureatlassprite : p_215260_1_.field_217808_d) {
            this.field_94252_e.put(textureatlassprite.func_195668_m(), textureatlassprite);
            try {
                textureatlassprite.func_195663_q();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Stitching texture atlas");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Texture being stitched together");
                crashreportcategory.func_71507_a("Atlas path", this.field_94254_c);
                crashreportcategory.func_71507_a("Sprite", textureatlassprite);
                throw new ReportedException(crashreport);
            }
            if (!textureatlassprite.func_130098_m()) continue;
            this.field_94258_i.add(textureatlassprite);
        }
        ForgeHooksClient.onTextureStitchedPost((AtlasTexture)this);
    }

    public SheetData func_215254_a(IResourceManager p_215254_1_, Iterable<ResourceLocation> p_215254_2_, IProfiler p_215254_3_) {
        HashSet set = Sets.newHashSet();
        p_215254_3_.func_76320_a("preparing");
        p_215254_2_.forEach(p_215253_1_ -> {
            if (p_215253_1_ == null) {
                throw new IllegalArgumentException("Location cannot be null!");
            }
            set.add(p_215253_1_);
        });
        ForgeHooksClient.onTextureStitchedPre((AtlasTexture)this, (Set)set);
        int i = this.field_215265_o;
        Stitcher stitcher = new Stitcher(i, i, this.field_147636_j);
        int j = Integer.MAX_VALUE;
        int k = 1 << this.field_147636_j;
        p_215254_3_.func_219895_b("extracting_frames");
        for (TextureAtlasSprite textureatlassprite : this.func_215256_a(p_215254_1_, set)) {
            j = Math.min(j, Math.min(textureatlassprite.func_94211_a(), textureatlassprite.func_94216_b()));
            int l = Math.min(Integer.lowestOneBit(textureatlassprite.func_94211_a()), Integer.lowestOneBit(textureatlassprite.func_94216_b()));
            if (l < k) {
                field_147635_d.warn("Texture {} with size {}x{} limits mip level from {} to {}", (Object)textureatlassprite.func_195668_m(), (Object)textureatlassprite.func_94211_a(), (Object)textureatlassprite.func_94216_b(), (Object)MathHelper.func_151239_c((int)k), (Object)MathHelper.func_151239_c((int)l));
                k = l;
            }
            stitcher.func_110934_a(textureatlassprite);
        }
        int i1 = Math.min(j, k);
        int j1 = MathHelper.func_151239_c((int)i1);
        p_215254_3_.func_219895_b("mipmapping");
        this.field_94249_f.func_147963_d(this.field_147636_j);
        p_215254_3_.func_219895_b("register");
        stitcher.func_110934_a(this.field_94249_f);
        p_215254_3_.func_219895_b("stitching");
        try {
            stitcher.func_94305_f();
        }
        catch (StitcherException stitcherexception) {
            CrashReport crashreport = CrashReport.func_85055_a(stitcherexception, "Stitching");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Stitcher");
            crashreportcategory.func_71507_a("Sprites", stitcherexception.func_225331_a().stream().map(p_224739_0_ -> String.format("%s[%dx%d]", p_224739_0_.func_195668_m(), p_224739_0_.func_94211_a(), p_224739_0_.func_94216_b())).collect(Collectors.joining(",")));
            crashreportcategory.func_71507_a("Max Texture Size", i);
            throw new ReportedException(crashreport);
        }
        p_215254_3_.func_219895_b("loading");
        List<TextureAtlasSprite> list = this.func_215259_a(p_215254_1_, stitcher);
        p_215254_3_.func_76319_b();
        return new SheetData(set, stitcher.func_110935_a(), stitcher.func_110936_b(), list);
    }

    private Collection<TextureAtlasSprite> func_215256_a(IResourceManager p_215256_1_, Set<ResourceLocation> p_215256_2_) {
        ArrayList<CompletableFuture<Void>> list = new ArrayList<CompletableFuture<Void>>();
        ConcurrentLinkedQueue<TextureAtlasSprite> concurrentlinkedqueue = new ConcurrentLinkedQueue<TextureAtlasSprite>();
        for (ResourceLocation resourcelocation : p_215256_2_) {
            if (this.field_94249_f.func_195668_m().equals((Object)resourcelocation)) continue;
            list.add(CompletableFuture.runAsync(() -> {
                TextureAtlasSprite textureatlassprite;
                ResourceLocation resourcelocation1 = this.func_195420_b(resourcelocation);
                try (IResource iresource = p_215256_1_.func_199002_a(resourcelocation1);){
                    PngSizeInfo pngsizeinfo = new PngSizeInfo(iresource.toString(), iresource.func_199027_b());
                    AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
                    textureatlassprite = new TextureAtlasSprite(resourcelocation, pngsizeinfo, animationmetadatasection);
                }
                catch (RuntimeException runtimeexception) {
                    field_147635_d.error("Unable to parse metadata from {} : {}", (Object)resourcelocation1, (Object)runtimeexception);
                    return;
                }
                catch (IOException ioexception) {
                    field_147635_d.error("Using missing texture, unable to load {} : {}", (Object)resourcelocation1, (Object)ioexception);
                    return;
                }
                concurrentlinkedqueue.add(textureatlassprite);
            }, Util.func_215072_e()));
        }
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return concurrentlinkedqueue;
    }

    private List<TextureAtlasSprite> func_215259_a(IResourceManager p_215259_1_, Stitcher p_215259_2_) {
        ConcurrentLinkedQueue<TextureAtlasSprite> concurrentlinkedqueue = new ConcurrentLinkedQueue<TextureAtlasSprite>();
        ArrayList<CompletableFuture<Void>> list = new ArrayList<CompletableFuture<Void>>();
        for (TextureAtlasSprite textureatlassprite : p_215259_2_.func_94309_g()) {
            if (textureatlassprite == this.field_94249_f) {
                concurrentlinkedqueue.add(textureatlassprite);
                continue;
            }
            list.add(CompletableFuture.runAsync(() -> {
                if (this.func_195422_a(p_215259_1_, textureatlassprite)) {
                    concurrentlinkedqueue.add(textureatlassprite);
                }
            }, Util.func_215072_e()));
        }
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return new ArrayList<TextureAtlasSprite>(concurrentlinkedqueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean func_195422_a(IResourceManager manager, TextureAtlasSprite sprite) {
        block10: {
            ResourceLocation resourcelocation = this.func_195420_b(sprite.func_195668_m());
            IResource iresource = null;
            if (!sprite.hasCustomLoader(manager, resourcelocation)) {
                boolean flag;
                try {
                    iresource = manager.func_199002_a(resourcelocation);
                    sprite.func_195664_a(iresource, this.field_147636_j + 1);
                    break block10;
                }
                catch (RuntimeException runtimeexception) {
                    field_147635_d.error("Unable to parse metadata from {}", (Object)resourcelocation, (Object)runtimeexception);
                    flag = false;
                }
                catch (IOException ioexception) {
                    boolean flag2;
                    field_147635_d.error("Using missing texture, unable to load {}", (Object)resourcelocation, (Object)ioexception);
                    boolean bl = flag2 = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Closeable)iresource);
                }
                return flag;
            }
        }
        try {
            sprite.func_147963_d(this.field_147636_j);
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Applying mipmap");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Sprite being mipmapped");
            crashreportcategory.func_189529_a("Sprite name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> sprite.func_195668_m().toString()));
            crashreportcategory.func_189529_a("Sprite size", (ICrashReportDetail<String>)((ICrashReportDetail)() -> sprite.func_94211_a() + " x " + sprite.func_94216_b()));
            crashreportcategory.func_189529_a("Sprite frames", (ICrashReportDetail<String>)((ICrashReportDetail)() -> sprite.func_110970_k() + " frames"));
            crashreportcategory.func_71507_a("Mipmap levels", this.field_147636_j);
            throw new ReportedException(crashreport);
        }
    }

    private ResourceLocation func_195420_b(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), String.format("%s/%s%s", this.field_94254_c, location.func_110623_a(), ".png"));
    }

    public TextureAtlasSprite func_110572_b(String iconName) {
        return this.func_195424_a(new ResourceLocation(iconName));
    }

    public void func_94248_c() {
        this.func_195412_h();
        for (TextureAtlasSprite textureatlassprite : this.field_94258_i) {
            textureatlassprite.func_94219_l();
        }
    }

    public void func_110550_d() {
        this.func_94248_c();
    }

    public void func_147633_a(int mipmapLevelsIn) {
        this.field_147636_j = mipmapLevelsIn;
    }

    public TextureAtlasSprite func_195424_a(ResourceLocation location) {
        TextureAtlasSprite textureatlassprite = this.field_94252_e.get(location);
        return textureatlassprite == null ? this.field_94249_f : textureatlassprite;
    }

    public void func_195419_g() {
        for (TextureAtlasSprite textureatlassprite : this.field_94252_e.values()) {
            textureatlassprite.func_130103_l();
        }
        this.field_94252_e.clear();
        this.field_94258_i.clear();
    }

    public String getBasePath() {
        return this.field_94254_c;
    }

    public int getMipmapLevels() {
        return this.field_147636_j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int loadTexture(Stitcher stitcher, IResourceManager manager, ResourceLocation resourcelocation, int j, int k) {
        if (this.loadedSprites.contains(resourcelocation)) {
            return j;
        }
        ResourceLocation resourcelocation1 = this.func_195420_b(resourcelocation);
        for (ResourceLocation loading : this.loadingSprites) {
            if (!resourcelocation1.equals((Object)loading)) continue;
            String error = "circular model dependencies, stack: [" + Joiner.on((String)", ").join(this.loadingSprites) + "]";
            ClientHooks.trackBrokenTexture((ResourceLocation)resourcelocation, (String)error);
        }
        this.loadingSprites.addLast(resourcelocation1);
        try {
            int n;
            Throwable throwable;
            IResource iresource;
            block32: {
                block33: {
                    TextureAtlasSprite textureatlassprite;
                    block29: {
                        int n2;
                        block30: {
                            block31: {
                                iresource = manager.func_199002_a(resourcelocation1);
                                throwable = null;
                                PngSizeInfo pngsizeinfo = new PngSizeInfo(iresource.toString(), iresource.func_199027_b());
                                AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
                                textureatlassprite = new TextureAtlasSprite(resourcelocation, pngsizeinfo, animationmetadatasection);
                                for (ResourceLocation dependency : textureatlassprite.getDependencies()) {
                                    if (!this.field_195427_i.contains(dependency)) {
                                        this.field_195427_i.add(dependency);
                                    }
                                    j = this.loadTexture(stitcher, manager, dependency, j, k);
                                }
                                if (!textureatlassprite.hasCustomLoader(manager, resourcelocation)) break block29;
                                if (!textureatlassprite.load(manager, resourcelocation, this.field_94252_e::get)) break block29;
                                n2 = j;
                                if (iresource == null) break block30;
                                if (throwable == null) break block31;
                                try {
                                    iresource.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block30;
                            }
                            iresource.close();
                        }
                        return n2;
                    }
                    j = Math.min(j, Math.min(textureatlassprite.func_94211_a(), textureatlassprite.func_94216_b()));
                    int j1 = Math.min(Integer.lowestOneBit(textureatlassprite.func_94211_a()), Integer.lowestOneBit(textureatlassprite.func_94216_b()));
                    if (j1 < k) {
                        field_147635_d.warn("Texture {} with size {}x{} will have visual artifacts at mip level {}, it can only support level {}.Please report to the mod author that the texture should be some multiple of 16x16.", (Object)resourcelocation1, (Object)textureatlassprite.func_94211_a(), (Object)textureatlassprite.func_94216_b(), (Object)MathHelper.func_151239_c((int)k), (Object)MathHelper.func_151239_c((int)j1));
                    }
                    if (this.func_195422_a(manager, textureatlassprite)) {
                        stitcher.func_110934_a(textureatlassprite);
                    }
                    n = j;
                    if (iresource == null) break block32;
                    if (throwable == null) break block33;
                    try {
                        iresource.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block32;
                }
                iresource.close();
            }
            return n;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (iresource != null) {
                            if (throwable != null) {
                                try {
                                    iresource.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                iresource.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (RuntimeException runtimeexception) {
                    ClientHooks.trackBrokenTexture((ResourceLocation)resourcelocation, (String)runtimeexception.getMessage());
                    int n3 = j;
                    return n3;
                }
                catch (IOException ioexception) {
                    ClientHooks.trackMissingTexture((ResourceLocation)resourcelocation);
                    int n4 = j;
                    return n4;
                }
            }
        }
        finally {
            this.loadingSprites.removeLast();
            this.field_195427_i.add(resourcelocation1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SheetData {
        final Set<ResourceLocation> field_217805_a;
        final int field_217806_b;
        final int field_217807_c;
        final List<TextureAtlasSprite> field_217808_d;

        public SheetData(Set<ResourceLocation> p_i49874_1_, int widthIn, int heightIn, List<TextureAtlasSprite> spritesIn) {
            this.field_217805_a = p_i49874_1_;
            this.field_217806_b = widthIn;
            this.field_217807_c = heightIn;
            this.field_217808_d = spritesIn;
        }
    }
}

