/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.IOException;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.SimpleResource;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class GameRenderer
implements AutoCloseable,
IResourceManagerReloadListener {
    private static final Logger field_147710_q = LogManager.getLogger();
    private static final ResourceLocation field_110924_q = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation field_110923_r = new ResourceLocation("textures/environment/snow.png");
    private final Minecraft field_78531_r;
    private final IResourceManager field_147711_ac;
    private final Random field_78537_ab = new Random();
    private float field_78530_s;
    public final FirstPersonRenderer field_78516_c;
    private final MapItemRenderer field_147709_v;
    private int field_78529_t;
    private float field_78507_R;
    private float field_78506_S;
    private float field_82831_U;
    private float field_82832_V;
    private boolean field_175074_C = true;
    private boolean field_175073_D = true;
    private long field_184374_E;
    private long field_78508_Y = Util.func_211177_b();
    private final LightTexture field_78513_d;
    private int field_78534_ac;
    private final float[] field_175076_N = new float[1024];
    private final float[] field_175077_O = new float[1024];
    private final FogRenderer field_205003_A;
    private boolean field_175078_W;
    private double field_78503_V = 1.0;
    private double field_78502_W;
    private double field_78509_X;
    private ItemStack field_190566_ab;
    private int field_190567_ac;
    private float field_190568_ad;
    private float field_190569_ae;
    private ShaderGroup field_147707_d;
    private static final ResourceLocation[] field_147712_ad = new ResourceLocation[]{new ResourceLocation("shaders/post/notch.json"), new ResourceLocation("shaders/post/fxaa.json"), new ResourceLocation("shaders/post/art.json"), new ResourceLocation("shaders/post/bumpy.json"), new ResourceLocation("shaders/post/blobs2.json"), new ResourceLocation("shaders/post/pencil.json"), new ResourceLocation("shaders/post/color_convolve.json"), new ResourceLocation("shaders/post/deconverge.json"), new ResourceLocation("shaders/post/flip.json"), new ResourceLocation("shaders/post/invert.json"), new ResourceLocation("shaders/post/ntsc.json"), new ResourceLocation("shaders/post/outline.json"), new ResourceLocation("shaders/post/phosphor.json"), new ResourceLocation("shaders/post/scan_pincushion.json"), new ResourceLocation("shaders/post/sobel.json"), new ResourceLocation("shaders/post/bits.json"), new ResourceLocation("shaders/post/desaturate.json"), new ResourceLocation("shaders/post/green.json"), new ResourceLocation("shaders/post/blur.json"), new ResourceLocation("shaders/post/wobble.json"), new ResourceLocation("shaders/post/blobs.json"), new ResourceLocation("shaders/post/antialias.json"), new ResourceLocation("shaders/post/creeper.json"), new ResourceLocation("shaders/post/spider.json")};
    public static final int field_147708_e = field_147712_ad.length;
    private int field_147713_ae = field_147708_e;
    private boolean field_175083_ad;
    private int field_175084_ae;
    private final ActiveRenderInfo field_215317_L = new ActiveRenderInfo();

    public GameRenderer(Minecraft mcIn, IResourceManager resourceManagerIn) {
        this.field_78531_r = mcIn;
        this.field_147711_ac = resourceManagerIn;
        this.field_78516_c = mcIn.func_175597_ag();
        this.field_147709_v = new MapItemRenderer(mcIn.func_110434_K());
        this.field_78513_d = new LightTexture(this);
        this.field_205003_A = new FogRenderer(this);
        this.field_147707_d = null;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.field_175076_N[i << 5 | j] = -f1 / f2;
                this.field_175077_O[i << 5 | j] = f / f2;
            }
        }
    }

    @Override
    public void close() {
        this.field_78513_d.close();
        this.field_147709_v.close();
        this.func_181022_b();
    }

    public boolean func_147702_a() {
        return GLX.usePostProcess && this.field_147707_d != null;
    }

    public void func_181022_b() {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        this.field_147713_ae = field_147708_e;
    }

    public void func_175071_c() {
        this.field_175083_ad = !this.field_175083_ad;
    }

    public void func_175066_a(@Nullable Entity entityIn) {
        if (GLX.usePostProcess) {
            if (this.field_147707_d != null) {
                this.field_147707_d.close();
            }
            this.field_147707_d = null;
            if (entityIn instanceof CreeperEntity) {
                this.func_175069_a(new ResourceLocation("shaders/post/creeper.json"));
            } else if (entityIn instanceof SpiderEntity) {
                this.func_175069_a(new ResourceLocation("shaders/post/spider.json"));
            } else if (entityIn instanceof EndermanEntity) {
                this.func_175069_a(new ResourceLocation("shaders/post/invert.json"));
            } else {
                ForgeHooksClient.loadEntityShader((Entity)entityIn, (GameRenderer)this);
            }
        }
    }

    public void func_175069_a(ResourceLocation resourceLocationIn) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        try {
            this.field_147707_d = new ShaderGroup(this.field_78531_r.func_110434_K(), this.field_147711_ac, this.field_78531_r.func_147110_a(), resourceLocationIn);
            this.field_147707_d.func_148026_a(this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l());
            this.field_175083_ad = true;
        }
        catch (IOException ioexception) {
            field_147710_q.warn("Failed to load shader: {}", (Object)resourceLocationIn, (Object)ioexception);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            field_147710_q.warn("Failed to load shader: {}", (Object)resourceLocationIn, (Object)jsonsyntaxexception);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
    }

    @Override
    public void func_195410_a(IResourceManager resourceManager) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        if (this.field_147713_ae == field_147708_e) {
            this.func_175066_a(this.field_78531_r.func_175606_aa());
        } else {
            this.func_175069_a(field_147712_ad[this.field_147713_ae]);
        }
    }

    public void func_78464_a() {
        if (GLX.usePostProcess && ShaderLinkHelper.func_148074_b() == null) {
            ShaderLinkHelper.func_148076_a();
        }
        this.func_78477_e();
        this.field_78513_d.func_205107_a();
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a(this.field_78531_r.field_71439_g);
        }
        this.field_215317_L.func_216783_a();
        ++this.field_78529_t;
        this.field_78516_c.func_78441_a();
        this.func_78484_h();
        this.field_82832_V = this.field_82831_U;
        if (this.field_78531_r.field_71456_v.func_184046_j().func_184053_e()) {
            this.field_82831_U += 0.05f;
            if (this.field_82831_U > 1.0f) {
                this.field_82831_U = 1.0f;
            }
        } else if (this.field_82831_U > 0.0f) {
            this.field_82831_U -= 0.0125f;
        }
        if (this.field_190567_ac > 0) {
            --this.field_190567_ac;
            if (this.field_190567_ac == 0) {
                this.field_190566_ab = null;
            }
        }
    }

    public ShaderGroup func_147706_e() {
        return this.field_147707_d;
    }

    public void func_147704_a(int width, int height) {
        if (GLX.usePostProcess) {
            if (this.field_147707_d != null) {
                this.field_147707_d.func_148026_a(width, height);
            }
            this.field_78531_r.field_71438_f.func_72720_a(width, height);
        }
    }

    public void func_78473_a(float partialTicks) {
        Entity entity = this.field_78531_r.func_175606_aa();
        if (entity != null && this.field_78531_r.field_71441_e != null) {
            this.field_78531_r.func_213239_aq().func_76320_a("pick");
            this.field_78531_r.field_147125_j = null;
            double d0 = this.field_78531_r.field_71442_b.func_78757_d();
            this.field_78531_r.field_71476_x = entity.func_213324_a(d0, partialTicks, false);
            Vec3d vec3d = entity.func_174824_e(partialTicks);
            boolean flag = false;
            int i = 3;
            double d1 = d0;
            if (this.field_78531_r.field_71442_b.func_78749_i()) {
                d0 = d1 = 6.0;
            } else if (d0 > 3.0) {
                flag = true;
            }
            d1 *= d1;
            if (this.field_78531_r.field_71476_x != null) {
                d1 = this.field_78531_r.field_71476_x.func_216347_e().func_72436_e(vec3d);
            }
            Vec3d vec3d1 = entity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0);
            float f = 1.0f;
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_216361_a(vec3d1.func_186678_a(d0)).func_72314_b(1.0, 1.0, 1.0);
            EntityRayTraceResult entityraytraceresult = ProjectileHelper.func_221273_a(entity, vec3d, vec3d2, axisalignedbb, p_215312_0_ -> !p_215312_0_.func_175149_v() && p_215312_0_.func_70067_L(), d1);
            if (entityraytraceresult != null) {
                Entity entity1 = entityraytraceresult.func_216348_a();
                Vec3d vec3d3 = entityraytraceresult.func_216347_e();
                double d2 = vec3d.func_72436_e(vec3d3);
                if (flag && d2 > 9.0) {
                    this.field_78531_r.field_71476_x = BlockRayTraceResult.func_216352_a((Vec3d)vec3d3, (Direction)Direction.func_210769_a(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c), (BlockPos)new BlockPos(vec3d3));
                } else if (d2 < d1 || this.field_78531_r.field_71476_x == null) {
                    this.field_78531_r.field_71476_x = entityraytraceresult;
                    if (entity1 instanceof LivingEntity || entity1 instanceof ItemFrameEntity) {
                        this.field_78531_r.field_147125_j = entity1;
                    }
                }
            }
            this.field_78531_r.func_213239_aq().func_76319_b();
        }
    }

    private void func_78477_e() {
        float f = 1.0f;
        if (this.field_78531_r.func_175606_aa() instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity abstractclientplayerentity = (AbstractClientPlayerEntity)this.field_78531_r.func_175606_aa();
            f = abstractclientplayerentity.func_175156_o();
        }
        this.field_78506_S = this.field_78507_R;
        this.field_78507_R += (f - this.field_78507_R) * 0.5f;
        if (this.field_78507_R > 1.5f) {
            this.field_78507_R = 1.5f;
        }
        if (this.field_78507_R < 0.1f) {
            this.field_78507_R = 0.1f;
        }
    }

    private double func_215311_a(ActiveRenderInfo p_215311_1_, float p_215311_2_, boolean p_215311_3_) {
        IFluidState ifluidstate;
        if (this.field_175078_W) {
            return 90.0;
        }
        double d0 = 70.0;
        if (p_215311_3_) {
            d0 = this.field_78531_r.field_71474_y.field_74334_X;
            d0 *= (double)MathHelper.func_219799_g((float)p_215311_2_, (float)this.field_78506_S, (float)this.field_78507_R);
        }
        if (p_215311_1_.func_216773_g() instanceof LivingEntity && ((LivingEntity)p_215311_1_.func_216773_g()).func_110143_aJ() <= 0.0f) {
            float f = (float)((LivingEntity)p_215311_1_.func_216773_g()).field_70725_aQ + p_215311_2_;
            d0 /= (double)((1.0f - 500.0f / (f + 500.0f)) * 2.0f + 1.0f);
        }
        if (!(ifluidstate = p_215311_1_.func_216771_k()).func_206888_e()) {
            d0 = d0 * 60.0 / 70.0;
        }
        return ForgeHooksClient.getFOVModifier((GameRenderer)this, (ActiveRenderInfo)p_215311_1_, (double)p_215311_2_, (double)d0);
    }

    private void func_78482_e(float partialTicks) {
        if (this.field_78531_r.func_175606_aa() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)this.field_78531_r.func_175606_aa();
            float f = (float)livingentity.field_70737_aN - partialTicks;
            if (livingentity.func_110143_aJ() <= 0.0f) {
                float f1 = (float)livingentity.field_70725_aQ + partialTicks;
                GlStateManager.rotatef((float)(40.0f - 8000.0f / (f1 + 200.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (f < 0.0f) {
                return;
            }
            f /= (float)livingentity.field_70738_aO;
            f = MathHelper.func_76126_a((float)(f * f * f * f * (float)Math.PI));
            float f2 = livingentity.field_70739_aP;
            GlStateManager.rotatef((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)(-f * 14.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)f2, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void func_78475_f(float partialTicks) {
        if (this.field_78531_r.func_175606_aa() instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)this.field_78531_r.func_175606_aa();
            float f = playerentity.field_70140_Q - playerentity.field_70141_P;
            float f1 = -(playerentity.field_70140_Q + f * partialTicks);
            float f2 = MathHelper.func_219799_g((float)partialTicks, (float)playerentity.field_71107_bF, (float)playerentity.field_71109_bG);
            GlStateManager.translatef((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 0.5f), (float)(-Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) * f2)), (float)0.0f);
            GlStateManager.rotatef((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)(Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private void func_195460_g(float partialTicks) {
        float f;
        this.field_78530_s = this.field_78531_r.field_71474_y.field_151451_c * 16;
        GlStateManager.matrixMode((int)5889);
        GlStateManager.loadIdentity();
        if (this.field_78503_V != 1.0) {
            GlStateManager.translatef((float)((float)this.field_78502_W), (float)((float)(-this.field_78509_X)), (float)0.0f);
            GlStateManager.scaled((double)this.field_78503_V, (double)this.field_78503_V, (double)1.0);
        }
        GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a(this.func_215311_a(this.field_215317_L, partialTicks, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * MathHelper.field_180189_a));
        GlStateManager.matrixMode((int)5888);
        GlStateManager.loadIdentity();
        this.func_78482_e(partialTicks);
        if (this.field_78531_r.field_71474_y.field_74336_f) {
            this.func_78475_f(partialTicks);
        }
        if ((f = MathHelper.func_219799_g((float)partialTicks, (float)this.field_78531_r.field_71439_g.field_71080_cy, (float)this.field_78531_r.field_71439_g.field_71086_bY)) > 0.0f) {
            int i = 20;
            if (this.field_78531_r.field_71439_g.func_70644_a(Effects.field_76431_k)) {
                i = 7;
            }
            float f1 = 5.0f / (f * f + 5.0f) - f * 0.04f;
            f1 *= f1;
            GlStateManager.rotatef((float)(((float)this.field_78529_t + partialTicks) * (float)i), (float)0.0f, (float)1.0f, (float)1.0f);
            GlStateManager.scalef((float)(1.0f / f1), (float)1.0f, (float)1.0f);
            GlStateManager.rotatef((float)(-((float)this.field_78529_t + partialTicks) * (float)i), (float)0.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void func_215308_a(ActiveRenderInfo p_215308_1_, float p_215308_2_) {
        if (!this.field_175078_W) {
            boolean flag;
            GlStateManager.matrixMode((int)5889);
            GlStateManager.loadIdentity();
            GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a(this.func_215311_a(p_215308_1_, p_215308_2_, false), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * 2.0f));
            GlStateManager.matrixMode((int)5888);
            GlStateManager.loadIdentity();
            GlStateManager.pushMatrix();
            this.func_78482_e(p_215308_2_);
            if (this.field_78531_r.field_71474_y.field_74336_f) {
                this.func_78475_f(p_215308_2_);
            }
            boolean bl = flag = this.field_78531_r.func_175606_aa() instanceof LivingEntity && ((LivingEntity)this.field_78531_r.func_175606_aa()).func_70608_bn();
            if (!(ForgeHooksClient.renderFirstPersonHand((WorldRenderer)this.field_78531_r.field_71438_f, (float)p_215308_2_) || this.field_78531_r.field_71474_y.field_74320_O != 0 || flag || this.field_78531_r.field_71474_y.field_74319_N || this.field_78531_r.field_71442_b.func_178889_l() == GameType.SPECTATOR)) {
                this.func_180436_i();
                this.field_78516_c.func_78440_a(p_215308_2_);
                this.func_175072_h();
            }
            GlStateManager.popMatrix();
            if (this.field_78531_r.field_71474_y.field_74320_O == 0 && !flag) {
                this.field_78516_c.func_78447_b(p_215308_2_);
                this.func_78482_e(p_215308_2_);
            }
            if (this.field_78531_r.field_71474_y.field_74336_f) {
                this.func_78475_f(p_215308_2_);
            }
        }
    }

    public void func_175072_h() {
        this.field_78513_d.func_205108_b();
    }

    public void func_180436_i() {
        this.field_78513_d.func_205109_c();
    }

    public float func_180438_a(LivingEntity entitylivingbaseIn, float partialTicks) {
        int i = entitylivingbaseIn.func_70660_b(Effects.field_76439_r).func_76459_b();
        return i > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)(((float)i - partialTicks) * (float)Math.PI * 0.2f)) * 0.3f;
    }

    public void func_195458_a(float partialTicks, long nanoTime, boolean renderWorldIn) {
        if (!(this.field_78531_r.func_195544_aj() || !this.field_78531_r.field_71474_y.field_82881_y || this.field_78531_r.field_71474_y.field_85185_A && this.field_78531_r.field_71417_B.func_198031_d())) {
            if (Util.func_211177_b() - this.field_78508_Y > 500L) {
                this.field_78531_r.func_71385_j(false);
            }
        } else {
            this.field_78508_Y = Util.func_211177_b();
        }
        if (!this.field_78531_r.field_71454_w) {
            int i = (int)(this.field_78531_r.field_71417_B.func_198024_e() * (double)this.field_78531_r.field_195558_d.func_198107_o() / (double)this.field_78531_r.field_195558_d.func_198105_m());
            int j = (int)(this.field_78531_r.field_71417_B.func_198026_f() * (double)this.field_78531_r.field_195558_d.func_198087_p() / (double)this.field_78531_r.field_195558_d.func_198083_n());
            int k = this.field_78531_r.field_71474_y.field_74350_i;
            if (renderWorldIn && this.field_78531_r.field_71441_e != null) {
                this.field_78531_r.func_213239_aq().func_76320_a("level");
                int l = Math.min(Minecraft.func_175610_ah(), k);
                l = Math.max(l, 60);
                long i1 = Util.func_211178_c() - nanoTime;
                long j1 = Math.max((long)(1000000000 / l / 4) - i1, 0L);
                this.func_78471_a(partialTicks, Util.func_211178_c() + j1);
                if (this.field_78531_r.func_71356_B() && this.field_184374_E < Util.func_211177_b() - 1000L) {
                    this.field_184374_E = Util.func_211177_b();
                    if (!this.field_78531_r.func_71401_C().func_184106_y()) {
                        this.func_184373_n();
                    }
                }
                if (GLX.usePostProcess) {
                    this.field_78531_r.field_71438_f.func_174975_c();
                    if (this.field_147707_d != null && this.field_175083_ad) {
                        GlStateManager.matrixMode((int)5890);
                        GlStateManager.pushMatrix();
                        GlStateManager.loadIdentity();
                        this.field_147707_d.func_148018_a(partialTicks);
                        GlStateManager.popMatrix();
                    }
                    this.field_78531_r.func_147110_a().func_147610_a(true);
                }
                this.field_78531_r.func_213239_aq().func_219895_b("gui");
                if (!this.field_78531_r.field_71474_y.field_74319_N || this.field_78531_r.field_71462_r != null) {
                    GlStateManager.alphaFunc((int)516, (float)0.1f);
                    this.field_78531_r.field_195558_d.func_216522_a(Minecraft.field_142025_a);
                    this.func_190563_a(this.field_78531_r.field_195558_d.func_198107_o(), this.field_78531_r.field_195558_d.func_198087_p(), partialTicks);
                    this.field_78531_r.field_71456_v.func_175180_a(partialTicks);
                }
                this.field_78531_r.func_213239_aq().func_76319_b();
            } else {
                GlStateManager.viewport((int)0, (int)0, (int)this.field_78531_r.field_195558_d.func_198109_k(), (int)this.field_78531_r.field_195558_d.func_198091_l());
                GlStateManager.matrixMode((int)5889);
                GlStateManager.loadIdentity();
                GlStateManager.matrixMode((int)5888);
                GlStateManager.loadIdentity();
                this.field_78531_r.field_195558_d.func_216522_a(Minecraft.field_142025_a);
                TileEntityRendererDispatcher.field_147556_a.field_147553_e = this.field_78531_r.func_110434_K();
                TileEntityRendererDispatcher.field_147556_a.field_147557_n = this.field_78531_r.field_71466_p;
            }
            if (this.field_78531_r.field_213279_p != null) {
                GlStateManager.clear((int)256, (boolean)Minecraft.field_142025_a);
                try {
                    this.field_78531_r.field_213279_p.render(i, j, this.field_78531_r.func_193989_ak());
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport = CrashReport.func_85055_a(throwable1, "Rendering overlay");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Overlay render details");
                    crashreportcategory.func_189529_a("Overlay name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_78531_r.field_213279_p.getClass().getCanonicalName()));
                    throw new ReportedException(crashreport);
                }
            }
            if (this.field_78531_r.field_71462_r != null) {
                GlStateManager.clear((int)256, (boolean)Minecraft.field_142025_a);
                try {
                    ForgeHooksClient.drawScreen((Screen)this.field_78531_r.field_71462_r, (int)i, (int)j, (float)this.field_78531_r.func_193989_ak());
                }
                catch (Throwable throwable) {
                    CrashReport crashreport1 = CrashReport.func_85055_a(throwable, "Rendering screen");
                    CrashReportCategory crashreportcategory1 = crashreport1.func_85058_a("Screen render details");
                    crashreportcategory1.func_189529_a("Screen name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> ((Object)((Object)this.field_78531_r.field_71462_r)).getClass().getCanonicalName()));
                    crashreportcategory1.func_189529_a("Mouse location", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%f, %f)", i, j, this.field_78531_r.field_71417_B.func_198024_e(), this.field_78531_r.field_71417_B.func_198026_f())));
                    crashreportcategory1.func_189529_a("Screen size", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%d, %d). Scale factor of %f", this.field_78531_r.field_195558_d.func_198107_o(), this.field_78531_r.field_195558_d.func_198087_p(), this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l(), this.field_78531_r.field_195558_d.func_198100_s())));
                    throw new ReportedException(crashreport1);
                }
            }
        }
    }

    private void func_184373_n() {
        if (this.field_78531_r.field_71438_f.func_184382_g() > 10 && this.field_78531_r.field_71438_f.func_184384_n() && !this.field_78531_r.func_71401_C().func_184106_y()) {
            NativeImage nativeimage = ScreenShotHelper.func_198052_a(this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l(), this.field_78531_r.func_147110_a());
            SimpleResource.field_199031_a.execute(() -> {
                int i = nativeimage.func_195702_a();
                int j = nativeimage.func_195714_b();
                int k = 0;
                int l = 0;
                if (i > j) {
                    k = (i - j) / 2;
                    i = j;
                } else {
                    l = (j - i) / 2;
                    j = i;
                }
                try (NativeImage nativeimage1 = new NativeImage(64, 64, false);){
                    nativeimage.func_195708_a(k, l, i, j, nativeimage1);
                    nativeimage1.func_209271_a(this.field_78531_r.func_71401_C().func_184109_z());
                }
                catch (IOException ioexception) {
                    field_147710_q.warn("Couldn't save auto screenshot", (Throwable)ioexception);
                }
                finally {
                    nativeimage.close();
                }
            });
        }
    }

    private boolean func_175070_n() {
        boolean flag;
        if (!this.field_175073_D) {
            return false;
        }
        Entity entity = this.field_78531_r.func_175606_aa();
        boolean bl = flag = entity instanceof PlayerEntity && !this.field_78531_r.field_71474_y.field_74319_N;
        if (flag && !((PlayerEntity)entity).field_71075_bZ.field_75099_e) {
            ItemStack itemstack = ((LivingEntity)entity).func_184614_ca();
            RayTraceResult raytraceresult = this.field_78531_r.field_71476_x;
            if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockRayTraceResult)raytraceresult).func_216350_a();
                BlockState blockstate = this.field_78531_r.field_71441_e.func_180495_p(blockpos);
                if (this.field_78531_r.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
                    flag = blockstate.func_215699_b(this.field_78531_r.field_71441_e, blockpos) != null;
                } else {
                    CachedBlockInfo cachedblockinfo = new CachedBlockInfo((IWorldReader)this.field_78531_r.field_71441_e, blockpos, false);
                    flag = !itemstack.func_190926_b() && (itemstack.func_206848_a(this.field_78531_r.field_71441_e.func_205772_D(), cachedblockinfo) || itemstack.func_206847_b(this.field_78531_r.field_71441_e.func_205772_D(), cachedblockinfo));
                }
            }
        }
        return flag;
    }

    public void func_78471_a(float partialTicks, long finishTimeNano) {
        this.field_78513_d.func_205106_a(partialTicks);
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a(this.field_78531_r.field_71439_g);
        }
        this.func_78473_a(partialTicks);
        GlStateManager.enableDepthTest();
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.5f);
        this.field_78531_r.func_213239_aq().func_76320_a("center");
        this.func_181560_a(partialTicks, finishTimeNano);
        this.field_78531_r.func_213239_aq().func_76319_b();
    }

    private void func_181560_a(float partialTicks, long nanoTime) {
        WorldRenderer worldrenderer = this.field_78531_r.field_71438_f;
        ParticleManager particlemanager = this.field_78531_r.field_71452_i;
        boolean flag = this.func_175070_n();
        GlStateManager.enableCull();
        this.field_78531_r.func_213239_aq().func_219895_b("camera");
        this.func_195460_g(partialTicks);
        ActiveRenderInfo activerenderinfo = this.field_215317_L;
        activerenderinfo.func_216772_a((IBlockReader)this.field_78531_r.field_71441_e, this.field_78531_r.func_175606_aa() == null ? this.field_78531_r.field_71439_g : this.field_78531_r.func_175606_aa(), this.field_78531_r.field_71474_y.field_74320_O > 0, this.field_78531_r.field_71474_y.field_74320_O == 2, partialTicks);
        ClippingHelper clippinghelper = ClippingHelperImpl.func_78558_a();
        worldrenderer.func_224745_a(activerenderinfo);
        this.field_78531_r.func_213239_aq().func_219895_b("clear");
        GlStateManager.viewport((int)0, (int)0, (int)this.field_78531_r.field_195558_d.func_198109_k(), (int)this.field_78531_r.field_195558_d.func_198091_l());
        this.field_205003_A.func_217619_a(activerenderinfo, partialTicks);
        GlStateManager.clear((int)16640, (boolean)Minecraft.field_142025_a);
        this.field_78531_r.func_213239_aq().func_219895_b("culling");
        Frustum icamera = new Frustum(clippinghelper);
        double d0 = activerenderinfo.func_216785_c().field_72450_a;
        double d1 = activerenderinfo.func_216785_c().field_72448_b;
        double d2 = activerenderinfo.func_216785_c().field_72449_c;
        icamera.func_78547_a(d0, d1, d2);
        if (this.field_78531_r.field_71474_y.field_151451_c >= 4) {
            this.field_205003_A.setupFog(activerenderinfo, -1, partialTicks);
            this.field_78531_r.func_213239_aq().func_219895_b("sky");
            GlStateManager.matrixMode((int)5889);
            GlStateManager.loadIdentity();
            GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a(this.func_215311_a(activerenderinfo, partialTicks, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * 2.0f));
            GlStateManager.matrixMode((int)5888);
            worldrenderer.func_195465_a(partialTicks);
            GlStateManager.matrixMode((int)5889);
            GlStateManager.loadIdentity();
            GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a(this.func_215311_a(activerenderinfo, partialTicks, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * MathHelper.field_180189_a));
            GlStateManager.matrixMode((int)5888);
        }
        this.field_205003_A.setupFog(activerenderinfo, 0, partialTicks);
        GlStateManager.shadeModel((int)7425);
        if (activerenderinfo.func_216785_c().field_72448_b < 128.0) {
            this.func_215313_a(activerenderinfo, worldrenderer, partialTicks, d0, d1, d2);
        }
        this.field_78531_r.func_213239_aq().func_219895_b("prepareterrain");
        this.field_205003_A.setupFog(activerenderinfo, 0, partialTicks);
        this.field_78531_r.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        RenderHelper.func_74518_a();
        this.field_78531_r.func_213239_aq().func_219895_b("terrain_setup");
        this.field_78531_r.field_71441_e.func_72863_F().func_212863_j_().func_215575_a(Integer.MAX_VALUE, true, true);
        worldrenderer.func_215320_a(activerenderinfo, (ICamera)icamera, this.field_175084_ae++, this.field_78531_r.field_71439_g.func_175149_v());
        this.field_78531_r.func_213239_aq().func_219895_b("updatechunks");
        this.field_78531_r.field_71438_f.func_174967_a(nanoTime);
        this.field_78531_r.func_213239_aq().func_219895_b("terrain");
        GlStateManager.matrixMode((int)5888);
        GlStateManager.pushMatrix();
        GlStateManager.disableAlphaTest();
        worldrenderer.func_215323_a(BlockRenderLayer.SOLID, activerenderinfo);
        GlStateManager.enableAlphaTest();
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, this.field_78531_r.field_71474_y.field_151442_I > 0);
        worldrenderer.func_215323_a(BlockRenderLayer.CUTOUT_MIPPED, activerenderinfo);
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
        worldrenderer.func_215323_a(BlockRenderLayer.CUTOUT, activerenderinfo);
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.matrixMode((int)5888);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        RenderHelper.func_74519_b();
        this.field_78531_r.func_213239_aq().func_219895_b("entities");
        worldrenderer.func_215326_a(activerenderinfo, (ICamera)icamera, partialTicks);
        RenderHelper.func_74518_a();
        this.func_175072_h();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.popMatrix();
        if (flag && this.field_78531_r.field_71476_x != null) {
            GlStateManager.disableAlphaTest();
            this.field_78531_r.func_213239_aq().func_219895_b("outline");
            if (!ForgeHooksClient.onDrawBlockHighlight((WorldRenderer)worldrenderer, (ActiveRenderInfo)activerenderinfo, (RayTraceResult)this.field_78531_r.field_71476_x, (int)0, (float)partialTicks)) {
                worldrenderer.func_215325_a(activerenderinfo, this.field_78531_r.field_71476_x, 0);
            }
            GlStateManager.enableAlphaTest();
        }
        if (this.field_78531_r.field_184132_p.func_190074_a()) {
            this.field_78531_r.field_184132_p.func_190073_a(nanoTime);
        }
        this.field_78531_r.func_213239_aq().func_219895_b("destroyProgress");
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
        worldrenderer.func_215318_a(Tessellator.func_178181_a(), Tessellator.func_178181_a().func_178180_c(), activerenderinfo);
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
        GlStateManager.disableBlend();
        this.func_180436_i();
        this.field_205003_A.setupFog(activerenderinfo, 0, partialTicks);
        this.field_78531_r.func_213239_aq().func_219895_b("particles");
        particlemanager.func_215233_a(activerenderinfo, partialTicks);
        this.func_175072_h();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableCull();
        this.field_78531_r.func_213239_aq().func_219895_b("weather");
        this.func_78474_d(partialTicks);
        GlStateManager.depthMask((boolean)true);
        worldrenderer.func_215322_a(activerenderinfo, partialTicks);
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        this.field_205003_A.setupFog(activerenderinfo, 0, partialTicks);
        GlStateManager.enableBlend();
        GlStateManager.depthMask((boolean)false);
        this.field_78531_r.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.shadeModel((int)7425);
        this.field_78531_r.func_213239_aq().func_219895_b("translucent");
        worldrenderer.func_215323_a(BlockRenderLayer.TRANSLUCENT, activerenderinfo);
        GlStateManager.shadeModel((int)7424);
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableCull();
        GlStateManager.disableBlend();
        GlStateManager.disableFog();
        if (activerenderinfo.func_216785_c().field_72448_b >= 128.0) {
            this.field_78531_r.func_213239_aq().func_219895_b("aboveClouds");
            this.func_215313_a(activerenderinfo, worldrenderer, partialTicks, d0, d1, d2);
        }
        this.field_78531_r.func_213239_aq().func_219895_b("forge_render_last");
        ForgeHooksClient.dispatchRenderLast((WorldRenderer)worldrenderer, (float)partialTicks);
        this.field_78531_r.func_213239_aq().func_219895_b("hand");
        if (this.field_175074_C) {
            GlStateManager.clear((int)256, (boolean)Minecraft.field_142025_a);
            this.func_215308_a(activerenderinfo, partialTicks);
        }
    }

    private void func_215313_a(ActiveRenderInfo p_215313_1_, WorldRenderer p_215313_2_, float p_215313_3_, double p_215313_4_, double p_215313_6_, double p_215313_8_) {
        if (this.field_78531_r.field_71474_y.func_216842_e() != CloudOption.OFF) {
            this.field_78531_r.func_213239_aq().func_219895_b("clouds");
            GlStateManager.matrixMode((int)5889);
            GlStateManager.loadIdentity();
            GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a(this.func_215311_a(p_215313_1_, p_215313_3_, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * 4.0f));
            GlStateManager.matrixMode((int)5888);
            GlStateManager.pushMatrix();
            this.field_205003_A.setupFog(p_215313_1_, 0, p_215313_3_);
            p_215313_2_.func_195466_a(p_215313_3_, p_215313_4_, p_215313_6_, p_215313_8_);
            GlStateManager.disableFog();
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5889);
            GlStateManager.loadIdentity();
            GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a(this.func_215311_a(p_215313_1_, p_215313_3_, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * MathHelper.field_180189_a));
            GlStateManager.matrixMode((int)5888);
        }
    }

    private void func_78484_h() {
        float f = this.field_78531_r.field_71441_e.func_72867_j(1.0f);
        if (!this.field_78531_r.field_71474_y.field_74347_j) {
            f /= 2.0f;
        }
        if (f != 0.0f) {
            this.field_78537_ab.setSeed((long)this.field_78529_t * 312987231L);
            ClientWorld iworldreader = this.field_78531_r.field_71441_e;
            BlockPos blockpos = new BlockPos(this.field_215317_L.func_216785_c());
            int i = 10;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            int j = 0;
            int k = (int)(100.0f * f * f);
            if (this.field_78531_r.field_71474_y.field_74362_aa == ParticleStatus.DECREASED) {
                k >>= 1;
            } else if (this.field_78531_r.field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) {
                k = 0;
            }
            for (int l = 0; l < k; ++l) {
                double d6;
                double d5;
                double d8;
                BlockPos blockpos1 = iworldreader.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos.func_177982_a(this.field_78537_ab.nextInt(10) - this.field_78537_ab.nextInt(10), 0, this.field_78537_ab.nextInt(10) - this.field_78537_ab.nextInt(10)));
                Biome biome = iworldreader.func_180494_b(blockpos1);
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (blockpos1.func_177956_o() > blockpos.func_177956_o() + 10 || blockpos1.func_177956_o() < blockpos.func_177956_o() - 10 || biome.func_201851_b() != Biome.RainType.RAIN || !(biome.func_225486_c(blockpos1) >= 0.15f)) continue;
                double d3 = this.field_78537_ab.nextDouble();
                double d4 = this.field_78537_ab.nextDouble();
                BlockState blockstate = iworldreader.func_180495_p(blockpos2);
                IFluidState ifluidstate = iworldreader.func_204610_c(blockpos1);
                VoxelShape voxelshape = blockstate.func_196952_d((IBlockReader)iworldreader, blockpos2);
                double d7 = voxelshape.func_197760_b(Direction.Axis.Y, d3, d4);
                if (d7 >= (d8 = (double)ifluidstate.func_215679_a((IBlockReader)iworldreader, blockpos1))) {
                    d5 = d7;
                    d6 = voxelshape.func_197764_a(Direction.Axis.Y, d3, d4);
                } else {
                    d5 = 0.0;
                    d6 = 0.0;
                }
                if (!(d5 > -1.7976931348623157E308)) continue;
                if (!(ifluidstate.func_206884_a(FluidTags.field_206960_b) || blockstate.func_177230_c() == Blocks.field_196814_hQ || blockstate.func_177230_c() == Blocks.field_222433_lV && ((Boolean)blockstate.func_177229_b((IProperty)CampfireBlock.field_220101_b)).booleanValue())) {
                    if (this.field_78537_ab.nextInt(++j) == 0) {
                        d0 = (double)blockpos2.func_177958_n() + d3;
                        d1 = (double)((float)blockpos2.func_177956_o() + 0.1f) + d5 - 1.0;
                        d2 = (double)blockpos2.func_177952_p() + d4;
                    }
                    this.field_78531_r.field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197600_K, (double)blockpos2.func_177958_n() + d3, (double)((float)blockpos2.func_177956_o() + 0.1f) + d5, (double)blockpos2.func_177952_p() + d4, 0.0, 0.0, 0.0);
                    continue;
                }
                this.field_78531_r.field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)blockpos1.func_177958_n() + d3, (double)((float)blockpos1.func_177956_o() + 0.1f) - d6, (double)blockpos1.func_177952_p() + d4, 0.0, 0.0, 0.0);
            }
            if (j > 0 && this.field_78537_ab.nextInt(3) < this.field_78534_ac++) {
                this.field_78534_ac = 0;
                if (d1 > (double)(blockpos.func_177956_o() + 1) && iworldreader.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos).func_177956_o() > MathHelper.func_76141_d((float)blockpos.func_177956_o())) {
                    this.field_78531_r.field_71441_e.func_184134_a(d0, d1, d2, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.1f, 0.5f, false);
                } else {
                    this.field_78531_r.field_71441_e.func_184134_a(d0, d1, d2, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
    }

    protected void func_78474_d(float partialTicks) {
        IRenderHandler renderer = this.field_78531_r.field_71441_e.func_201675_m().getWeatherRenderer();
        if (renderer != null) {
            renderer.render(this.field_78529_t, partialTicks, this.field_78531_r.field_71441_e, this.field_78531_r);
            return;
        }
        float f = this.field_78531_r.field_71441_e.func_72867_j(partialTicks);
        if (!(f <= 0.0f)) {
            this.func_180436_i();
            ClientWorld world = this.field_78531_r.field_71441_e;
            int i = MathHelper.func_76128_c((double)this.field_215317_L.func_216785_c().field_72450_a);
            int j = MathHelper.func_76128_c((double)this.field_215317_L.func_216785_c().field_72448_b);
            int k = MathHelper.func_76128_c((double)this.field_215317_L.func_216785_c().field_72449_c);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.disableCull();
            GlStateManager.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            double d0 = this.field_215317_L.func_216785_c().field_72450_a;
            double d1 = this.field_215317_L.func_216785_c().field_72448_b;
            double d2 = this.field_215317_L.func_216785_c().field_72449_c;
            int l = MathHelper.func_76128_c((double)d1);
            int i1 = 5;
            if (this.field_78531_r.field_71474_y.field_74347_j) {
                i1 = 10;
            }
            int j1 = -1;
            float f1 = (float)this.field_78529_t + partialTicks;
            bufferbuilder.func_178969_c(-d0, -d1, -d2);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)this.field_175076_N[i2] * 0.5;
                    double d4 = (double)this.field_175077_O[i2] * 0.5;
                    blockpos$mutableblockpos.func_181079_c(l1, 0, k1);
                    Biome biome = world.func_180494_b((BlockPos)blockpos$mutableblockpos);
                    if (biome.func_201851_b() == Biome.RainType.NONE) continue;
                    int j2 = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)blockpos$mutableblockpos).func_177956_o();
                    int k2 = j - i1;
                    int l2 = j + i1;
                    if (k2 < j2) {
                        k2 = j2;
                    }
                    if (l2 < j2) {
                        l2 = j2;
                    }
                    int i3 = j2;
                    if (j2 < l) {
                        i3 = l;
                    }
                    if (k2 == l2) continue;
                    this.field_78537_ab.setSeed(l1 * l1 * 3121 + l1 * 45238971 ^ k1 * k1 * 418711 + k1 * 13761);
                    blockpos$mutableblockpos.func_181079_c(l1, k2, k1);
                    float f2 = biome.func_225486_c((BlockPos)blockpos$mutableblockpos);
                    if (f2 >= 0.15f) {
                        if (j1 != 0) {
                            if (j1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            j1 = 0;
                            this.field_78531_r.func_110434_K().func_110577_a(field_110924_q);
                            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        double d5 = -((double)(this.field_78529_t + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.field_78537_ab.nextDouble());
                        double d6 = (double)((float)l1 + 0.5f) - this.field_215317_L.func_216785_c().field_72450_a;
                        double d7 = (double)((float)k1 + 0.5f) - this.field_215317_L.func_216785_c().field_72449_c;
                        float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)i1;
                        float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                        blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                        int j3 = world.func_217338_b((BlockPos)blockpos$mutableblockpos, 0);
                        int k3 = j3 >> 16 & 0xFFFF;
                        int l3 = j3 & 0xFFFF;
                        bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, l2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, l2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, k2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, k2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        continue;
                    }
                    if (j1 != 1) {
                        if (j1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        j1 = 1;
                        this.field_78531_r.func_110434_K().func_110577_a(field_110923_r);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    double d8 = -((float)(this.field_78529_t & 0x1FF) + partialTicks) / 512.0f;
                    double d9 = this.field_78537_ab.nextDouble() + (double)f1 * 0.01 * (double)((float)this.field_78537_ab.nextGaussian());
                    double d10 = this.field_78537_ab.nextDouble() + (double)(f1 * (float)this.field_78537_ab.nextGaussian()) * 0.001;
                    double d11 = (double)((float)l1 + 0.5f) - this.field_215317_L.func_216785_c().field_72450_a;
                    double d12 = (double)((float)k1 + 0.5f) - this.field_215317_L.func_216785_c().field_72449_c;
                    float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)i1;
                    float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                    int i4 = (world.func_217338_b((BlockPos)blockpos$mutableblockpos, 0) * 3 + 0xF000F0) / 4;
                    int j4 = i4 >> 16 & 0xFFFF;
                    int k4 = i4 & 0xFFFF;
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, l2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, l2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, k2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, k2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                }
            }
            if (j1 >= 0) {
                tessellator.func_78381_a();
            }
            bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.enableCull();
            GlStateManager.disableBlend();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            this.func_175072_h();
        }
    }

    public void func_191514_d(boolean black) {
        this.field_205003_A.func_205090_a(black);
    }

    public void func_190564_k() {
        this.field_190566_ab = null;
        this.field_147709_v.func_148249_a();
        this.field_215317_L.func_216781_o();
    }

    public MapItemRenderer func_147701_i() {
        return this.field_147709_v;
    }

    public static void func_215307_a(FontRenderer fontRendererIn, String str, float x, float y, float z, int verticalShift, float viewerYaw, float viewerPitch, boolean isSneaking) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)x, (float)y, (float)z);
        GlStateManager.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)viewerPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scalef((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.disableLighting();
        GlStateManager.depthMask((boolean)false);
        if (!isSneaking) {
            GlStateManager.disableDepthTest();
        }
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int i = fontRendererIn.func_78256_a(str) / 2;
        GlStateManager.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float f = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
        bufferbuilder.func_181662_b(-i - 1, -1 + verticalShift, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, f).func_181675_d();
        bufferbuilder.func_181662_b(-i - 1, 8 + verticalShift, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, f).func_181675_d();
        bufferbuilder.func_181662_b(i + 1, 8 + verticalShift, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, f).func_181675_d();
        bufferbuilder.func_181662_b(i + 1, -1 + verticalShift, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableTexture();
        if (!isSneaking) {
            fontRendererIn.func_211126_b(str, (float)(-fontRendererIn.func_78256_a(str) / 2), (float)verticalShift, 0x20FFFFFF);
            GlStateManager.enableDepthTest();
        }
        GlStateManager.depthMask((boolean)true);
        fontRendererIn.func_211126_b(str, (float)(-fontRendererIn.func_78256_a(str) / 2), (float)verticalShift, isSneaking ? 0x20FFFFFF : -1);
        GlStateManager.enableLighting();
        GlStateManager.disableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    public void func_190565_a(ItemStack stack) {
        this.field_190566_ab = stack;
        this.field_190567_ac = 40;
        this.field_190568_ad = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
        this.field_190569_ae = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
    }

    private void func_190563_a(int widthsp, int heightScaled, float partialTicks) {
        if (this.field_190566_ab != null && this.field_190567_ac > 0) {
            int i = 40 - this.field_190567_ac;
            float f = ((float)i + partialTicks) / 40.0f;
            float f1 = f * f;
            float f2 = f * f1;
            float f3 = 10.25f * f2 * f1 - 24.95f * f1 * f1 + 25.5f * f2 - 13.8f * f1 + 4.0f * f;
            float f4 = f3 * (float)Math.PI;
            float f5 = this.field_190568_ad * (float)(widthsp / 4);
            float f6 = this.field_190569_ae * (float)(heightScaled / 4);
            GlStateManager.enableAlphaTest();
            GlStateManager.pushMatrix();
            GlStateManager.pushLightingAttributes();
            GlStateManager.enableDepthTest();
            GlStateManager.disableCull();
            RenderHelper.func_74519_b();
            GlStateManager.translatef((float)((float)(widthsp / 2) + f5 * MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)(f4 * 2.0f)))), (float)((float)(heightScaled / 2) + f6 * MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)(f4 * 2.0f)))), (float)-50.0f);
            float f7 = 50.0f + 175.0f * MathHelper.func_76126_a((float)f4);
            GlStateManager.scalef((float)f7, (float)(-f7), (float)f7);
            GlStateManager.rotatef((float)(900.0f * MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)f4))), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)(6.0f * MathHelper.func_76134_b((float)(f * 8.0f))), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)(6.0f * MathHelper.func_76134_b((float)(f * 8.0f))), (float)0.0f, (float)0.0f, (float)1.0f);
            this.field_78531_r.func_175599_af().func_181564_a(this.field_190566_ab, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.popAttributes();
            GlStateManager.popMatrix();
            RenderHelper.func_74518_a();
            GlStateManager.enableCull();
            GlStateManager.disableDepthTest();
        }
    }

    public Minecraft func_205000_l() {
        return this.field_78531_r;
    }

    public float func_205002_d(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.field_82832_V, (float)this.field_82831_U);
    }

    public float func_205001_m() {
        return this.field_78530_s;
    }

    public ActiveRenderInfo func_215316_n() {
        return this.field_215317_L;
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.SHADERS;
    }
}

