/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class Screen
extends FocusableGui
implements IRenderable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> ALLOWED_PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});
    protected final ITextComponent title;
    protected final List<IGuiEventListener> children = Lists.newArrayList();
    @Nullable
    protected Minecraft minecraft;
    protected ItemRenderer itemRenderer;
    public int width;
    public int height;
    protected final List<Widget> buttons = Lists.newArrayList();
    public boolean passEvents;
    protected FontRenderer font;
    private URI clickedLink;

    protected Screen(ITextComponent titleIn) {
        this.title = titleIn;
    }

    public ITextComponent getTitle() {
        return this.title;
    }

    public String getNarrationMessage() {
        return this.getTitle().getString();
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).render(p_render_1_, p_render_2_, p_render_3_);
        }
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        if (p_keyPressed_1_ == 258) {
            boolean flag;
            boolean bl = flag = !Screen.hasShiftDown();
            if (!this.changeFocus(flag)) {
                this.changeFocus(flag);
            }
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void onClose() {
        this.minecraft.func_147108_a(null);
    }

    protected <T extends Widget> T addButton(T p_addButton_1_) {
        this.buttons.add(p_addButton_1_);
        this.children.add(p_addButton_1_);
        return p_addButton_1_;
    }

    protected void renderTooltip(ItemStack p_renderTooltip_1_, int p_renderTooltip_2_, int p_renderTooltip_3_) {
        FontRenderer font = p_renderTooltip_1_.func_77973_b().getFontRenderer(p_renderTooltip_1_);
        GuiUtils.preItemToolTip((ItemStack)p_renderTooltip_1_);
        this.renderTooltip(this.getTooltipFromItem(p_renderTooltip_1_), p_renderTooltip_2_, p_renderTooltip_3_, font == null ? this.font : font);
        GuiUtils.postItemToolTip();
    }

    public List<String> getTooltipFromItem(ItemStack p_getTooltipFromItem_1_) {
        List<ITextComponent> list = p_getTooltipFromItem_1_.func_82840_a(this.minecraft.field_71439_g, (ITooltipFlag)(this.minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        ArrayList list1 = Lists.newArrayList();
        for (ITextComponent itextcomponent : list) {
            list1.add(itextcomponent.func_150254_d());
        }
        return list1;
    }

    public void renderTooltip(String p_renderTooltip_1_, int p_renderTooltip_2_, int p_renderTooltip_3_) {
        this.renderTooltip(Arrays.asList(p_renderTooltip_1_), p_renderTooltip_2_, p_renderTooltip_3_);
    }

    public void renderTooltip(List<String> p_renderTooltip_1_, int p_renderTooltip_2_, int p_renderTooltip_3_) {
        this.renderTooltip(p_renderTooltip_1_, p_renderTooltip_2_, p_renderTooltip_3_, this.font);
    }

    public void renderTooltip(List<String> p_renderTooltip_1_, int p_renderTooltip_2_, int p_renderTooltip_3_, FontRenderer font) {
        GuiUtils.drawHoveringText(p_renderTooltip_1_, (int)p_renderTooltip_2_, (int)p_renderTooltip_3_, (int)this.width, (int)this.height, (int)-1, (FontRenderer)font);
    }

    protected void renderComponentHoverEffect(ITextComponent p_renderComponentHoverEffect_1_, int p_renderComponentHoverEffect_2_, int p_renderComponentHoverEffect_3_) {
        if (p_renderComponentHoverEffect_1_ != null && p_renderComponentHoverEffect_1_.func_150256_b().func_150210_i() != null) {
            HoverEvent hoverevent = p_renderComponentHoverEffect_1_.func_150256_b().func_150210_i();
            if (hoverevent.func_150701_a() == HoverEvent.Action.SHOW_ITEM) {
                ItemStack itemstack = ItemStack.field_190927_a;
                try {
                    CompoundNBT inbt = JsonToNBT.func_180713_a((String)hoverevent.func_150702_b().getString());
                    if (inbt instanceof CompoundNBT) {
                        itemstack = ItemStack.func_199557_a(inbt);
                    }
                }
                catch (CommandSyntaxException inbt) {
                    // empty catch block
                }
                if (itemstack.func_190926_b()) {
                    this.renderTooltip(TextFormatting.RED + "Invalid Item!", p_renderComponentHoverEffect_2_, p_renderComponentHoverEffect_3_);
                } else {
                    this.renderTooltip(itemstack, p_renderComponentHoverEffect_2_, p_renderComponentHoverEffect_3_);
                }
            } else if (hoverevent.func_150701_a() == HoverEvent.Action.SHOW_ENTITY) {
                if (this.minecraft.field_71474_y.field_82882_x) {
                    try {
                        CompoundNBT compoundnbt = JsonToNBT.func_180713_a((String)hoverevent.func_150702_b().getString());
                        ArrayList list = Lists.newArrayList();
                        ITextComponent itextcomponent = ITextComponent.Serializer.func_150699_a((String)compoundnbt.func_74779_i("name"));
                        if (itextcomponent != null) {
                            list.add(itextcomponent.func_150254_d());
                        }
                        if (compoundnbt.func_150297_b("type", 8)) {
                            String s = compoundnbt.func_74779_i("type");
                            list.add("Type: " + s);
                        }
                        list.add(compoundnbt.func_74779_i("id"));
                        this.renderTooltip(list, p_renderComponentHoverEffect_2_, p_renderComponentHoverEffect_3_);
                    }
                    catch (JsonSyntaxException | CommandSyntaxException var9) {
                        this.renderTooltip(TextFormatting.RED + "Invalid Entity!", p_renderComponentHoverEffect_2_, p_renderComponentHoverEffect_3_);
                    }
                }
            } else if (hoverevent.func_150701_a() == HoverEvent.Action.SHOW_TEXT) {
                this.renderTooltip(this.minecraft.field_71466_p.func_78271_c(hoverevent.func_150702_b().func_150254_d(), Math.max(this.width / 2, 200)), p_renderComponentHoverEffect_2_, p_renderComponentHoverEffect_3_);
            }
            GlStateManager.disableLighting();
        }
    }

    protected void insertText(String p_insertText_1_, boolean p_insertText_2_) {
    }

    public boolean handleComponentClicked(ITextComponent p_handleComponentClicked_1_) {
        if (p_handleComponentClicked_1_ == null) {
            return false;
        }
        ClickEvent clickevent = p_handleComponentClicked_1_.func_150256_b().func_150235_h();
        if (Screen.hasShiftDown()) {
            if (p_handleComponentClicked_1_.func_150256_b().func_179986_j() != null) {
                this.insertText(p_handleComponentClicked_1_.func_150256_b().func_179986_j(), false);
            }
        } else if (clickevent != null) {
            block19: {
                if (clickevent.func_150669_a() == ClickEvent.Action.OPEN_URL) {
                    if (!this.minecraft.field_71474_y.field_74359_p) {
                        return false;
                    }
                    try {
                        URI uri = new URI(clickevent.func_150668_b());
                        String s = uri.getScheme();
                        if (s == null) {
                            throw new URISyntaxException(clickevent.func_150668_b(), "Missing protocol");
                        }
                        if (!ALLOWED_PROTOCOLS.contains(s.toLowerCase(Locale.ROOT))) {
                            throw new URISyntaxException(clickevent.func_150668_b(), "Unsupported protocol: " + s.toLowerCase(Locale.ROOT));
                        }
                        if (this.minecraft.field_71474_y.field_74358_q) {
                            this.clickedLink = uri;
                            this.minecraft.func_147108_a((Screen)new ConfirmOpenLinkScreen(this::confirmLink, clickevent.func_150668_b(), false));
                            break block19;
                        }
                        this.openLink(uri);
                    }
                    catch (URISyntaxException urisyntaxexception) {
                        LOGGER.error("Can't open url for {}", (Object)clickevent, (Object)urisyntaxexception);
                    }
                } else if (clickevent.func_150669_a() == ClickEvent.Action.OPEN_FILE) {
                    URI uri1 = new File(clickevent.func_150668_b()).toURI();
                    this.openLink(uri1);
                } else if (clickevent.func_150669_a() == ClickEvent.Action.SUGGEST_COMMAND) {
                    this.insertText(clickevent.func_150668_b(), true);
                } else if (clickevent.func_150669_a() == ClickEvent.Action.RUN_COMMAND) {
                    this.sendMessage(clickevent.func_150668_b(), false);
                } else {
                    LOGGER.error("Don't know how to handle {}", (Object)clickevent);
                }
            }
            return true;
        }
        return false;
    }

    public void sendMessage(String p_sendMessage_1_) {
        this.sendMessage(p_sendMessage_1_, true);
    }

    public void sendMessage(String p_sendMessage_1_, boolean p_sendMessage_2_) {
        if ((p_sendMessage_1_ = ForgeEventFactory.onClientSendMessage((String)p_sendMessage_1_)).isEmpty()) {
            return;
        }
        if (p_sendMessage_2_) {
            this.minecraft.field_71456_v.func_146158_b().func_146239_a(p_sendMessage_1_);
        }
        this.minecraft.field_71439_g.func_71165_d(p_sendMessage_1_);
    }

    public void init(Minecraft p_init_1_, int p_init_2_, int p_init_3_) {
        this.minecraft = p_init_1_;
        this.itemRenderer = p_init_1_.func_175599_af();
        this.font = p_init_1_.field_71466_p;
        this.width = p_init_2_;
        this.height = p_init_3_;
        Consumer<Widget> remove = b -> {
            this.buttons.remove(b);
            this.children.remove(b);
        };
        if (!MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Pre(this, this.buttons, this::addButton, remove))) {
            this.buttons.clear();
            this.children.clear();
            this.setFocused(null);
            this.init();
        }
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Post(this, this.buttons, this::addButton, remove));
    }

    public void setSize(int p_setSize_1_, int p_setSize_2_) {
        this.width = p_setSize_1_;
        this.height = p_setSize_2_;
    }

    public List<? extends IGuiEventListener> children() {
        return this.children;
    }

    protected void init() {
    }

    public void tick() {
    }

    public void removed() {
    }

    public void renderBackground() {
        this.renderBackground(0);
    }

    public void renderBackground(int p_renderBackground_1_) {
        if (this.minecraft.field_71441_e != null) {
            this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent(this));
        } else {
            this.renderDirtBackground(p_renderBackground_1_);
        }
    }

    public void renderDirtBackground(int p_renderDirtBackground_1_) {
        GlStateManager.disableLighting();
        GlStateManager.disableFog();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(BACKGROUND_LOCATION);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(0.0, this.height, 0.0).func_187315_a(0.0, (float)this.height / 32.0f + (float)p_renderDirtBackground_1_).func_181669_b(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_181662_b(this.width, this.height, 0.0).func_187315_a((float)this.width / 32.0f, (float)this.height / 32.0f + (float)p_renderDirtBackground_1_).func_181669_b(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_181662_b(this.width, 0.0, 0.0).func_187315_a((float)this.width / 32.0f, p_renderDirtBackground_1_).func_181669_b(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, p_renderDirtBackground_1_).func_181669_b(64, 64, 64, 255).func_181675_d();
        tessellator.func_78381_a();
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent(this));
    }

    public boolean isPauseScreen() {
        return true;
    }

    private void confirmLink(boolean p_confirmLink_1_) {
        if (p_confirmLink_1_) {
            this.openLink(this.clickedLink);
        }
        this.clickedLink = null;
        this.minecraft.func_147108_a(this);
    }

    private void openLink(URI p_openLink_1_) {
        Util.func_110647_a().func_195642_a(p_openLink_1_);
    }

    public static boolean hasControlDown() {
        if (Minecraft.field_142025_a) {
            return InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)343) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)347);
        }
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)341) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)345);
    }

    public static boolean hasShiftDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)344);
    }

    public static boolean hasAltDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)342) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)346);
    }

    public static boolean isCut(int p_isCut_0_) {
        return p_isCut_0_ == 88 && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown();
    }

    public static boolean isPaste(int p_isPaste_0_) {
        return p_isPaste_0_ == 86 && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown();
    }

    public static boolean isCopy(int p_isCopy_0_) {
        return p_isCopy_0_ == 67 && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown();
    }

    public static boolean isSelectAll(int p_isSelectAll_0_) {
        return p_isSelectAll_0_ == 65 && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown();
    }

    public void resize(Minecraft p_resize_1_, int p_resize_2_, int p_resize_3_) {
        this.init(p_resize_1_, p_resize_2_, p_resize_3_);
    }

    public static void wrapScreenError(Runnable p_wrapScreenError_0_, String p_wrapScreenError_1_, String p_wrapScreenError_2_) {
        try {
            p_wrapScreenError_0_.run();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, p_wrapScreenError_1_);
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Affected screen");
            crashreportcategory.func_189529_a("Screen name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> p_wrapScreenError_2_));
            throw new ReportedException(crashreport);
        }
    }

    protected boolean isValidCharacterForName(String p_isValidCharacterForName_1_, char p_isValidCharacterForName_2_, int p_isValidCharacterForName_3_) {
        int i = p_isValidCharacterForName_1_.indexOf(58);
        int j = p_isValidCharacterForName_1_.indexOf(47);
        if (p_isValidCharacterForName_2_ == ':') {
            return (j == -1 || p_isValidCharacterForName_3_ <= j) && i == -1;
        }
        if (p_isValidCharacterForName_2_ == '/') {
            return p_isValidCharacterForName_3_ > i;
        }
        return p_isValidCharacterForName_2_ == '_' || p_isValidCharacterForName_2_ == '-' || p_isValidCharacterForName_2_ >= 'a' && p_isValidCharacterForName_2_ <= 'z' || p_isValidCharacterForName_2_ >= '0' && p_isValidCharacterForName_2_ <= '9' || p_isValidCharacterForName_2_ == '.';
    }

    public boolean isMouseOver(double p_isMouseOver_1_, double p_isMouseOver_3_) {
        return true;
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }
}

