/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.end;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.EndPortalTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IWorld;
import net.minecraft.world.ServerBossInfo;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.end.DragonSpawnState;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndGatewayConfig;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraft.world.gen.feature.EndSpikeFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonFightManager {
    private static final Logger field_186107_a = LogManager.getLogger();
    private static final Predicate<Entity> field_186108_b = EntityPredicates.field_94557_a.and(EntityPredicates.func_188443_a(0.0, 128.0, 0.0, 192.0));
    private final ServerBossInfo field_186109_c = (ServerBossInfo)new ServerBossInfo(new TranslationTextComponent("entity.minecraft.ender_dragon", new Object[0]), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).func_186742_b(true).func_186743_c(true);
    private final ServerWorld field_186110_d;
    private final List<Integer> field_186111_e = Lists.newArrayList();
    private final BlockPattern field_186112_f;
    private int field_186113_g;
    private int field_186114_h;
    private int field_186115_i;
    private int field_186116_j;
    private boolean field_186117_k;
    private boolean field_186118_l;
    private UUID field_186119_m;
    private boolean field_186120_n = true;
    private BlockPos field_186121_o;
    private DragonSpawnState field_186122_p;
    private int field_186123_q;
    private List<EnderCrystalEntity> field_186124_r;

    public DragonFightManager(ServerWorld serverWorld2, CompoundNBT compoundNBT) {
        this.field_186110_d = serverWorld2;
        if (compoundNBT.func_150297_b("DragonKilled", 99)) {
            if (compoundNBT.func_186855_b("DragonUUID")) {
                this.field_186119_m = compoundNBT.func_186857_a("DragonUUID");
            }
            this.field_186117_k = compoundNBT.func_74767_n("DragonKilled");
            this.field_186118_l = compoundNBT.func_74767_n("PreviouslyKilled");
            if (compoundNBT.func_74767_n("IsRespawning")) {
                this.field_186122_p = DragonSpawnState.START;
            }
            if (compoundNBT.func_150297_b("ExitPortalLocation", 10)) {
                this.field_186121_o = NBTUtil.func_186861_c(compoundNBT.func_74775_l("ExitPortalLocation"));
            }
        } else {
            this.field_186117_k = true;
            this.field_186118_l = true;
        }
        if (compoundNBT.func_150297_b("Gateways", 9)) {
            ListNBT listNBT = compoundNBT.func_150295_c("Gateways", 3);
            for (int i = 0; i < listNBT.size(); ++i) {
                this.field_186111_e.add(listNBT.func_186858_c(i));
            }
        } else {
            ServerWorld serverWorld2;
            this.field_186111_e.addAll((Collection<Integer>)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            Collections.shuffle(this.field_186111_e, new Random(serverWorld2.func_72905_C()));
        }
        this.field_186112_f = BlockPatternBuilder.func_177660_a().func_177659_a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").func_177659_a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").func_177659_a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").func_177659_a("  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  ").func_177659_a("       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       ").func_177662_a('#', CachedBlockInfo.func_177510_a(BlockMatcher.func_177642_a(Blocks.field_150357_h))).func_177661_b();
    }

    public CompoundNBT func_186088_a() {
        CompoundNBT compoundNBT = new CompoundNBT();
        if (this.field_186119_m != null) {
            compoundNBT.func_186854_a("DragonUUID", this.field_186119_m);
        }
        compoundNBT.func_74757_a("DragonKilled", this.field_186117_k);
        compoundNBT.func_74757_a("PreviouslyKilled", this.field_186118_l);
        if (this.field_186121_o != null) {
            compoundNBT.func_218657_a("ExitPortalLocation", NBTUtil.func_186859_a(this.field_186121_o));
        }
        ListNBT \u26032 = new ListNBT();
        for (int n : this.field_186111_e) {
            \u26032.add(new IntNBT(n));
        }
        compoundNBT.func_218657_a("Gateways", \u26032);
        return compoundNBT;
    }

    public void func_186105_b() {
        this.field_186109_c.func_186758_d(!this.field_186117_k);
        if (++this.field_186116_j >= 20) {
            this.func_186100_j();
            this.field_186116_j = 0;
        }
        if (!this.field_186109_c.func_186757_c().isEmpty()) {
            this.field_186110_d.func_72863_F().func_217228_a(TicketType.field_219489_b, new ChunkPos(0, 0), 9, Unit.INSTANCE);
            boolean bl = this.func_222670_k();
            if (this.field_186120_n && bl) {
                this.func_210827_g();
                this.field_186120_n = false;
            }
            if (this.field_186122_p != null) {
                if (this.field_186124_r == null && bl) {
                    this.field_186122_p = null;
                    this.func_186106_e();
                }
                this.field_186122_p.func_186079_a(this.field_186110_d, this, this.field_186124_r, this.field_186123_q++, this.field_186121_o);
            }
            if (!this.field_186117_k) {
                if ((this.field_186119_m == null || ++this.field_186113_g >= 1200) && bl) {
                    this.func_210828_h();
                    this.field_186113_g = 0;
                }
                if (++this.field_186115_i >= 100 && bl) {
                    this.func_186101_k();
                    this.field_186115_i = 0;
                }
            }
        } else {
            this.field_186110_d.func_72863_F().func_217222_b(TicketType.field_219489_b, new ChunkPos(0, 0), 9, Unit.INSTANCE);
        }
    }

    private void func_210827_g() {
        field_186107_a.info("Scanning for legacy world dragon fight...");
        boolean bl = this.func_186104_g();
        if (bl) {
            field_186107_a.info("Found that the dragon has been killed in this world already.");
            this.field_186118_l = true;
        } else {
            field_186107_a.info("Found that the dragon has not yet been killed in this world.");
            this.field_186118_l = false;
            this.func_186094_a(false);
        }
        List<EnderDragonEntity> \u26032 = this.field_186110_d.func_217439_j();
        if (\u26032.isEmpty()) {
            this.field_186117_k = true;
        } else {
            EnderDragonEntity enderDragonEntity = \u26032.get(0);
            this.field_186119_m = enderDragonEntity.func_110124_au();
            field_186107_a.info("Found that there's a dragon still alive ({})", (Object)enderDragonEntity);
            this.field_186117_k = false;
            if (!bl) {
                field_186107_a.info("But we didn't have a portal, let's remove it.");
                enderDragonEntity.func_70106_y();
                this.field_186119_m = null;
            }
        }
        if (!this.field_186118_l && this.field_186117_k) {
            this.field_186117_k = false;
        }
    }

    private void func_210828_h() {
        List<EnderDragonEntity> list = this.field_186110_d.func_217439_j();
        if (list.isEmpty()) {
            field_186107_a.debug("Haven't seen the dragon, respawning it");
            this.func_192445_m();
        } else {
            field_186107_a.debug("Haven't seen our dragon, but found another one to use.");
            this.field_186119_m = list.get(0).func_110124_au();
        }
    }

    protected void func_186095_a(DragonSpawnState dragonSpawnState2) {
        if (this.field_186122_p == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.field_186123_q = 0;
        if (dragonSpawnState2 == DragonSpawnState.END) {
            this.field_186122_p = null;
            this.field_186117_k = false;
            EnderDragonEntity enderDragonEntity = this.func_192445_m();
            for (ServerPlayerEntity serverPlayerEntity : this.field_186109_c.func_186757_c()) {
                CriteriaTriggers.field_192133_m.func_192229_a(serverPlayerEntity, enderDragonEntity);
            }
        } else {
            DragonSpawnState dragonSpawnState2;
            this.field_186122_p = dragonSpawnState2;
        }
    }

    private boolean func_186104_g() {
        for (int i = -8; i <= 8; ++i) {
            for (\u2603 = -8; \u2603 <= 8; ++\u2603) {
                Chunk chunk = this.field_186110_d.func_212866_a_(i, \u2603);
                for (TileEntity tileEntity : chunk.func_177434_r().values()) {
                    if (!(tileEntity instanceof EndPortalTileEntity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private BlockPattern.PatternHelper func_186091_h() {
        Object object;
        for (int i = -8; i <= 8; ++i) {
            for (i = -8; i <= 8; ++i) {
                object = this.field_186110_d.func_212866_a_(i, i);
                for (TileEntity tileEntity : ((Chunk)object).func_177434_r().values()) {
                    if (!(tileEntity instanceof EndPortalTileEntity) || (\u2603 = this.field_186112_f.func_177681_a(this.field_186110_d, tileEntity.func_174877_v())) == null) continue;
                    BlockPos blockPos = \u2603.func_177670_a(3, 3, 3).func_177508_d();
                    if (this.field_186121_o == null && blockPos.func_177958_n() == 0 && blockPos.func_177952_p() == 0) {
                        this.field_186121_o = blockPos;
                    }
                    return \u2603;
                }
            }
        }
        for (int i = i = this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndPodiumFeature.field_186139_a).func_177956_o(); i >= 0; --i) {
            object = this.field_186112_f.func_177681_a(this.field_186110_d, new BlockPos(EndPodiumFeature.field_186139_a.func_177958_n(), i, EndPodiumFeature.field_186139_a.func_177952_p()));
            if (object == null) continue;
            if (this.field_186121_o == null) {
                this.field_186121_o = ((BlockPattern.PatternHelper)object).func_177670_a(3, 3, 3).func_177508_d();
            }
            return object;
        }
        return null;
    }

    private boolean func_222670_k() {
        for (int i = -8; i <= 8; ++i) {
            for (\u2603 = 8; \u2603 <= 8; ++\u2603) {
                IChunk iChunk = this.field_186110_d.func_217353_a(i, \u2603, ChunkStatus.field_222617_m, false);
                if (!(iChunk instanceof Chunk)) {
                    return false;
                }
                ChunkHolder.LocationType \u26032 = ((Chunk)iChunk).func_217321_u();
                if (\u26032.func_219065_a(ChunkHolder.LocationType.TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    private void func_186100_j() {
        HashSet hashSet = Sets.newHashSet();
        for (ServerPlayerEntity serverPlayerEntity : this.field_186110_d.func_217490_a(field_186108_b)) {
            this.field_186109_c.func_186760_a(serverPlayerEntity);
            hashSet.add(serverPlayerEntity);
        }
        HashSet hashSet2 = Sets.newHashSet(this.field_186109_c.func_186757_c());
        hashSet2.removeAll(hashSet);
        for (ServerPlayerEntity serverPlayerEntity : hashSet2) {
            this.field_186109_c.func_186761_b(serverPlayerEntity);
        }
    }

    private void func_186101_k() {
        this.field_186115_i = 0;
        this.field_186114_h = 0;
        for (EndSpikeFeature.EndSpike endSpike : EndSpikeFeature.func_214554_a(this.field_186110_d)) {
            this.field_186114_h += this.field_186110_d.func_217357_a(EnderCrystalEntity.class, endSpike.func_186153_f()).size();
        }
        field_186107_a.debug("Found {} end crystals still alive", (Object)this.field_186114_h);
    }

    public void func_186096_a(EnderDragonEntity enderDragonEntity) {
        if (enderDragonEntity.func_110124_au().equals(this.field_186119_m)) {
            this.field_186109_c.func_186735_a(0.0f);
            this.field_186109_c.func_186758_d(false);
            this.func_186094_a(true);
            this.func_186097_l();
            if (!this.field_186118_l) {
                this.field_186110_d.func_175656_a(this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndPodiumFeature.field_186139_a), Blocks.field_150380_bt.func_176223_P());
            }
            this.field_186118_l = true;
            this.field_186117_k = true;
        }
    }

    private void func_186097_l() {
        if (this.field_186111_e.isEmpty()) {
            return;
        }
        int n = this.field_186111_e.remove(this.field_186111_e.size() - 1);
        \u2603 = MathHelper.func_76128_c(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)n)));
        \u2603 = MathHelper.func_76128_c(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)n)));
        this.func_186089_a(new BlockPos(\u2603, 75, \u2603));
    }

    private void func_186089_a(BlockPos blockPos) {
        this.field_186110_d.func_217379_c(3000, blockPos, 0);
        Feature.field_202299_as.func_212245_a(this.field_186110_d, this.field_186110_d.func_72863_F().func_201711_g(), new Random(), blockPos, EndGatewayConfig.func_214698_a());
    }

    private void func_186094_a(boolean bl) {
        EndPodiumFeature endPodiumFeature = new EndPodiumFeature(bl);
        if (this.field_186121_o == null) {
            this.field_186121_o = this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a).func_177977_b();
            while (this.field_186110_d.func_180495_p(this.field_186121_o).func_177230_c() == Blocks.field_150357_h && this.field_186121_o.func_177956_o() > this.field_186110_d.func_181545_F()) {
                this.field_186121_o = this.field_186121_o.func_177977_b();
            }
        }
        endPodiumFeature.func_212245_a((IWorld)this.field_186110_d, this.field_186110_d.func_72863_F().func_201711_g(), new Random(), this.field_186121_o, IFeatureConfig.field_202429_e);
    }

    private EnderDragonEntity func_192445_m() {
        this.field_186110_d.func_175726_f(new BlockPos(0, 128, 0));
        EnderDragonEntity enderDragonEntity = EntityType.field_200802_p.func_200721_a(this.field_186110_d);
        enderDragonEntity.func_184670_cT().func_188758_a(PhaseType.field_188741_a);
        enderDragonEntity.func_70012_b(0.0, 128.0, 0.0, this.field_186110_d.field_73012_v.nextFloat() * 360.0f, 0.0f);
        this.field_186110_d.func_217376_c(enderDragonEntity);
        this.field_186119_m = enderDragonEntity.func_110124_au();
        return enderDragonEntity;
    }

    public void func_186099_b(EnderDragonEntity enderDragonEntity) {
        if (enderDragonEntity.func_110124_au().equals(this.field_186119_m)) {
            this.field_186109_c.func_186735_a(enderDragonEntity.func_110143_aJ() / enderDragonEntity.func_110138_aP());
            this.field_186113_g = 0;
            if (enderDragonEntity.func_145818_k_()) {
                this.field_186109_c.func_186739_a(enderDragonEntity.func_145748_c_());
            }
        }
    }

    public int func_186092_c() {
        return this.field_186114_h;
    }

    public void func_186090_a(EnderCrystalEntity enderCrystalEntity, DamageSource damageSource) {
        if (this.field_186122_p != null && this.field_186124_r.contains(enderCrystalEntity)) {
            field_186107_a.debug("Aborting respawn sequence");
            this.field_186122_p = null;
            this.field_186123_q = 0;
            this.func_186087_f();
            this.func_186094_a(true);
        } else {
            this.func_186101_k();
            Entity entity = this.field_186110_d.func_217461_a(this.field_186119_m);
            if (entity instanceof EnderDragonEntity) {
                ((EnderDragonEntity)entity).func_184672_a(enderCrystalEntity, new BlockPos(enderCrystalEntity), damageSource);
            }
        }
    }

    public boolean func_186102_d() {
        return this.field_186118_l;
    }

    public void func_186106_e() {
        if (this.field_186117_k && this.field_186122_p == null) {
            Object object;
            BlockPos \u26032 = this.field_186121_o;
            if (\u26032 == null) {
                field_186107_a.debug("Tried to respawn, but need to find the portal first.");
                object = this.func_186091_h();
                if (object == null) {
                    field_186107_a.debug("Couldn't find a portal, so we made one.");
                    this.func_186094_a(true);
                } else {
                    field_186107_a.debug("Found the exit portal & temporarily using it.");
                }
                \u26032 = this.field_186121_o;
            }
            object = Lists.newArrayList();
            BlockPos \u26033 = \u26032.func_177981_b(1);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                List<EnderCrystalEntity> list = this.field_186110_d.func_217357_a(EnderCrystalEntity.class, new AxisAlignedBB(\u26033.func_177967_a(direction, 2)));
                if (list.isEmpty()) {
                    return;
                }
                object.addAll(list);
            }
            field_186107_a.debug("Found all crystals, respawning dragon.");
            this.func_186093_a((List<EnderCrystalEntity>)object);
        }
    }

    private void func_186093_a(List<EnderCrystalEntity> list2) {
        if (this.field_186117_k && this.field_186122_p == null) {
            List<EnderCrystalEntity> list2;
            BlockPattern.PatternHelper patternHelper = this.func_186091_h();
            while (patternHelper != null) {
                for (int i = 0; i < this.field_186112_f.func_177684_c(); ++i) {
                    for (\u2603 = 0; \u2603 < this.field_186112_f.func_177685_b(); ++\u2603) {
                        for (\u2603 = 0; \u2603 < this.field_186112_f.func_185922_a(); ++\u2603) {
                            CachedBlockInfo cachedBlockInfo = patternHelper.func_177670_a(i, \u2603, \u2603);
                            if (cachedBlockInfo.func_177509_a().func_177230_c() != Blocks.field_150357_h && cachedBlockInfo.func_177509_a().func_177230_c() != Blocks.field_150384_bq) continue;
                            this.field_186110_d.func_175656_a(cachedBlockInfo.func_177508_d(), Blocks.field_150377_bs.func_176223_P());
                        }
                    }
                }
                patternHelper = this.func_186091_h();
            }
            this.field_186122_p = DragonSpawnState.START;
            this.field_186123_q = 0;
            this.func_186094_a(false);
            this.field_186124_r = list2;
        }
    }

    public void func_186087_f() {
        for (EndSpikeFeature.EndSpike endSpike : EndSpikeFeature.func_214554_a(this.field_186110_d)) {
            List<EnderCrystalEntity> list = this.field_186110_d.func_217357_a(EnderCrystalEntity.class, endSpike.func_186153_f());
            for (EnderCrystalEntity enderCrystalEntity : list) {
                enderCrystalEntity.func_184224_h(false);
                enderCrystalEntity.func_184516_a(null);
            }
        }
    }
}

