/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.Structures;
import net.minecraft.world.gen.feature.template.IRuleTestType;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Registry<T>
implements IObjectIntIterable<T> {
    protected static final Logger field_212616_e = LogManager.getLogger();
    private static final Map<ResourceLocation, Supplier<?>> field_218376_a = Maps.newLinkedHashMap();
    public static final MutableRegistry<MutableRegistry<?>> field_212617_f = new SimpleRegistry();
    public static final Registry<SoundEvent> field_212633_v = Registry.func_222935_a("sound_event", () -> SoundEvents.field_187638_cR);
    public static final DefaultedRegistry<Fluid> field_212619_h = Registry.func_222933_a("fluid", "empty", () -> Fluids.field_204541_a);
    public static final Registry<Effect> field_212631_t = Registry.func_222935_a("mob_effect", () -> Effects.field_188425_z);
    public static final DefaultedRegistry<Block> field_212618_g = Registry.func_222933_a("block", "air", () -> Blocks.field_150350_a);
    public static final Registry<Enchantment> field_212628_q = Registry.func_222935_a("enchantment", () -> Enchantments.field_185308_t);
    public static final DefaultedRegistry<EntityType<?>> field_212629_r = Registry.func_222933_a("entity_type", "pig", () -> EntityType.field_200784_X);
    public static final DefaultedRegistry<Item> field_212630_s = Registry.func_222933_a("item", "air", () -> Items.field_190931_a);
    public static final DefaultedRegistry<Potion> field_212621_j = Registry.func_222933_a("potion", "empty", () -> Potions.field_185229_a);
    public static final Registry<WorldCarver<?>> field_218377_o = Registry.func_222935_a("carver", () -> WorldCarver.field_222709_a);
    public static final Registry<SurfaceBuilder<?>> field_218378_p = Registry.func_222935_a("surface_builder", () -> SurfaceBuilder.field_215396_G);
    public static final Registry<Feature<?>> field_218379_q = Registry.func_222935_a("feature", () -> Feature.field_202290_aj);
    public static final Registry<Placement<?>> field_218380_r = Registry.func_222935_a("decorator", () -> Placement.field_215022_h);
    public static final Registry<Biome> field_212624_m = Registry.func_222935_a("biome", () -> Biomes.field_180279_ad);
    public static final Registry<ParticleType<? extends IParticleData>> field_212632_u = Registry.func_222935_a("particle_type", () -> ParticleTypes.field_197611_d);
    public static final Registry<BiomeProviderType<?, ?>> field_212625_n = Registry.func_222935_a("biome_source_type", () -> BiomeProviderType.field_206859_d);
    public static final Registry<TileEntityType<?>> field_212626_o = Registry.func_222935_a("block_entity_type", () -> TileEntityType.field_200971_b);
    public static final Registry<ChunkGeneratorType<?, ?>> field_212627_p = Registry.func_222935_a("chunk_generator_type", () -> ChunkGeneratorType.field_205489_f);
    public static final Registry<DimensionType> field_212622_k = Registry.func_222935_a("dimension_type", () -> DimensionType.field_223227_a_);
    public static final DefaultedRegistry<PaintingType> field_212620_i = Registry.func_222933_a("motive", "kebab", () -> PaintingType.field_200843_b);
    public static final Registry<ResourceLocation> field_212623_l = Registry.func_222935_a("custom_stat", () -> Stats.field_75953_u);
    public static final DefaultedRegistry<ChunkStatus> field_218360_A = Registry.func_222933_a("chunk_status", "empty", () -> ChunkStatus.field_223226_a_);
    public static final Registry<Structure<?>> field_218361_B = Registry.func_222935_a("structure_feature", () -> Structures.field_215143_a);
    public static final Registry<IStructurePieceType> field_218362_C = Registry.func_222935_a("structure_piece", () -> IStructurePieceType.field_214782_c);
    public static final Registry<IRuleTestType> field_218363_D = Registry.func_222935_a("rule_test", () -> IRuleTestType.field_214911_b);
    public static final Registry<IStructureProcessorType> field_218364_E = Registry.func_222935_a("structure_processor", () -> IStructureProcessorType.field_214920_b);
    public static final Registry<IJigsawDeserializer> field_218365_F = Registry.func_222935_a("structure_pool_element", () -> IJigsawDeserializer.field_214931_e);
    public static final Registry<ContainerType<?>> field_218366_G = Registry.func_222935_a("menu", () -> ContainerType.field_221514_h);
    public static final Registry<IRecipeType<?>> field_218367_H = Registry.func_222935_a("recipe_type", () -> IRecipeType.field_222149_a);
    public static final Registry<IRecipeSerializer<?>> field_218368_I = Registry.func_222935_a("recipe_serializer", () -> IRecipeSerializer.field_222158_b);
    public static final Registry<StatType<?>> field_212634_w = Registry.func_222935_a("stat_type", () -> Stats.field_75929_E);
    public static final DefaultedRegistry<IVillagerType> field_218369_K = Registry.func_222933_a("villager_type", "plains", () -> IVillagerType.field_221175_c);
    public static final DefaultedRegistry<VillagerProfession> field_218370_L = Registry.func_222933_a("villager_profession", "none", () -> VillagerProfession.field_221151_a);
    public static final DefaultedRegistry<PointOfInterestType> field_218371_M = Registry.func_222933_a("point_of_interest_type", "unemployed", () -> PointOfInterestType.field_221054_b);
    public static final DefaultedRegistry<MemoryModuleType<?>> field_218372_N = Registry.func_222933_a("memory_module_type", "dummy", () -> MemoryModuleType.field_220940_a);
    public static final DefaultedRegistry<SensorType<?>> field_218373_O = Registry.func_222933_a("sensor_type", "dummy", () -> SensorType.field_220997_a);
    public static final Registry<Schedule> field_218374_P = Registry.func_222935_a("schedule", () -> Schedule.field_221383_a);
    public static final Registry<Activity> field_218375_Q = Registry.func_222935_a("activity", () -> Activity.field_221366_b);

    private static <T> Registry<T> func_222935_a(String string, Supplier<T> supplier) {
        return Registry.func_222939_a(string, new SimpleRegistry(), supplier);
    }

    private static <T> DefaultedRegistry<T> func_222933_a(String string, String string2, Supplier<T> supplier) {
        return Registry.func_222939_a(string, new DefaultedRegistry(string2), supplier);
    }

    private static <T, R extends MutableRegistry<T>> R func_222939_a(String string, R r, Supplier<T> supplier) {
        ResourceLocation resourceLocation = new ResourceLocation(string);
        field_218376_a.put(resourceLocation, supplier);
        return field_212617_f.func_218381_a(resourceLocation, r);
    }

    @Nullable
    public abstract ResourceLocation func_177774_c(T var1);

    public abstract int func_148757_b(@Nullable T var1);

    @Nullable
    public abstract T func_82594_a(@Nullable ResourceLocation var1);

    public abstract Optional<T> func_218349_b(@Nullable ResourceLocation var1);

    public abstract Set<ResourceLocation> func_148742_b();

    @Nullable
    public abstract T func_186801_a(Random var1);

    public Stream<T> func_201756_e() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public static <T> T func_218325_a(Registry<? super T> registry, String string, T t) {
        return Registry.func_218322_a(registry, new ResourceLocation(string), t);
    }

    public static <T> T func_218322_a(Registry<? super T> registry, ResourceLocation resourceLocation, T t) {
        return ((MutableRegistry)registry).func_218381_a(resourceLocation, t);
    }

    public static <T> T func_218343_a(Registry<? super T> registry, int n, String string, T t) {
        return ((MutableRegistry)registry).func_218382_a(n, new ResourceLocation(string), t);
    }

    static {
        field_218376_a.entrySet().forEach(entry -> {
            if (((Supplier)entry.getValue()).get() == null) {
                field_212616_e.error("Unable to bootstrap registry '{}'", entry.getKey());
            }
        });
        field_212617_f.forEach(mutableRegistry -> {
            if (mutableRegistry.func_195866_d()) {
                field_212616_e.error("Registry '{}' was empty after loading", (Object)field_212617_f.func_177774_c((MutableRegistry<?>)mutableRegistry));
                if (SharedConstants.field_206244_b) {
                    throw new IllegalStateException("Registry: '" + field_212617_f.func_177774_c((MutableRegistry<?>)mutableRegistry) + "' is empty, not allowed, fix me!");
                }
            }
            if (mutableRegistry instanceof DefaultedRegistry) {
                ResourceLocation resourceLocation = ((DefaultedRegistry)mutableRegistry).func_212609_b();
                Validate.notNull(mutableRegistry.func_82594_a(resourceLocation), (String)("Missing default of DefaultedMappedRegistry: " + resourceLocation), (Object[])new Object[0]);
            }
        });
    }
}

