/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.mojang.datafixers.Dynamic;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.MineshaftConfig;
import net.minecraft.world.gen.feature.structure.MineshaftPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MineshaftStructure
extends Structure<MineshaftConfig> {
    public MineshaftStructure(Function<Dynamic<?>, ? extends MineshaftConfig> function) {
        super(function);
    }

    @Override
    public boolean func_202372_a(ChunkGenerator<?> chunkGenerator, Random random, int n, int n2) {
        ((SharedSeedRandom)random).func_202425_c(chunkGenerator.func_202089_c(), n, n2);
        Biome biome = chunkGenerator.func_202090_b().func_222364_a(new BlockPos((n << 4) + 9, 0, (n2 << 4) + 9));
        if (chunkGenerator.func_202094_a(biome, Feature.field_202329_g)) {
            MineshaftConfig mineshaftConfig = chunkGenerator.func_202087_b(biome, Feature.field_202329_g);
            double \u26032 = mineshaftConfig.field_202439_a;
            return random.nextDouble() < \u26032;
        }
        return false;
    }

    @Override
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    @Override
    public String func_143025_a() {
        return "Mineshaft";
    }

    @Override
    public int func_202367_b() {
        return 8;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int n, int n2, Biome biome, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, biome, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_214625_a(ChunkGenerator<?> chunkGenerator2, TemplateManager templateManager, int n, int n2, Biome biome) {
            MineshaftConfig mineshaftConfig = chunkGenerator2.func_202087_b(biome, Feature.field_202329_g);
            MineshaftPieces.Room \u26032 = new MineshaftPieces.Room(0, this.field_214631_d, (n << 4) + 2, (n2 << 4) + 2, mineshaftConfig.field_202440_b);
            this.field_75075_a.add(\u26032);
            \u26032.func_74861_a(\u26032, this.field_75075_a, this.field_214631_d);
            this.func_202500_a();
            if (mineshaftConfig.field_202440_b == Type.MESA) {
                int n3 = -5;
                \u2603 = chunkGenerator2.func_222530_f() - this.field_75074_b.field_78894_e + this.field_75074_b.func_78882_c() / 2 - -5;
                this.field_75074_b.func_78886_a(0, \u2603, 0);
                for (StructurePiece structurePiece : this.field_75075_a) {
                    structurePiece.func_181138_a(0, \u2603, 0);
                }
            } else {
                ChunkGenerator<?> chunkGenerator2;
                this.func_214628_a(chunkGenerator2.func_222530_f(), this.field_214631_d, 10);
            }
        }
    }

    public static enum Type {
        NORMAL("normal"),
        MESA("mesa");

        private static final Map<String, Type> field_214717_c;
        private final String field_214718_d;

        private Type(String string2) {
            this.field_214718_d = string2;
        }

        public String func_214714_a() {
            return this.field_214718_d;
        }

        public static Type func_214715_a(String string) {
            return field_214717_c.get(string);
        }

        public static Type func_189910_a(int n) {
            if (n < 0 || n >= Type.values().length) {
                return NORMAL;
            }
            return Type.values()[n];
        }

        static {
            field_214717_c = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::func_214714_a, type -> type));
        }
    }
}

