/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.BitSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.CanyonWorldCarver;
import net.minecraft.world.gen.carver.CaveWorldCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.NetherCaveWorldCarver;
import net.minecraft.world.gen.carver.UnderwaterCanyonWorldCarver;
import net.minecraft.world.gen.carver.UnderwaterCaveWorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public abstract class WorldCarver<C extends ICarverConfig> {
    public static final WorldCarver<ProbabilityConfig> field_222709_a = WorldCarver.func_222699_a("cave", new CaveWorldCarver((Function<Dynamic<?>, ? extends ProbabilityConfig>)((Function<Dynamic<?>, ProbabilityConfig>)ProbabilityConfig::func_214645_a), 256));
    public static final WorldCarver<ProbabilityConfig> field_222710_b = WorldCarver.func_222699_a("hell_cave", new NetherCaveWorldCarver(ProbabilityConfig::func_214645_a));
    public static final WorldCarver<ProbabilityConfig> field_222711_c = WorldCarver.func_222699_a("canyon", new CanyonWorldCarver(ProbabilityConfig::func_214645_a));
    public static final WorldCarver<ProbabilityConfig> field_222712_d = WorldCarver.func_222699_a("underwater_canyon", new UnderwaterCanyonWorldCarver(ProbabilityConfig::func_214645_a));
    public static final WorldCarver<ProbabilityConfig> field_222713_e = WorldCarver.func_222699_a("underwater_cave", new UnderwaterCaveWorldCarver(ProbabilityConfig::func_214645_a));
    protected static final BlockState field_222714_f = Blocks.field_150350_a.func_176223_P();
    protected static final BlockState field_222715_g = Blocks.field_201941_jj.func_176223_P();
    protected static final IFluidState field_222716_h = Fluids.field_204546_a.func_207188_f();
    protected static final IFluidState field_222717_i = Fluids.field_204547_b.func_207188_f();
    protected Set<Block> field_222718_j = ImmutableSet.of((Object)Blocks.field_150348_b, (Object)Blocks.field_196650_c, (Object)Blocks.field_196654_e, (Object)Blocks.field_196656_g, (Object)Blocks.field_150346_d, (Object)Blocks.field_196660_k, (Object[])new Block[]{Blocks.field_196661_l, Blocks.field_196658_i, Blocks.field_150405_ch, Blocks.field_196777_fo, Blocks.field_196778_fp, Blocks.field_196780_fq, Blocks.field_196782_fr, Blocks.field_196783_fs, Blocks.field_196785_ft, Blocks.field_196787_fu, Blocks.field_196789_fv, Blocks.field_196791_fw, Blocks.field_196793_fx, Blocks.field_196795_fy, Blocks.field_196797_fz, Blocks.field_196719_fA, Blocks.field_196720_fB, Blocks.field_196721_fC, Blocks.field_196722_fD, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150391_bh, Blocks.field_150433_aE, Blocks.field_150403_cj});
    protected Set<Fluid> field_222719_k = ImmutableSet.of((Object)Fluids.field_204546_a);
    private final Function<Dynamic<?>, ? extends C> field_222721_m;
    protected final int field_222720_l;

    private static <C extends ICarverConfig, F extends WorldCarver<C>> F func_222699_a(String string, F f) {
        return (F)Registry.func_218325_a(Registry.field_218377_o, string, f);
    }

    public WorldCarver(Function<Dynamic<?>, ? extends C> function, int n) {
        this.field_222721_m = function;
        this.field_222720_l = n;
    }

    public int func_222704_c() {
        return 4;
    }

    protected boolean func_222705_a(IChunk iChunk, long l, int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, BitSet bitSet) {
        Random random = new Random(l + (long)n2 + (long)n3);
        double \u26032 = n2 * 16 + 8;
        double \u26033 = n3 * 16 + 8;
        if (d < \u26032 - 16.0 - d4 * 2.0 || d3 < \u26033 - 16.0 - d4 * 2.0 || d > \u26032 + 16.0 + d4 * 2.0 || d3 > \u26033 + 16.0 + d4 * 2.0) {
            return false;
        }
        int \u26034 = Math.max(MathHelper.func_76128_c(d - d4) - n2 * 16 - 1, 0);
        if (this.func_222700_a(iChunk, n2, n3, \u26034, \u2603 = Math.min(MathHelper.func_76128_c(d + d4) - n2 * 16 + 1, 16), \u2603 = Math.max(MathHelper.func_76128_c(d2 - d5) - 1, 1), \u2603 = Math.min(MathHelper.func_76128_c(d2 + d5) + 1, this.field_222720_l - 8), \u2603 = Math.max(MathHelper.func_76128_c(d3 - d4) - n3 * 16 - 1, 0), \u2603 = Math.min(MathHelper.func_76128_c(d3 + d4) - n3 * 16 + 1, 16))) {
            return false;
        }
        boolean \u26035 = false;
        BlockPos.MutableBlockPos \u26036 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos \u26037 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos \u26038 = new BlockPos.MutableBlockPos();
        for (int i = \u26034; i < \u2603; ++i) {
            \u2603 = i + n2 * 16;
            double d6 = ((double)\u2603 + 0.5 - d) / d4;
            for (int j = \u2603; j < \u2603; ++j) {
                \u2603 = j + n3 * 16;
                double d7 = ((double)\u2603 + 0.5 - d3) / d4;
                if (d6 * d6 + d7 * d7 >= 1.0) continue;
                AtomicBoolean \u26039 = new AtomicBoolean(false);
                for (int k = \u2603; k > \u2603; --k) {
                    double d8 = ((double)k - 0.5 - d2) / d5;
                    if (this.func_222708_a(d6, d8, d7, k)) continue;
                    \u26035 |= this.func_222703_a(iChunk, bitSet, random, \u26036, \u26037, \u26038, n, n2, n3, \u2603, \u2603, i, k, j, \u26039);
                }
            }
        }
        return \u26035;
    }

    protected boolean func_222703_a(IChunk iChunk, BitSet bitSet, Random random, BlockPos.MutableBlockPos mutableBlockPos, BlockPos.MutableBlockPos mutableBlockPos2, BlockPos.MutableBlockPos mutableBlockPos3, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, AtomicBoolean atomicBoolean) {
        int n9 = n6 | n8 << 4 | n7 << 8;
        if (bitSet.get(n9)) {
            return false;
        }
        bitSet.set(n9);
        mutableBlockPos.func_181079_c(n4, n7, n5);
        BlockState \u26032 = iChunk.func_180495_p(mutableBlockPos);
        BlockState \u26033 = iChunk.func_180495_p(mutableBlockPos2.func_189533_g(mutableBlockPos).func_189536_c(Direction.UP));
        if (\u26032.func_177230_c() == Blocks.field_196658_i || \u26032.func_177230_c() == Blocks.field_150391_bh) {
            atomicBoolean.set(true);
        }
        if (!this.func_222707_a(\u26032, \u26033)) {
            return false;
        }
        if (n7 < 11) {
            iChunk.func_177436_a(mutableBlockPos, field_222717_i.func_206883_i(), false);
        } else {
            iChunk.func_177436_a(mutableBlockPos, field_222715_g, false);
            if (atomicBoolean.get()) {
                mutableBlockPos3.func_189533_g(mutableBlockPos).func_189536_c(Direction.DOWN);
                if (iChunk.func_180495_p(mutableBlockPos3).func_177230_c() == Blocks.field_150346_d) {
                    iChunk.func_177436_a(mutableBlockPos3, iChunk.func_217309_c(mutableBlockPos).func_203944_q().func_204108_a(), false);
                }
            }
        }
        return true;
    }

    public abstract boolean func_212867_a_(IChunk var1, Random var2, int var3, int var4, int var5, int var6, int var7, BitSet var8, C var9);

    public abstract boolean func_212868_a_(Random var1, int var2, int var3, C var4);

    protected boolean func_222706_a(BlockState blockState) {
        return this.field_222718_j.contains(blockState.func_177230_c());
    }

    protected boolean func_222707_a(BlockState blockState, BlockState blockState2) {
        Block block = blockState.func_177230_c();
        return this.func_222706_a(blockState) || (block == Blocks.field_150354_m || block == Blocks.field_150351_n) && !blockState2.func_204520_s().func_206884_a(FluidTags.field_206959_a);
    }

    protected boolean func_222700_a(IChunk iChunk, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = n3; i < n4; ++i) {
            for (\u2603 = n7; \u2603 < n8; ++\u2603) {
                for (\u2603 = n5 - 1; \u2603 <= n6 + 1; ++\u2603) {
                    if (this.field_222719_k.contains(iChunk.func_204610_c(mutableBlockPos.func_181079_c(i + n * 16, \u2603, \u2603 + n2 * 16)).func_206886_c())) {
                        return true;
                    }
                    if (\u2603 == n6 + 1 || this.func_222701_a(n3, n4, n7, n8, i, \u2603)) continue;
                    \u2603 = n6;
                }
            }
        }
        return false;
    }

    private boolean func_222701_a(int n, int n2, int n3, int n4, int n5, int n6) {
        return n5 == n || n5 == n2 - 1 || n6 == n3 || n6 == n4 - 1;
    }

    protected boolean func_222702_a(int n, int n2, double d, double d2, int n3, int n4, float f) {
        double d3 = n * 16 + 8;
        \u2603 = d - d3;
        \u2603 = n2 * 16 + 8;
        \u2603 = d2 - \u2603;
        \u2603 = n4 - n3;
        \u2603 = f + 2.0f + 16.0f;
        return \u2603 * \u2603 + \u2603 * \u2603 - \u2603 * \u2603 <= \u2603 * \u2603;
    }

    protected abstract boolean func_222708_a(double var1, double var3, double var5, int var7);
}

