/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class ArrowEntity
extends AbstractArrowEntity {
    private static final DataParameter<Integer> field_184559_f = EntityDataManager.func_187226_a(ArrowEntity.class, DataSerializers.field_187192_b);
    private Potion field_184560_g = Potions.field_185229_a;
    private final Set<EffectInstance> field_184561_h = Sets.newHashSet();
    private boolean field_191509_at;

    public ArrowEntity(EntityType<? extends ArrowEntity> entityType, World world) {
        super((EntityType<? extends AbstractArrowEntity>)entityType, world);
    }

    public ArrowEntity(World world, double d, double d2, double d3) {
        super(EntityType.field_200790_d, d, d2, d3, world);
    }

    public ArrowEntity(World world, LivingEntity livingEntity) {
        super(EntityType.field_200790_d, livingEntity, world);
    }

    public void func_184555_a(ItemStack itemStack2) {
        ItemStack itemStack2;
        if (itemStack2.func_77973_b() == Items.field_185167_i) {
            int n;
            this.field_184560_g = PotionUtils.func_185191_c(itemStack2);
            List<EffectInstance> list = PotionUtils.func_185190_b(itemStack2);
            if (!list.isEmpty()) {
                for (EffectInstance effectInstance : list) {
                    this.field_184561_h.add(new EffectInstance(effectInstance));
                }
            }
            if ((n = ArrowEntity.func_191508_b(itemStack2)) == -1) {
                this.func_190548_o();
            } else {
                this.func_191507_d(n);
            }
        } else if (itemStack2.func_77973_b() == Items.field_151032_g) {
            this.field_184560_g = Potions.field_185229_a;
            this.field_184561_h.clear();
            this.field_70180_af.func_187227_b(field_184559_f, -1);
        }
    }

    public static int func_191508_b(ItemStack itemStack) {
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        if (compoundNBT != null && compoundNBT.func_150297_b("CustomPotionColor", 99)) {
            return compoundNBT.func_74762_e("CustomPotionColor");
        }
        return -1;
    }

    private void func_190548_o() {
        this.field_191509_at = false;
        this.field_70180_af.func_187227_b(field_184559_f, PotionUtils.func_185181_a(PotionUtils.func_185186_a(this.field_184560_g, this.field_184561_h)));
    }

    public void func_184558_a(EffectInstance effectInstance) {
        this.field_184561_h.add(effectInstance);
        this.func_184212_Q().func_187227_b(field_184559_f, PotionUtils.func_185181_a(PotionUtils.func_185186_a(this.field_184560_g, this.field_184561_h)));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184559_f, -1);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.func_184556_b(1);
                }
            } else {
                this.func_184556_b(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && !this.field_184561_h.isEmpty() && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a(this, (byte)0);
            this.field_184560_g = Potions.field_185229_a;
            this.field_184561_h.clear();
            this.field_70180_af.func_187227_b(field_184559_f, -1);
        }
    }

    private void func_184556_b(int n) {
        \u2603 = this.func_184557_n();
        if (\u2603 == -1 || n <= 0) {
            return;
        }
        double d = (double)(\u2603 >> 16 & 0xFF) / 255.0;
        \u2603 = (double)(\u2603 >> 8 & 0xFF) / 255.0;
        \u2603 = (double)(\u2603 >> 0 & 0xFF) / 255.0;
        for (int i = 0; i < n; ++i) {
            this.field_70170_p.func_195594_a(ParticleTypes.field_197625_r, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg(), this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), d, \u2603, \u2603);
        }
    }

    public int func_184557_n() {
        return this.field_70180_af.func_187225_a(field_184559_f);
    }

    private void func_191507_d(int n) {
        this.field_191509_at = true;
        this.field_70180_af.func_187227_b(field_184559_f, n);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT2) {
        super.func_213281_b(compoundNBT2);
        if (this.field_184560_g != Potions.field_185229_a && this.field_184560_g != null) {
            compoundNBT2.func_74778_a("Potion", Registry.field_212621_j.func_177774_c(this.field_184560_g).toString());
        }
        if (this.field_191509_at) {
            compoundNBT2.func_74768_a("Color", this.func_184557_n());
        }
        if (!this.field_184561_h.isEmpty()) {
            CompoundNBT compoundNBT2;
            ListNBT listNBT = new ListNBT();
            for (EffectInstance effectInstance : this.field_184561_h) {
                listNBT.add(effectInstance.func_82719_a(new CompoundNBT()));
            }
            compoundNBT2.func_218657_a("CustomPotionEffects", listNBT);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        super.func_70037_a(compoundNBT2);
        if (compoundNBT2.func_150297_b("Potion", 8)) {
            this.field_184560_g = PotionUtils.func_185187_c(compoundNBT2);
        }
        for (EffectInstance effectInstance : PotionUtils.func_185192_b(compoundNBT2)) {
            this.func_184558_a(effectInstance);
        }
        if (compoundNBT2.func_150297_b("Color", 99)) {
            this.func_191507_d(compoundNBT2.func_74762_e("Color"));
        } else {
            this.func_190548_o();
        }
    }

    @Override
    protected void func_184548_a(LivingEntity livingEntity) {
        super.func_184548_a(livingEntity);
        for (EffectInstance effectInstance : this.field_184560_g.func_185170_a()) {
            livingEntity.func_195064_c(new EffectInstance(effectInstance.func_188419_a(), Math.max(effectInstance.func_76459_b() / 8, 1), effectInstance.func_76458_c(), effectInstance.func_82720_e(), effectInstance.func_188418_e()));
        }
        if (!this.field_184561_h.isEmpty()) {
            for (EffectInstance effectInstance : this.field_184561_h) {
                livingEntity.func_195064_c(effectInstance);
            }
        }
    }

    @Override
    protected ItemStack func_184550_j() {
        if (this.field_184561_h.isEmpty() && this.field_184560_g == Potions.field_185229_a) {
            return new ItemStack(Items.field_151032_g);
        }
        ItemStack itemStack = new ItemStack(Items.field_185167_i);
        PotionUtils.func_185188_a(itemStack, this.field_184560_g);
        PotionUtils.func_185184_a(itemStack, this.field_184561_h);
        if (this.field_191509_at) {
            itemStack.func_196082_o().func_74768_a("CustomPotionColor", this.func_184557_n());
        }
        return itemStack;
    }
}

