/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;

public class DefaultModInfos {
    public static final IModInfo minecraftModInfo;

    private DefaultModInfos() {
    }

    public static List<IModInfo> getModInfos() {
        return Arrays.asList(minecraftModInfo);
    }

    static {
        FileConfig minecraftmod;
        try {
            URI jarFileURI = DefaultModInfos.class.getClassLoader().getResource("minecraftmod.toml").toURI();
            if (Objects.equals(jarFileURI.getScheme(), "jar")) {
                FileSystems.newFileSystem(jarFileURI, new HashMap());
            }
            minecraftmod = FileConfig.of((Path)Paths.get(jarFileURI));
            minecraftmod.load();
        }
        catch (IOException | NullPointerException | URISyntaxException e) {
            throw new RuntimeException("Missing toml config for minecraft!", e);
        }
        minecraftModInfo = new ModInfo(null, (UnmodifiableConfig)minecraftmod);
    }
}

