/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import cpw.mods.modlauncher.ServiceLoaderStreamUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.ModSorter;
import net.minecraftforge.fml.loading.moddiscovery.BackgroundScanHandler;
import net.minecraftforge.fml.loading.moddiscovery.IModLocator;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ModDiscoverer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServiceLoader<IModLocator> locators;
    private final List<IModLocator> locatorList;

    public ModDiscoverer(Map<String, ?> arguments) {
        this.locators = ServiceLoader.load(IModLocator.class);
        this.locatorList = ServiceLoaderStreamUtils.toList(this.locators);
        this.locatorList.forEach(l -> l.initArguments(arguments));
        LOGGER.debug(LogMarkers.CORE, "Found Mod Locators : {}", new Supplier[]{() -> this.locatorList.stream().map(iModLocator -> "(" + iModLocator.name() + ":" + iModLocator.getClass().getPackage().getImplementationVersion() + ")").collect(Collectors.joining(","))});
    }

    ModDiscoverer(List<IModLocator> locatorList) {
        this.locatorList = locatorList;
        this.locators = null;
    }

    public BackgroundScanHandler discoverMods() {
        LOGGER.debug(LogMarkers.SCAN, "Scanning for mods and other resources to load. We know {} ways to find mods", (Object)this.locatorList.size());
        Map<ModFile.Type, List<ModFile>> modFiles = this.locatorList.stream().peek(loc -> LOGGER.debug(LogMarkers.SCAN, "Trying locator {}", loc)).map(IModLocator::scanMods).flatMap(Collection::stream).peek(mf -> LOGGER.debug(LogMarkers.SCAN, "Found mod file {} of type {} with locator {}", (Object)mf.getFileName(), (Object)mf.getType(), (Object)mf.getLocator())).collect(Collectors.groupingBy(ModFile::getType));
        FMLLoader.getLanguageLoadingProvider().addAdditionalLanguages(modFiles.get((Object)ModFile.Type.LANGPROVIDER));
        BackgroundScanHandler backgroundScanHandler = new BackgroundScanHandler();
        List<ModFile> mods = modFiles.getOrDefault((Object)ModFile.Type.MOD, Collections.emptyList());
        ArrayList<ModFile> brokenFiles = new ArrayList<ModFile>();
        Iterator iterator = mods.iterator();
        while (iterator.hasNext()) {
            ModFile mod = (ModFile)iterator.next();
            if (mod.getLocator().isValid(mod) && mod.identifyMods()) continue;
            LOGGER.warn(LogMarkers.SCAN, "File {} has been ignored - it is invalid", (Object)mod.getFilePath());
            iterator.remove();
            brokenFiles.add(mod);
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = mods::size;
        supplierArray[1] = () -> mods.stream().mapToInt(mf -> mf.getModInfos().size()).sum();
        LOGGER.debug(LogMarkers.SCAN, "Found {} mod files with {} mods", supplierArray);
        LoadingModList loadingModList = ModSorter.sort(mods);
        loadingModList.addCoreMods();
        loadingModList.addAccessTransformers();
        loadingModList.addForScanning(backgroundScanHandler);
        loadingModList.setBrokenFiles(brokenFiles);
        return backgroundScanHandler;
    }

    public void addExplodedTarget(Path compiledClasses, Path forgemodstoml) {
    }
}

