/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.progress;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraftforge.fml.SidedProvider;
import net.minecraftforge.fml.common.progress.ProgressBar;
import net.minecraftforge.fml.common.progress.StartupProgressBarTracker;

public class StartupProgressManager {
    private static final Function<String, String> stripChars = (Function)SidedProvider.STRIPCHARS.get();

    public static void start(String title, int steps, Consumer<ProgressBar> task) {
        StartupProgressManager.start(title, steps, false, task);
    }

    public static void start(String title, int steps, boolean timeEachStep, Consumer<ProgressBar> task) {
        try (ProgressBar bar = StartupProgressManager.start(title, steps, timeEachStep);){
            task.accept(bar);
        }
    }

    public static ProgressBar start(String title, int steps) {
        return StartupProgressManager.start(title, steps, false);
    }

    public static ProgressBar start(String title, int steps, boolean timeEachStep) {
        StartupProgressBarTracker tracker = new StartupProgressBarTracker(timeEachStep, steps);
        return new ProgressBar(title, steps, stripChars, tracker);
    }

    public static Iterator<ProgressBar> barIterator() {
        return StartupProgressBarTracker.barIterator();
    }
}

