/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.progress;

import java.util.function.Function;
import net.minecraftforge.fml.common.ClassNameUtils;
import net.minecraftforge.fml.common.progress.IProgressBarTracker;
import org.apache.commons.lang3.tuple.Pair;

public final class ProgressBar
implements AutoCloseable {
    private final String title;
    private final int totalSteps;
    private final Function<String, String> stripChars;
    private final IProgressBarTracker tracker;
    private volatile int step = 0;
    private volatile String message = "";

    public ProgressBar(String title, int totalSteps, Function<String, String> stripChars, IProgressBarTracker tracker) {
        this.title = title;
        this.totalSteps = totalSteps;
        this.stripChars = stripChars;
        this.tracker = tracker;
        this.tracker.onBarCreated(this);
    }

    public void step(Class<?> classToName, String ... extra) {
        this.step(ClassNameUtils.shortName(classToName) + String.join((CharSequence)" ", extra));
    }

    public synchronized void step(String newMessage) {
        if (this.step > 0) {
            this.tracker.onStepFinished(this, this.step, this.message);
        }
        ++this.step;
        this.message = this.stripChars.apply(newMessage);
        this.tracker.onStepStarted(this, this.step, this.message);
    }

    public synchronized Pair<Integer, String> getStepAndMessage() {
        return Pair.of((Object)this.step, (Object)this.message);
    }

    public int getTotalSteps() {
        return this.totalSteps;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public synchronized void close() {
        if (this.step > 0) {
            this.tracker.onStepFinished(this, this.step, this.message);
        }
        this.tracker.onBarFinished(this, this.step, this.message);
    }
}

