/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.LifecycleEventProvider;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModList {
    private static Logger LOGGER = LogManager.getLogger();
    private static ModList INSTANCE;
    private final List<ModFileInfo> modFiles;
    private final List<ModInfo> sortedList;
    private final Map<String, ModFileInfo> fileById;
    private List<ModContainer> mods;
    private Map<String, ModContainer> indexedMods;
    private ForkJoinPool modLoadingThreadPool;
    private List<ModFileScanData> modFileScanData;
    static BiConsumer<LifecycleEventProvider.LifecycleEvent, Consumer<List<ModLoadingException>>> inlineDispatcher;
    static BiConsumer<LifecycleEventProvider.LifecycleEvent, Consumer<List<ModLoadingException>>> parallelDispatcher;

    private ModList(List<ModFile> modFiles, List<ModInfo> sortedList) {
        this.modFiles = modFiles.stream().map(ModFile::getModFileInfo).map(ModFileInfo.class::cast).collect(Collectors.toList());
        this.sortedList = sortedList.stream().map(ModInfo.class::cast).collect(Collectors.toList());
        this.fileById = this.modFiles.stream().map(ModFileInfo::getMods).flatMap(Collection::stream).map(ModInfo.class::cast).collect(Collectors.toMap(ModInfo::getModId, ModInfo::getOwningFile));
        int loadingThreadCount = FMLConfig.loadingThreadCount();
        LOGGER.debug(Logging.LOADING, "Using {} threads for parallel mod-loading", (Object)loadingThreadCount);
        this.modLoadingThreadPool = new ForkJoinPool(loadingThreadCount, ModList::newForkJoinWorkerThread, null, false);
    }

    public static ModList of(List<ModFile> modFiles, List<ModInfo> sortedList) {
        INSTANCE = new ModList(modFiles, sortedList);
        return INSTANCE;
    }

    public static ModList get() {
        return INSTANCE;
    }

    private static ForkJoinWorkerThread newForkJoinWorkerThread(ForkJoinPool pool) {
        ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
        thread.setName("modloading-worker-" + thread.getPoolIndex());
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        return thread;
    }

    public List<ModFileInfo> getModFiles() {
        return this.modFiles;
    }

    public ModFileInfo getModFileById(String modid) {
        return this.fileById.get(modid);
    }

    private void dispatchSynchronousEvent(LifecycleEventProvider.LifecycleEvent lifecycleEvent, Consumer<List<ModLoadingException>> errorHandler) {
        LOGGER.debug(Logging.LOADING, "Dispatching synchronous event {}", (Object)lifecycleEvent);
        FMLLoader.getLanguageLoadingProvider().forEach(lp -> lp.consumeLifecycleEvent(() -> lifecycleEvent));
        this.mods.forEach(m -> m.transitionState(lifecycleEvent, errorHandler));
        FMLLoader.getLanguageLoadingProvider().forEach(lp -> lp.consumeLifecycleEvent(() -> lifecycleEvent));
    }

    private void dispatchParallelEvent(LifecycleEventProvider.LifecycleEvent lifecycleEvent, Consumer<List<ModLoadingException>> errorHandler) {
        LOGGER.debug(Logging.LOADING, "Dispatching parallel event {}", (Object)lifecycleEvent);
        FMLLoader.getLanguageLoadingProvider().forEach(lp -> lp.consumeLifecycleEvent(() -> lifecycleEvent));
        DeferredWorkQueue.clear();
        try {
            ((ForkJoinTask)this.modLoadingThreadPool.submit(() -> this.mods.parallelStream().forEach(m -> m.transitionState(lifecycleEvent, errorHandler)))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error(Logging.LOADING, "Encountered an exception during parallel processing", (Throwable)e);
        }
        DeferredWorkQueue.runTasks(lifecycleEvent.fromStage(), errorHandler);
        FMLLoader.getLanguageLoadingProvider().forEach(lp -> lp.consumeLifecycleEvent(() -> lifecycleEvent));
    }

    void setLoadedMods(List<ModContainer> modContainers) {
        this.mods = modContainers;
        this.indexedMods = modContainers.stream().collect(Collectors.toMap(ModContainer::getModId, Function.identity()));
    }

    public <T> Optional<T> getModObjectById(String modId) {
        return this.getModContainerById(modId).map(ModContainer::getMod).map(o -> o);
    }

    public Optional<? extends ModContainer> getModContainerById(String modId) {
        return Optional.ofNullable(this.indexedMods.get(modId));
    }

    public Optional<? extends ModContainer> getModContainerByObject(Object obj) {
        return this.mods.stream().filter(mc -> mc.getMod() == obj).findFirst();
    }

    public List<ModInfo> getMods() {
        return this.sortedList;
    }

    public boolean isLoaded(String modTarget) {
        return this.indexedMods.containsKey(modTarget);
    }

    public int size() {
        return this.mods.size();
    }

    public List<ModFileScanData> getAllScanData() {
        if (this.modFileScanData == null) {
            this.modFileScanData = this.sortedList.stream().map(ModInfo::getOwningFile).filter(Objects::nonNull).map(ModFileInfo::getFile).map(ModFile::getScanResult).collect(Collectors.toList());
        }
        return this.modFileScanData;
    }

    public void forEachModFile(Consumer<ModFile> fileConsumer) {
        this.modFiles.stream().map(ModFileInfo::getFile).forEach(fileConsumer);
    }

    public void forEachModContainer(BiConsumer<String, ModContainer> modContainerConsumer) {
        this.indexedMods.forEach(modContainerConsumer);
    }

    static {
        inlineDispatcher = (event, errors) -> ModList.get().dispatchSynchronousEvent((LifecycleEventProvider.LifecycleEvent)event, (Consumer<List<ModLoadingException>>)errors);
        parallelDispatcher = (event, errors) -> ModList.get().dispatchParallelEvent((LifecycleEventProvider.LifecycleEvent)event, (Consumer<List<ModLoadingException>>)errors);
    }
}

