/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.RecipeType;

public abstract class ForgeRecipeManager
implements IResourceManagerReloadListener {
    protected final Map<RecipeType<? extends IRecipe>, List<? extends IRecipe>> sortedRecipes = Maps.newHashMap();

    public void func_195410_a(IResourceManager resourceManager) {
        this.sortedRecipes.clear();
        CraftingHelper.reloadConstants(resourceManager);
    }

    public <T extends IRecipe> List<T> getRecipes(RecipeType<T> type) {
        return this.sortedRecipes.computeIfAbsent(type, t -> new ArrayList());
    }

    public ItemStack getResult(IInventory input, World world, RecipeType<?> type) {
        for (IRecipe irecipe : this.getRecipes(type)) {
            if (!irecipe.func_77569_a(input, world)) continue;
            return irecipe.func_77572_b(input);
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public <T extends IRecipe> T getRecipe(IInventory input, World world, RecipeType<T> type) {
        for (IRecipe irecipe : this.getRecipes(type)) {
            if (!irecipe.func_77569_a(input, world)) continue;
            return (T)irecipe;
        }
        return null;
    }

    @Deprecated
    public NonNullList<ItemStack> getRemainingItems(IInventory input, World world, RecipeType<?> type) {
        for (IRecipe irecipe : this.getRecipes(type)) {
            if (!irecipe.func_77569_a(input, world)) continue;
            return irecipe.func_179532_b(input);
        }
        NonNullList nonnulllist = NonNullList.func_191197_a((int)input.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)input.func_70301_a(i));
        }
        return nonnulllist;
    }
}

