/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;

public class RecipeType<T extends IRecipe> {
    private static final Map<ResourceLocation, RecipeType<?>> TYPES = new HashMap();
    protected final ResourceLocation id;
    protected final Class<? extends T> baseClass;

    private RecipeType(ResourceLocation id, Class<? extends T> baseClass) {
        this.id = id;
        this.baseClass = baseClass;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Class<? extends T> getBaseClass() {
        return this.baseClass;
    }

    @Nullable
    public static <T extends IRecipe> RecipeType<T> get(ResourceLocation id, Class<? extends T> baseClass) {
        RecipeType<Object> type = TYPES.get(id);
        if (type == null) {
            type = new RecipeType<T>(id, baseClass);
            TYPES.put(id, type);
        } else if (type.getBaseClass() != baseClass) {
            LogManager.getLogger().error("Attempted to access RecipeType {} with the wrong base class. Provided {}, expected {}.");
            return null;
        }
        return type;
    }
}

