/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.animation;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.chunk.RenderChunkCache;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.client.model.animation.TileEntityRendererFast;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.IEventHandler;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityRendererAnimation<T extends TileEntity>
extends TileEntityRendererFast<T>
implements IEventHandler<T> {
    protected static BlockRendererDispatcher blockRenderer;

    @Override
    public void renderTileEntityFast(T te, double x, double y, double z, float partialTick, int breakStage, BufferBuilder renderer) {
        LazyOptional cap = te.getCapability(CapabilityAnimation.ANIMATION_CAPABILITY);
        if (!cap.isPresent()) {
            return;
        }
        if (blockRenderer == null) {
            blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        }
        BlockPos pos = te.func_174877_v();
        RenderChunkCache world = MinecraftForgeClient.getRegionRenderCache(te.func_145831_w(), pos);
        IBlockState state = world.func_180495_p(pos);
        IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
        IModelData data = model.getModelData((IWorldReader)world, pos, state, ModelDataManager.getModelData(te.func_145831_w(), pos));
        if (data.hasProperty(Properties.AnimationProperty)) {
            float time = Animation.getWorldTime(this.func_178459_a(), partialTick);
            cap.map(asm -> asm.apply(time)).ifPresent(arg_0 -> this.lambda$renderTileEntityFast$1(te, time, data, renderer, x, pos, y, z, (IWorldReader)world, model, state, arg_0));
        }
    }

    @Override
    public void handleEvents(T te, float time, Iterable<Event> pastEvents) {
    }

    private /* synthetic */ void lambda$renderTileEntityFast$1(TileEntity te, float time, IModelData data, BufferBuilder renderer, double x, BlockPos pos, double y, double z, IWorldReader world, IBakedModel model, IBlockState state, Pair pair) {
        this.handleEvents(te, time, (Iterable<Event>)((Iterable)pair.getRight()));
        data.setData(Properties.AnimationProperty, pair.getLeft());
        renderer.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
        blockRenderer.func_175019_b().renderModel(world, model, state, pos, renderer, false, new Random(), 42L, data);
    }
}

