/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.chunk.RenderChunkCache;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.tuple.Pair;

public class MinecraftForgeClient {
    private static BitSet stencilBits = new BitSet(8);
    private static final LoadingCache<Pair<World, BlockPos>, RenderChunkCache> regionCache;
    private static HashMap<ResourceLocation, Supplier<NativeImage>> bufferedImageSuppliers;

    public static int getRenderPass() {
        return ForgeHooksClient.renderPass;
    }

    public static BlockRenderLayer getRenderLayer() {
        return ForgeHooksClient.renderLayer.get();
    }

    public static Locale getLocale() {
        return Minecraft.func_71410_x().func_135016_M().func_135041_c().getJavaLocale();
    }

    public static int reserveStencilBit() {
        int bit = stencilBits.nextSetBit(0);
        if (bit >= 0) {
            stencilBits.clear(bit);
        }
        return bit;
    }

    public static void releaseStencilBit(int bit) {
        if (bit >= 0 && bit < stencilBits.length()) {
            stencilBits.set(bit);
        }
    }

    public static void onRebuildChunk(World world, BlockPos position, RenderChunkCache cache) {
        if (cache == null) {
            regionCache.invalidate((Object)Pair.of((Object)world, (Object)position));
        } else {
            regionCache.put((Object)Pair.of((Object)world, (Object)position), (Object)cache);
        }
    }

    public static RenderChunkCache getRegionRenderCache(World world, BlockPos pos) {
        int x = pos.func_177958_n() & 0xFFFFFFF0;
        int y = pos.func_177956_o() & 0xFFFFFFF0;
        int z = pos.func_177952_p() & 0xFFFFFFF0;
        return (RenderChunkCache)regionCache.getUnchecked((Object)Pair.of((Object)world, (Object)new BlockPos(x, y, z)));
    }

    public static void clearRenderCache() {
        regionCache.invalidateAll();
        regionCache.cleanUp();
    }

    public static void registerImageLayerSupplier(ResourceLocation resourceLocation, Supplier<NativeImage> supplier) {
        bufferedImageSuppliers.put(resourceLocation, supplier);
    }

    @Nonnull
    public static NativeImage getImageLayer(ResourceLocation resourceLocation, IResourceManager resourceManager) throws IOException {
        Supplier<NativeImage> supplier = bufferedImageSuppliers.get(resourceLocation);
        if (supplier != null) {
            return supplier.get();
        }
        IResource iresource1 = resourceManager.func_199002_a(resourceLocation);
        return NativeImage.func_195713_a((InputStream)iresource1.func_199027_b());
    }

    static {
        stencilBits.set(0, 8);
        regionCache = CacheBuilder.newBuilder().maximumSize(500L).concurrencyLevel(5).expireAfterAccess(1L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Pair<World, BlockPos>, RenderChunkCache>(){

            public RenderChunkCache load(Pair<World, BlockPos> key) {
                return RenderChunkCache.func_212397_a((World)((World)key.getLeft()), (BlockPos)((BlockPos)key.getRight()).func_177982_a(-1, -1, -1), (BlockPos)((BlockPos)key.getRight()).func_177982_a(16, 16, 16), (int)1);
            }
        });
        bufferedImageSuppliers = new HashMap();
    }
}

