/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnchantRandomly
extends LootFunction {
    private static final Logger field_186557_a = LogManager.getLogger();
    private final List<Enchantment> field_186558_b;

    public EnchantRandomly(LootCondition[] lootConditionArray, @Nullable List<Enchantment> list) {
        super(lootConditionArray);
        this.field_186558_b = list == null ? Collections.emptyList() : list;
    }

    @Override
    public ItemStack func_186553_a(ItemStack itemStack2, Random random, LootContext lootContext) {
        ItemStack itemStack2;
        Enchantment \u26032;
        if (this.field_186558_b.isEmpty()) {
            ArrayList arrayList = Lists.newArrayList();
            for (Enchantment enchantment : IRegistry.field_212628_q) {
                if (itemStack2.func_77973_b() != Items.field_151122_aG && !enchantment.func_92089_a(itemStack2)) continue;
                arrayList.add(enchantment);
            }
            if (arrayList.isEmpty()) {
                field_186557_a.warn("Couldn't find a compatible enchantment for {}", (Object)itemStack2);
                return itemStack2;
            }
            \u26032 = (Enchantment)arrayList.get(random.nextInt(arrayList.size()));
        } else {
            \u26032 = this.field_186558_b.get(random.nextInt(this.field_186558_b.size()));
        }
        int n = MathHelper.func_76136_a(random, \u26032.func_77319_d(), \u26032.func_77325_b());
        if (itemStack2.func_77973_b() == Items.field_151122_aG) {
            itemStack2 = new ItemStack(Items.field_151134_bR);
            ItemEnchantedBook.func_92115_a(itemStack2, new EnchantmentData(\u26032, n));
        } else {
            itemStack2.func_77966_a(\u26032, n);
        }
        return itemStack2;
    }

    public static class Serializer
    extends LootFunction.Serializer<EnchantRandomly> {
        public Serializer() {
            super(new ResourceLocation("enchant_randomly"), EnchantRandomly.class);
        }

        @Override
        public void func_186532_a(JsonObject jsonObject2, EnchantRandomly enchantRandomly, JsonSerializationContext jsonSerializationContext) {
            if (!enchantRandomly.field_186558_b.isEmpty()) {
                JsonObject jsonObject2;
                JsonArray jsonArray = new JsonArray();
                for (Enchantment enchantment : enchantRandomly.field_186558_b) {
                    ResourceLocation resourceLocation = IRegistry.field_212628_q.func_177774_c(enchantment);
                    if (resourceLocation == null) {
                        throw new IllegalArgumentException("Don't know how to serialize enchantment " + enchantment);
                    }
                    jsonArray.add((JsonElement)new JsonPrimitive(resourceLocation.toString()));
                }
                jsonObject2.add("enchantments", (JsonElement)jsonArray);
            }
        }

        @Override
        public EnchantRandomly func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootCondition[] lootConditionArray) {
            ArrayList arrayList = Lists.newArrayList();
            if (jsonObject.has("enchantments")) {
                JsonArray jsonArray = JsonUtils.func_151214_t(jsonObject, "enchantments");
                for (JsonElement jsonElement : jsonArray) {
                    String string = JsonUtils.func_151206_a(jsonElement, "enchantment");
                    Enchantment \u26032 = IRegistry.field_212628_q.func_212608_b(new ResourceLocation(string));
                    if (\u26032 == null) {
                        throw new JsonSyntaxException("Unknown enchantment '" + string + "'");
                    }
                    arrayList.add(\u26032);
                }
            }
            return new EnchantRandomly(lootConditionArray, arrayList);
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootCondition[] lootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, lootConditionArray);
        }
    }
}

