/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.conditions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.EntityHasProperty;
import net.minecraft.world.storage.loot.conditions.EntityHasScore;
import net.minecraft.world.storage.loot.conditions.KilledByPlayer;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;

public class LootConditionManager {
    private static final Map<ResourceLocation, LootCondition.Serializer<?>> field_186642_a = Maps.newHashMap();
    private static final Map<Class<? extends LootCondition>, LootCondition.Serializer<?>> field_186643_b = Maps.newHashMap();

    public static <T extends LootCondition> void func_186639_a(LootCondition.Serializer<? extends T> serializer) {
        ResourceLocation resourceLocation = serializer.func_186602_a();
        Class<T> \u26032 = serializer.func_186604_b();
        if (field_186642_a.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("Can't re-register item condition name " + resourceLocation);
        }
        if (field_186643_b.containsKey(\u26032)) {
            throw new IllegalArgumentException("Can't re-register item condition class " + \u26032.getName());
        }
        field_186642_a.put(resourceLocation, serializer);
        field_186643_b.put(\u26032, serializer);
    }

    public static boolean func_186638_a(@Nullable LootCondition[] lootConditionArray, Random random, LootContext lootContext) {
        if (lootConditionArray == null) {
            return true;
        }
        for (LootCondition lootCondition : lootConditionArray) {
            if (lootCondition.func_186618_a(random, lootContext)) continue;
            return false;
        }
        return true;
    }

    public static LootCondition.Serializer<?> func_186641_a(ResourceLocation resourceLocation) {
        LootCondition.Serializer<?> serializer = field_186642_a.get(resourceLocation);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown loot item condition '" + resourceLocation + "'");
        }
        return serializer;
    }

    public static <T extends LootCondition> LootCondition.Serializer<T> func_186640_a(T t) {
        LootCondition.Serializer<?> serializer = field_186643_b.get(t.getClass());
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown loot item condition " + t);
        }
        return serializer;
    }

    static {
        LootConditionManager.func_186639_a(new RandomChance.Serializer());
        LootConditionManager.func_186639_a(new RandomChanceWithLooting.Serializer());
        LootConditionManager.func_186639_a(new EntityHasProperty.Serializer());
        LootConditionManager.func_186639_a(new KilledByPlayer.Serializer());
        LootConditionManager.func_186639_a(new EntityHasScore.Serializer());
    }

    public static class Serializer
    implements JsonDeserializer<LootCondition>,
    JsonSerializer<LootCondition> {
        public LootCondition deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.func_151210_l(jsonElement, "condition");
            ResourceLocation \u26032 = new ResourceLocation(JsonUtils.func_151200_h(jsonObject, "condition"));
            try {
                LootCondition.Serializer<?> serializer = LootConditionManager.func_186641_a(\u26032);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonSyntaxException("Unknown condition '" + \u26032 + "'");
            }
            return serializer.func_186603_b(jsonObject, jsonDeserializationContext);
        }

        public JsonElement serialize(LootCondition lootCondition, Type type, JsonSerializationContext jsonSerializationContext) {
            LootCondition.Serializer<LootCondition> serializer = LootConditionManager.func_186640_a(lootCondition);
            JsonObject \u26032 = new JsonObject();
            serializer.func_186605_a(\u26032, lootCondition, jsonSerializationContext);
            \u26032.addProperty("condition", serializer.func_186602_a().toString());
            return \u26032;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((LootCondition)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

