/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Structure<C extends IFeatureConfig>
extends Feature<C> {
    private static final Logger field_208204_b = LogManager.getLogger();
    public static final StructureStart field_202376_c = new StructureStart(){

        @Override
        public boolean func_75069_d() {
            return false;
        }
    };

    @Override
    public boolean func_212245_a(IWorld iWorld, IChunkGenerator<? extends IChunkGenSettings> iChunkGenerator, Random random, BlockPos blockPos, C c) {
        if (!this.func_202365_a(iWorld)) {
            return false;
        }
        int n = this.func_202367_b();
        \u2603 = blockPos.func_177958_n() >> 4;
        \u2603 = blockPos.func_177952_p() >> 4;
        \u2603 = \u2603 << 4;
        \u2603 = \u2603 << 4;
        long \u26032 = ChunkPos.func_77272_a(\u2603, \u2603);
        boolean \u26033 = false;
        for (\u2603 = \u2603 - n; \u2603 <= \u2603 + n; ++\u2603) {
            for (\u2603 = \u2603 - n; \u2603 <= \u2603 + n; ++\u2603) {
                long l2 = ChunkPos.func_77272_a(\u2603, \u2603);
                StructureStart \u26034 = this.func_202373_a(iWorld, iChunkGenerator, (SharedSeedRandom)random, l2);
                if (\u26034 == field_202376_c || !\u26034.func_75071_a().func_78885_a(\u2603, \u2603, \u2603 + 15, \u2603 + 15)) continue;
                ((LongSet)iChunkGenerator.func_203223_b(this).computeIfAbsent(\u26032, l -> new LongOpenHashSet())).add(l2);
                iWorld.func_72863_F().func_201713_d(\u2603, \u2603, true).func_201583_a(this.func_143025_a(), l2);
                \u26034.func_75068_a(iWorld, random, new MutableBoundingBox(\u2603, \u2603, \u2603 + 15, \u2603 + 15), new ChunkPos(\u2603, \u2603));
                \u26034.func_175787_b(new ChunkPos(\u2603, \u2603));
                \u26033 = true;
            }
        }
        return \u26033;
    }

    protected StructureStart func_202364_a(IWorld iWorld, BlockPos blockPos) {
        List<StructureStart> list = this.func_202371_a(iWorld, blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
        for (StructureStart structureStart : list) {
            if (!structureStart.func_75069_d() || !structureStart.func_75071_a().func_175898_b(blockPos)) continue;
            for (StructurePiece structurePiece : structureStart.func_186161_c()) {
                if (!structurePiece.func_74874_b().func_175898_b(blockPos)) continue;
                return structureStart;
            }
        }
        return field_202376_c;
    }

    public boolean func_175796_a(IWorld iWorld, BlockPos blockPos) {
        List<StructureStart> list = this.func_202371_a(iWorld, blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
        for (StructureStart structureStart : list) {
            if (!structureStart.func_75069_d() || !structureStart.func_75071_a().func_175898_b(blockPos)) continue;
            return true;
        }
        return false;
    }

    public boolean func_202366_b(IWorld iWorld, BlockPos blockPos) {
        return this.func_202364_a(iWorld, blockPos).func_75069_d();
    }

    @Nullable
    public BlockPos func_211405_a(World world, IChunkGenerator<? extends IChunkGenSettings> iChunkGenerator, BlockPos blockPos, int n, boolean bl) {
        if (!iChunkGenerator.func_202090_b().func_205004_a(this)) {
            return null;
        }
        int n2 = blockPos.func_177958_n() >> 4;
        \u2603 = blockPos.func_177952_p() >> 4;
        SharedSeedRandom \u26032 = new SharedSeedRandom();
        block0: for (\u2603 = 0; \u2603 <= n; ++\u2603) {
            for (\u2603 = -\u2603; \u2603 <= \u2603; ++\u2603) {
                boolean bl2 = \u2603 == -\u2603 || \u2603 == \u2603;
                for (int i = -\u2603; i <= \u2603; ++i) {
                    boolean bl3 = \u2603 = i == -\u2603 || i == \u2603;
                    if (!bl2 && !\u2603) continue;
                    ChunkPos chunkPos = this.func_211744_a(iChunkGenerator, \u26032, n2, \u2603, \u2603, i);
                    StructureStart \u26033 = this.func_202373_a(world, iChunkGenerator, \u26032, chunkPos.func_201841_a());
                    if (\u26033 != field_202376_c) {
                        if (bl && \u26033.func_212687_g()) {
                            \u26033.func_212685_h();
                            return \u26033.func_204294_a();
                        }
                        if (!bl) {
                            return \u26033.func_204294_a();
                        }
                    }
                    if (\u2603 == 0) break;
                }
                if (\u2603 == 0) continue block0;
            }
        }
        return null;
    }

    private List<StructureStart> func_202371_a(IWorld iWorld, int n, int n2) {
        ArrayList arrayList = Lists.newArrayList();
        Long2ObjectMap<StructureStart> \u26032 = iWorld.func_72863_F().func_201711_g().func_203224_a(this);
        Long2ObjectMap<LongSet> \u26033 = iWorld.func_72863_F().func_201711_g().func_203223_b(this);
        LongSet \u26034 = (LongSet)\u26033.get(\u2603 = ChunkPos.func_77272_a(n, n2));
        if (\u26034 == null) {
            \u26034 = iWorld.func_72863_F().func_201713_d(n, n2, true).func_201578_b(this.func_143025_a());
            \u26033.put(\u2603, (Object)\u26034);
        }
        for (Long l : \u26034) {
            StructureStart structureStart = (StructureStart)\u26032.get((Object)l);
            if (structureStart != null) {
                arrayList.add(structureStart);
                continue;
            }
            ChunkPos \u26035 = new ChunkPos(l);
            IChunk \u26036 = iWorld.func_72863_F().func_201713_d(\u26035.field_77276_a, \u26035.field_77275_b, true);
            structureStart = \u26036.func_201585_a(this.func_143025_a());
            if (structureStart == null) continue;
            \u26032.put(l, (Object)structureStart);
            arrayList.add(structureStart);
        }
        return arrayList;
    }

    private StructureStart func_202373_a(IWorld iWorld, IChunkGenerator<? extends IChunkGenSettings> iChunkGenerator, SharedSeedRandom sharedSeedRandom, long l) {
        if (!iChunkGenerator.func_202090_b().func_205004_a(this)) {
            return field_202376_c;
        }
        Long2ObjectMap<StructureStart> long2ObjectMap = iChunkGenerator.func_203224_a(this);
        StructureStart \u26032 = (StructureStart)long2ObjectMap.get(l);
        if (\u26032 != null) {
            return \u26032;
        }
        ChunkPos \u26033 = new ChunkPos(l);
        IChunk \u26034 = iWorld.func_72863_F().func_201713_d(\u26033.field_77276_a, \u26033.field_77275_b, false);
        if (\u26034 != null && (\u26032 = \u26034.func_201585_a(this.func_143025_a())) != null) {
            long2ObjectMap.put(l, (Object)\u26032);
            return \u26032;
        }
        \u26032 = this.func_202372_a(iChunkGenerator, sharedSeedRandom, \u26033.field_77276_a, \u26033.field_77275_b) ? ((\u2603 = this.func_202369_a(iWorld, iChunkGenerator, sharedSeedRandom, \u26033.field_77276_a, \u26033.field_77275_b)).func_75069_d() ? \u2603 : field_202376_c) : field_202376_c;
        if (\u26032.func_75069_d()) {
            iWorld.func_72863_F().func_201713_d(\u26033.field_77276_a, \u26033.field_77275_b, true).func_201584_a(this.func_143025_a(), \u26032);
        }
        long2ObjectMap.put(l, (Object)\u26032);
        return \u26032;
    }

    protected ChunkPos func_211744_a(IChunkGenerator<?> iChunkGenerator, Random random, int n, int n2, int n3, int n4) {
        return new ChunkPos(n + n3, n2 + n4);
    }

    protected abstract boolean func_202372_a(IChunkGenerator<?> var1, Random var2, int var3, int var4);

    protected abstract boolean func_202365_a(IWorld var1);

    protected abstract StructureStart func_202369_a(IWorld var1, IChunkGenerator<?> var2, SharedSeedRandom var3, int var4, int var5);

    protected abstract String func_143025_a();

    public abstract int func_202367_b();
}

