/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.OceanMonumentConfig;
import net.minecraft.world.gen.feature.structure.OceanMonumentPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;

public class OceanMonumentStructure
extends Structure<OceanMonumentConfig> {
    private static final List<Biome.SpawnListEntry> field_175803_h = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_200761_A, 1, 2, 4)});

    @Override
    protected ChunkPos func_211744_a(IChunkGenerator<?> iChunkGenerator, Random random, int n, int n2, int n3, int n4) {
        \u2603 = iChunkGenerator.func_201496_a_().func_202174_b();
        \u2603 = iChunkGenerator.func_201496_a_().func_202171_c();
        \u2603 = n + \u2603 * n3;
        \u2603 = n2 + \u2603 * n4;
        \u2603 = \u2603 < 0 ? \u2603 - \u2603 + 1 : \u2603;
        \u2603 = \u2603 < 0 ? \u2603 - \u2603 + 1 : \u2603;
        \u2603 = \u2603 / \u2603;
        \u2603 = \u2603 / \u2603;
        ((SharedSeedRandom)random).func_202427_a(iChunkGenerator.func_202089_c(), \u2603, \u2603, 10387313);
        \u2603 *= \u2603;
        \u2603 *= \u2603;
        return new ChunkPos(\u2603 += (random.nextInt(\u2603 - \u2603) + random.nextInt(\u2603 - \u2603)) / 2, \u2603 += (random.nextInt(\u2603 - \u2603) + random.nextInt(\u2603 - \u2603)) / 2);
    }

    @Override
    protected boolean func_202372_a(IChunkGenerator<?> iChunkGenerator2, Random random, int n, int n2) {
        ChunkPos chunkPos = this.func_211744_a(iChunkGenerator2, random, n, n2, 0, 0);
        if (n == chunkPos.field_77276_a && n2 == chunkPos.field_77275_b) {
            IChunkGenerator<?> iChunkGenerator2;
            Set<Biome> set = iChunkGenerator2.func_202090_b().func_201538_a(n * 16 + 9, n2 * 16 + 9, 16);
            for (Biome biome : set) {
                if (iChunkGenerator2.func_202094_a(biome, Feature.field_202336_n)) continue;
                return false;
            }
            Set<Biome> \u26032 = iChunkGenerator2.func_202090_b().func_201538_a(n * 16 + 9, n2 * 16 + 9, 29);
            for (Biome biome : \u26032) {
                if (biome.func_201856_r() == Biome.Category.OCEAN || biome.func_201856_r() == Biome.Category.RIVER) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean func_202365_a(IWorld iWorld) {
        return iWorld.func_72912_H().func_76089_r();
    }

    @Override
    protected StructureStart func_202369_a(IWorld iWorld, IChunkGenerator<?> iChunkGenerator, SharedSeedRandom sharedSeedRandom, int n, int n2) {
        Biome biome = iChunkGenerator.func_202090_b().func_180300_a(new BlockPos((n << 4) + 9, 0, (n2 << 4) + 9), Biomes.field_180279_ad);
        return new Start(iWorld, sharedSeedRandom, n, n2, biome);
    }

    @Override
    protected String func_143025_a() {
        return "Monument";
    }

    @Override
    public int func_202367_b() {
        return 8;
    }

    @Override
    public List<Biome.SpawnListEntry> func_202279_e() {
        return field_175803_h;
    }

    public static class Start
    extends StructureStart {
        private final Set<ChunkPos> field_175791_c = Sets.newHashSet();
        private boolean field_175790_d;

        public Start() {
        }

        public Start(IWorld iWorld, SharedSeedRandom sharedSeedRandom, int n, int n2, Biome biome) {
            super(n, n2, biome, sharedSeedRandom, iWorld.func_72905_C());
            this.func_175789_b(iWorld, sharedSeedRandom, n, n2);
        }

        private void func_175789_b(IBlockReader iBlockReader, Random random, int n, int n2) {
            \u2603 = n * 16 - 29;
            \u2603 = n2 * 16 - 29;
            EnumFacing enumFacing = EnumFacing.Plane.HORIZONTAL.func_179518_a(random);
            this.field_75075_a.add(new OceanMonumentPieces.MonumentBuilding(random, \u2603, \u2603, enumFacing));
            this.func_202500_a(iBlockReader);
            this.field_175790_d = true;
        }

        @Override
        public void func_75068_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            if (!this.field_175790_d) {
                this.field_75075_a.clear();
                this.func_175789_b(iWorld, random, this.func_143019_e(), this.func_143018_f());
            }
            super.func_75068_a(iWorld, random, mutableBoundingBox, chunkPos);
        }

        @Override
        public void func_175787_b(ChunkPos chunkPos) {
            super.func_175787_b(chunkPos);
            this.field_175791_c.add(chunkPos);
        }

        @Override
        public void func_143022_a(NBTTagCompound nBTTagCompound2) {
            NBTTagCompound nBTTagCompound2;
            super.func_143022_a(nBTTagCompound2);
            NBTTagList nBTTagList = new NBTTagList();
            for (ChunkPos chunkPos : this.field_175791_c) {
                NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
                nBTTagCompound3.func_74768_a("X", chunkPos.field_77276_a);
                nBTTagCompound3.func_74768_a("Z", chunkPos.field_77275_b);
                nBTTagList.add(nBTTagCompound3);
            }
            nBTTagCompound2.func_74782_a("Processed", nBTTagList);
        }

        @Override
        public void func_143017_b(NBTTagCompound nBTTagCompound) {
            super.func_143017_b(nBTTagCompound);
            if (nBTTagCompound.func_150297_b("Processed", 9)) {
                NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Processed", 10);
                for (int i = 0; i < nBTTagList.size(); ++i) {
                    NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
                    this.field_175791_c.add(new ChunkPos(nBTTagCompound2.func_74762_e("X"), nBTTagCompound2.func_74762_e("Z")));
                }
            }
        }
    }
}

