/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.PhantomSpawner;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.AbstractChunkGenerator;
import net.minecraft.world.gen.FlatGenSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.WorldCarverWrapper;
import net.minecraft.world.gen.feature.CompositeFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.CompositeSurfaceBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkGeneratorFlat
extends AbstractChunkGenerator<FlatGenSettings> {
    private static final Logger field_202101_d = LogManager.getLogger();
    private final FlatGenSettings field_82699_e;
    private final Biome field_202103_f;
    private final PhantomSpawner field_203229_i = new PhantomSpawner();

    public ChunkGeneratorFlat(IWorld iWorld, BiomeProvider biomeProvider, FlatGenSettings flatGenSettings) {
        super(iWorld, biomeProvider);
        this.field_82699_e = flatGenSettings;
        this.field_202103_f = this.func_202099_e();
    }

    private Biome func_202099_e() {
        boolean bl;
        Biome biome = this.field_82699_e.func_82648_a();
        BiomeWrapper \u26032 = new BiomeWrapper(biome.func_205401_q(), biome.func_201851_b(), biome.func_201856_r(), biome.func_185355_j(), biome.func_185360_m(), biome.func_185353_n(), biome.func_76727_i(), biome.func_185361_o(), biome.func_204274_p(), biome.func_205402_s());
        Map<String, Map<String, String>> \u26033 = this.field_82699_e.func_82644_b();
        for (String string : \u26033.keySet()) {
            CompositeFeature<?, ?>[] compositeFeatureArray = FlatGenSettings.field_202247_j.get(string);
            if (compositeFeatureArray == null) continue;
            CompositeFeature<?, ?>[] compositeFeatureArray2 = compositeFeatureArray;
            int n = compositeFeatureArray2.length;
            for (int i = 0; i < n; ++i) {
                CompositeFeature<?, ?> compositeFeature = compositeFeatureArray2[i];
                \u26032.func_203611_a(FlatGenSettings.field_202248_k.get(compositeFeature), compositeFeature);
                Feature<?> feature = compositeFeature.func_202349_a();
                if (!(feature instanceof Structure)) continue;
                IFeatureConfig \u26035 = biome.func_201857_b((Structure)feature);
                \u26032.func_201865_a((Structure)feature, \u26035 != null ? \u26035 : FlatGenSettings.field_202249_l.get(compositeFeature));
            }
        }
        boolean bl2 = bl = (!this.field_82699_e.func_202238_o() || biome == Biomes.field_185440_P) && \u26033.containsKey("decoration");
        if (bl) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(GenerationStage.Decoration.UNDERGROUND_STRUCTURES);
            arrayList.add(GenerationStage.Decoration.SURFACE_STRUCTURES);
            for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
                if (arrayList.contains((Object)decoration)) continue;
                for (CompositeFeature<?, ?> compositeFeature : biome.func_203607_a(decoration)) {
                    \u26032.func_203611_a(decoration, compositeFeature);
                }
            }
        }
        return \u26032;
    }

    @Override
    public void func_202088_a(IChunk iChunk) {
        ChunkPos chunkPos = iChunk.func_76632_l();
        int \u26032 = chunkPos.field_77276_a;
        int \u26033 = chunkPos.field_77275_b;
        Biome[] \u26034 = this.field_202097_c.func_201539_b(\u26032 * 16, \u26033 * 16, 16, 16);
        iChunk.func_201577_a(\u26034);
        this.func_202100_a(\u26032, \u26033, iChunk);
        iChunk.func_201588_a(Heightmap.Type.WORLD_SURFACE_WG, Heightmap.Type.OCEAN_FLOOR_WG);
        iChunk.func_201574_a(ChunkStatus.BASE);
    }

    @Override
    public void func_202091_a(WorldGenRegion worldGenRegion, GenerationStage.Carving carving) {
        int n = 8;
        \u2603 = worldGenRegion.func_201679_a();
        \u2603 = worldGenRegion.func_201680_b();
        BitSet \u26032 = new BitSet(65536);
        SharedSeedRandom \u26033 = new SharedSeedRandom();
        for (\u2603 = \u2603 - 8; \u2603 <= \u2603 + 8; ++\u2603) {
            for (\u2603 = \u2603 - 8; \u2603 <= \u2603 + 8; ++\u2603) {
                List<WorldCarverWrapper<?>> list = this.field_202103_f.func_203603_a(GenerationStage.Carving.AIR);
                ListIterator<WorldCarverWrapper<?>> \u26034 = list.listIterator();
                while (\u26034.hasNext()) {
                    int n2 = \u26034.nextIndex();
                    WorldCarverWrapper<?> \u26035 = \u26034.next();
                    \u26033.func_202425_c(worldGenRegion.func_201672_e().func_72905_C() + (long)n2, \u2603, \u2603);
                    if (!\u26035.func_212246_a((IBlockReader)worldGenRegion, (Random)\u26033, \u2603, \u2603, IFeatureConfig.field_202429_e)) continue;
                    \u26035.func_202522_a((IWorld)worldGenRegion, (Random)\u26033, \u2603, \u2603, \u2603, \u2603, \u26032, IFeatureConfig.field_202429_e);
                }
            }
        }
    }

    @Override
    public FlatGenSettings func_201496_a_() {
        return this.field_82699_e;
    }

    @Override
    public double[] func_205473_a(int n, int n2) {
        return new double[0];
    }

    @Override
    public int func_205470_d() {
        IChunk iChunk = this.field_202095_a.func_72964_e(0, 0);
        return iChunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 8, 8);
    }

    @Override
    public void func_202092_b(WorldGenRegion worldGenRegion) {
        int n = worldGenRegion.func_201679_a();
        \u2603 = worldGenRegion.func_201680_b();
        \u2603 = n * 16;
        \u2603 = \u2603 * 16;
        BlockPos \u26032 = new BlockPos(\u2603, 0, \u2603);
        SharedSeedRandom \u26033 = new SharedSeedRandom();
        long \u26034 = \u26033.func_202424_a(worldGenRegion.func_72905_C(), \u2603, \u2603);
        for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
            this.field_202103_f.func_203608_a(decoration, this, worldGenRegion, \u26034, \u26033, \u26032);
        }
    }

    @Override
    public void func_202093_c(WorldGenRegion worldGenRegion) {
    }

    public void func_202100_a(int n, int n2, IChunk iChunk) {
        IBlockState[] iBlockStateArray = this.field_82699_e.func_202233_q();
        BlockPos.MutableBlockPos \u26032 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < iBlockStateArray.length; ++i) {
            IBlockState iBlockState = iBlockStateArray[i];
            if (iBlockState == null) continue;
            for (int j = 0; j < 16; ++j) {
                for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                    iChunk.func_177436_a(\u26032.func_181079_c(j, i, \u2603), iBlockState, false);
                }
            }
        }
    }

    @Override
    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType enumCreatureType, BlockPos blockPos) {
        Biome biome = this.field_202095_a.func_180494_b(blockPos);
        return biome.func_76747_a(enumCreatureType);
    }

    @Override
    public int func_203222_a(World world, boolean bl, boolean bl2) {
        int n = 0;
        return n += this.field_203229_i.func_203232_a(world, bl, bl2);
    }

    @Override
    public boolean func_202094_a(Biome biome, Structure<? extends IFeatureConfig> structure) {
        return this.field_202103_f.func_201858_a(structure);
    }

    @Override
    @Nullable
    public IFeatureConfig func_202087_b(Biome biome, Structure<? extends IFeatureConfig> structure) {
        return this.field_202103_f.func_201857_b(structure);
    }

    @Override
    @Nullable
    public BlockPos func_211403_a(World world, String string, BlockPos blockPos, int n, boolean bl) {
        if (!this.field_82699_e.func_82644_b().keySet().contains(string)) {
            return null;
        }
        return super.func_211403_a(world, string, blockPos, n, bl);
    }

    @Override
    public /* synthetic */ IChunkGenSettings func_201496_a_() {
        return this.func_201496_a_();
    }

    class BiomeWrapper
    extends Biome {
        protected BiomeWrapper(CompositeSurfaceBuilder<?> compositeSurfaceBuilder, Biome.RainType rainType, Biome.Category category, float f, float f2, float f3, float f4, int n, int n2, @Nullable String string) {
            super(new Biome.BiomeBuilder().func_205416_a(compositeSurfaceBuilder).func_205415_a(rainType).func_205419_a(category).func_205421_a(f).func_205420_b(f2).func_205414_c(f3).func_205417_d(f4).func_205412_a(n).func_205413_b(n2).func_205418_a(string));
        }
    }
}

